/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.LivingDamageEvent;
import net.blay09.mods.balm.api.event.PlayerRespawnEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.hardcorerevival.HardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.PlayerHardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.api.PlayerAboutToKnockOutEvent;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.minecraft.class_10216;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4050;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class KnockoutHandler {
    public static void initialize() {
        Balm.getEvents().onEvent(LivingDamageEvent.class, KnockoutHandler::onPlayerDamage);
        Balm.getEvents().onEvent(PlayerRespawnEvent.class, KnockoutHandler::onPlayerRespawn);
        Balm.getEvents().onTickEvent(TickType.ServerPlayer, TickPhase.Start, KnockoutHandler::onPlayerTick);
    }

    public static void onPlayerDamage(LivingDamageEvent event) {
        class_1309 class_13092 = event.getEntity();
        if (class_13092 instanceof class_3222) {
            boolean wouldDie;
            class_3222 player = (class_3222)class_13092;
            class_1282 damageSource = event.getDamageSource();
            if (PlayerHardcoreRevivalManager.isKnockedOut((class_1657)player)) {
                class_1297 attacker = damageSource.method_5529();
                if (attacker instanceof class_1308) {
                    class_1308 mob = (class_1308)attacker;
                    mob.method_5980(null);
                }
                if (!damageSource.method_48789(class_8103.field_42242) && !damageSource.method_49708(HardcoreRevivalManager.NOT_RESCUED_IN_TIME)) {
                    event.setCanceled(true);
                }
                return;
            }
            boolean bl = wouldDie = player.method_6032() - event.getDamageAmount() <= 0.0f;
            if (wouldDie && KnockoutHandler.isKnockoutEnabledFor(player, damageSource)) {
                PlayerAboutToKnockOutEvent aboutToKnockOutEvent = new PlayerAboutToKnockOutEvent((class_1657)player, damageSource);
                Balm.getEvents().fireEvent((Object)aboutToKnockOutEvent);
                if (!aboutToKnockOutEvent.isCanceled()) {
                    event.setDamageAmount(Math.min(event.getDamageAmount(), Math.max(0.0f, player.method_6032() - 1.0f)));
                    HardcoreRevivalManager.knockout(player, damageSource);
                }
            }
        }
    }

    private static boolean holdsDeathProtectionItem(class_3222 player) {
        for (class_1268 hand : class_1268.values()) {
            class_1799 itemStack = player.method_5998(hand);
            class_10216 deathProtection = (class_10216)itemStack.method_58694(class_9334.field_54274);
            if (deathProtection == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isKnockoutEnabledFor(class_3222 player, class_1282 damageSource) {
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return false;
        }
        boolean canDamageSourceKnockout = !damageSource.method_49708(class_8111.field_42347) && !damageSource.method_49708(HardcoreRevivalManager.NOT_RESCUED_IN_TIME);
        class_2960 damageSourceId = player.method_5682().method_30611().method_30530(class_7924.field_42534).method_10221((Object)damageSource.method_48792());
        if (!canDamageSourceKnockout || HardcoreRevivalConfig.getActive().instantDeathSources.contains(damageSourceId)) {
            return false;
        }
        if (HardcoreRevivalConfig.getActive().disableInSingleplayer && server.method_3724() && server.method_3788() == 1) {
            return false;
        }
        if (HardcoreRevivalConfig.getActive().disableInLonelyMultiplayer && !server.method_3724() && server.method_3788() == 1) {
            return false;
        }
        return !KnockoutHandler.holdsDeathProtectionItem(player);
    }

    public static void onPlayerTick(class_3222 player) {
        if (PlayerHardcoreRevivalManager.isKnockedOut((class_1657)player) && player.method_5805()) {
            int maxTicksUntilDeath;
            player.method_6033(1.0f);
            PlayerHardcoreRevivalManager.setKnockoutTicksPassed((class_1657)player, PlayerHardcoreRevivalManager.getKnockoutTicksPassed((class_1657)player) + 1);
            if (player.field_6012 % 20 == 0) {
                Balm.getHooks().setForcedPose((class_1657)player, (class_4050)(PlayerHardcoreRevivalManager.isKnockedOut((class_1657)player) ? class_4050.field_18077 : null));
            }
            if ((maxTicksUntilDeath = HardcoreRevivalConfig.getActive().secondsUntilDeath * 20) > 0 && PlayerHardcoreRevivalManager.getKnockoutTicksPassed((class_1657)player) >= maxTicksUntilDeath && player.method_65350()) {
                HardcoreRevivalManager.notRescuedInTime((class_1657)player);
            }
        }
    }

    public static void onPlayerRespawn(PlayerRespawnEvent event) {
        HardcoreRevivalManager.reset((class_1657)event.getNewPlayer());
    }
}

