/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.PlayerAttackEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.balm.api.event.UseBlockEvent;
import net.blay09.mods.balm.api.event.UseItemEvent;
import net.blay09.mods.hardcorerevival.HardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.PlayerHardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.handler.KnockoutSyncHandler;
import net.blay09.mods.hardcorerevival.network.RevivalProgressMessage;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class RescueHandler {
    public static void initialize() {
        Balm.getEvents().onEvent(UseItemEvent.class, RescueHandler::onUseItem);
        Balm.getEvents().onEvent(UseBlockEvent.class, RescueHandler::onUseBlock);
        Balm.getEvents().onEvent(PlayerAttackEvent.class, RescueHandler::onAttack);
        Balm.getEvents().onTickEvent(TickType.ServerPlayer, TickPhase.End, RescueHandler::onPlayerTick);
    }

    public static void onUseItem(UseItemEvent event) {
        if (HardcoreRevivalManager.isRescuing(event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    public static void onUseBlock(UseBlockEvent event) {
        if (HardcoreRevivalManager.isRescuing(event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    public static void onAttack(PlayerAttackEvent event) {
        HardcoreRevivalManager.abortRescue(event.getPlayer());
    }

    public static void onPlayerTick(class_3222 player) {
        class_1657 rescueTarget = PlayerHardcoreRevivalManager.getRescueTarget((class_1657)player);
        if (rescueTarget != null) {
            int knockoutTicksPassed = PlayerHardcoreRevivalManager.getKnockoutTicksPassed(rescueTarget);
            int maxTicksUntilDeath = HardcoreRevivalConfig.getActive().secondsUntilDeath * 20;
            if (!rescueTarget.method_5805() || maxTicksUntilDeath > 0 && knockoutTicksPassed >= maxTicksUntilDeath) {
                HardcoreRevivalManager.abortRescue((class_1657)player);
            } else {
                float dist = player.method_5739((class_1297)rescueTarget);
                if ((double)dist > HardcoreRevivalConfig.getActive().rescueDistance) {
                    HardcoreRevivalManager.abortRescue((class_1657)player);
                } else {
                    int rescueTime = PlayerHardcoreRevivalManager.getRescueTime((class_1657)player) + 1;
                    PlayerHardcoreRevivalManager.setRescueTime((class_1657)player, rescueTime);
                    PlayerHardcoreRevivalManager.setKnockoutTicksPassed(rescueTarget, knockoutTicksPassed - 1);
                    int maxRescueActionTicks = HardcoreRevivalConfig.getActive().rescueActionTicks;
                    int step = maxRescueActionTicks / 4;
                    if (rescueTime >= maxRescueActionTicks) {
                        HardcoreRevivalManager.finishRescue((class_1657)player);
                    } else if (rescueTime % step == 0) {
                        Balm.getNetworking().sendTo((class_1657)player, (class_8710)new RevivalProgressMessage(rescueTarget.method_5628(), (float)rescueTime / (float)maxRescueActionTicks));
                        KnockoutSyncHandler.sendHardcoreRevivalData(rescueTarget, rescueTarget, true);
                    }
                }
            }
        }
    }
}

