/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.glObject.shader;

import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL32;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class Shader {
    public final int id;

    public Shader(int type, String path, boolean absoluteFilePath) {
        GLProxy.GL_LOGGER.info("Loading shader at [" + path + "]", new Object[0]);
        this.id = GL32.glCreateShader((int)type);
        if (this.id == 0) {
            throw new IllegalArgumentException("Failed to create shader with type [" + type + "].");
        }
        StringBuilder source = Shader.loadFile(path, absoluteFilePath, new StringBuilder());
        Shader.safeShaderSource(this.id, source);
        GL32.glCompileShader((int)this.id);
        int status = GL32.glGetShaderi((int)this.id, (int)35713);
        if (status != 1) {
            String message = "Shader compiler error. Details: [" + GL32.glGetShaderInfoLog((int)this.id) + "].";
            this.free();
            throw new RuntimeException(message);
        }
        GLProxy.GL_LOGGER.info("Shader at " + path + " loaded successfully.", new Object[0]);
    }

    public Shader(int type, String sourceString) {
        GLProxy.GL_LOGGER.info("Loading shader with type: [" + type + "]", new Object[0]);
        GLProxy.GL_LOGGER.debug("Source: \n[" + sourceString + "]", new Object[0]);
        if (sourceString == null || sourceString.isEmpty()) {
            throw new IllegalArgumentException("No shader source given.");
        }
        this.id = GL32.glCreateShader((int)type);
        if (this.id == 0) {
            throw new IllegalArgumentException("Failed to create shader with type [" + type + "] and Source: \n[" + sourceString + "].");
        }
        Shader.safeShaderSource(this.id, sourceString);
        GL32.glCompileShader((int)this.id);
        int status = GL32.glGetShaderi((int)this.id, (int)35713);
        if (status != 1) {
            String message = "Shader compiler error. Details: [" + GL32.glGetShaderInfoLog((int)this.id) + "]\n";
            message = message + "Source: \n[" + sourceString + "]";
            this.free();
            throw new RuntimeException(message);
        }
        GLProxy.GL_LOGGER.info("Shader loaded sucessfully.", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void safeShaderSource(@NativeType(value="GLuint") int glId, @NativeType(value="GLchar const **") CharSequence source) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer sourceBuffer = MemoryUtil.memUTF8((CharSequence)source, (boolean)true);
            PointerBuffer pointers = stack.mallocPointer(1);
            pointers.put(sourceBuffer);
            GL32.nglShaderSource((int)glId, (int)1, (long)pointers.address0(), (long)0L);
            APIUtil.apiArrayFree((long)pointers.address0(), (int)1);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public void free() {
        GL32.glDeleteShader((int)this.id);
    }

    public static StringBuilder loadFile(String path, boolean absoluteFilePath, StringBuilder stringBuilder) {
        try {
            String line;
            InputStream in;
            if (absoluteFilePath) {
                in = new FileInputStream(path);
            } else {
                in = Shader.class.getClassLoader().getResourceAsStream(path);
                if (in == null) {
                    throw new FileNotFoundException("Shader file not found in resource: " + path);
                }
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line).append("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load shader from file [" + path + "]. Error: " + e.getMessage());
        }
        return stringBuilder;
    }
}

