/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.fabric.testing;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.interfaces.block.IDhApiBlockStateWrapper;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiChunkProcessingEvent;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiEventParam;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public class TestChunkInputReplacerEvent
extends DhApiChunkProcessingEvent {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final String REPLACEMENT_BLOCK_STATE_NAMESPACE = "minecraft:stone";
    private IDhApiBlockStateWrapper stoneBlockWrapper = null;
    private boolean initialBlockSetupComplete = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockOrBiomeChangedDuringChunkProcessing(DhApiEventParam<DhApiChunkProcessingEvent.EventParam> event) {
        if (!this.initialBlockSetupComplete) {
            TestChunkInputReplacerEvent testChunkInputReplacerEvent = this;
            synchronized (testChunkInputReplacerEvent) {
                this.initialBlockSetupComplete = true;
                try {
                    this.stoneBlockWrapper = DhApi.Delayed.wrapperFactory.getDefaultBlockStateWrapper(REPLACEMENT_BLOCK_STATE_NAMESPACE, ((DhApiChunkProcessingEvent.EventParam)event.value).levelWrapper);
                }
                catch (IOException e) {
                    LOGGER.error("Unable to get [minecraft:stone] block replacement cannot continue and is now disabled, error: [" + e.getMessage() + "].", (Throwable)e);
                    DhApi.events.unbind(DhApiChunkProcessingEvent.class, this.getClass());
                }
            }
        }
        if (this.stoneBlockWrapper == null) {
            return;
        }
        IDhApiBlockStateWrapper block = ((DhApiChunkProcessingEvent.EventParam)event.value).currentBlock;
        if (block.getSerialString().contains("grass_block") || block.getSerialString().contains("dirt")) {
            ((DhApiChunkProcessingEvent.EventParam)event.value).setBlockOverride(this.stoneBlockWrapper);
        }
    }
}

