/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.electricity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.electricity.NodeSearchResult;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;

public interface ISourceNode
extends IElectricityNode {
    public static final class_238 DEFAULT_NODE_BOX = new class_238(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);

    public void setNodeOverloaded(boolean var1);

    public boolean isNodeOverloaded();

    default public void onNodeOverloaded() {
    }

    default public int getMaxPowerableNodes() {
        return (Integer)Config.SERVER.electricity.maximumNodesInNetwork.get();
    }

    @Override
    default public boolean isSourceNode() {
        return true;
    }

    @Override
    default public boolean canPowerTraverseNode() {
        return false;
    }

    @Override
    default public class_238 getNodeInteractBox() {
        return DEFAULT_NODE_BOX;
    }

    @Override
    default public void setNodeReceivingPower(boolean state) {
    }

    @Override
    default public boolean isNodeReceivingPower() {
        return false;
    }

    @Override
    default public Set<class_2338> getPowerSources() {
        return new HashSet<class_2338>(Collections.singleton(this.getNodePosition()));
    }

    @Override
    default public boolean isNodeInPowerableNetwork(class_2338 source) {
        return true;
    }

    @Override
    default public void readNodeNbt(class_11368 input) {
        IElectricityNode.super.readNodeNbt(input);
        this.setNodeOverloaded(input.method_71433("Overloaded", false));
    }

    @Override
    default public void writeNodeNbt(class_11372 output) {
        IElectricityNode.super.writeNodeNbt(output);
        output.method_71472("Overloaded", this.isNodeOverloaded());
    }

    @Override
    default public void earlyNodeTick(class_1937 level) {
        if (!level.method_8608()) {
            if (this.isNodePowered() && !this.isNodeOverloaded()) {
                NodeSearchResult result = this.searchNodeNetwork(false);
                if (result.overloaded()) {
                    this.setNodeOverloaded(true);
                    this.onNodeOverloaded();
                    return;
                }
                result.nodes().forEach(node -> node.setNodeReceivingPower(true));
            }
        } else {
            NodeSearchResult result = this.searchNodeNetwork(true);
            result.nodes().forEach(node -> node.getPowerSources().add(this.getNodePosition()));
        }
    }

    default public NodeSearchResult searchNodeNetwork(boolean cancelAtLimit) {
        List<IElectricityNode> nodes = IElectricityNode.searchNodes(this, this.getMaxPowerableNodes(), cancelAtLimit, node -> !node.isSourceNode() && node.canPowerTraverseNode(), node -> !node.isSourceNode());
        boolean overloaded = nodes.size() > this.getMaxPowerableNodes();
        return new NodeSearchResult(overloaded, nodes);
    }

    public static class_238 createPowerableZone(class_1937 level, class_2338 pos) {
        double radius = ((Integer)Config.SERVER.electricity.powerableAreaRadius.get()).intValue();
        double minX = (double)pos.method_10263() - radius;
        double minY = (double)pos.method_10264() - radius;
        double minZ = (double)pos.method_10260() - radius;
        double maxX = (double)pos.method_10263() + radius + 1.0;
        double maxY = (double)pos.method_10264() + radius + 1.0;
        double maxZ = (double)pos.method_10260() + radius + 1.0;
        minY = Math.max(minY, (double)level.method_31607());
        maxY = Math.min(maxY, (double)level.method_31600());
        return new class_238(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

