/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.image;

import com.mrcrayfish.furniture.refurbished.blockentity.IPaintable;
import com.mrcrayfish.furniture.refurbished.image.PaletteImage;
import com.mrcrayfish.furniture.refurbished.platform.ClientServices;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class TextureCache {
    private static final long EXPIRE_TIME = 10000L;
    private static TextureCache instance;
    private final Map<class_2960, Entry> entries = new HashMap<class_2960, Entry>();

    public static TextureCache get() {
        if (instance == null) {
            instance = new TextureCache();
        }
        return instance;
    }

    private TextureCache() {
    }

    public void tick() {
        this.entries.entrySet().removeIf(e -> {
            Entry entry = (Entry)e.getValue();
            if (entry.isExpired()) {
                entry.release();
                return true;
            }
            return false;
        });
    }

    @Nullable
    public class_2960 getOrCacheImage(IPaintable paintable) {
        PaletteImage image = paintable.getImage();
        if (image != null) {
            Entry entry = this.entries.get(image.getId());
            if (entry == null || entry.isExpired()) {
                if (entry != null) {
                    entry.release();
                }
                entry = new Entry(image);
                this.entries.put(image.getId(), entry);
            }
            entry.ping();
            return image.getId();
        }
        return null;
    }

    @Nullable
    public class_1921 getRenderType(IPaintable paintable) {
        class_2960 id = this.getOrCacheImage(paintable);
        Entry entry = this.entries.get(id);
        if (entry != null && !entry.isExpired()) {
            return entry.getRenderType();
        }
        return null;
    }

    public class_1044 getTexture(class_2960 id) {
        Entry entry = this.entries.get(id);
        if (entry != null && !entry.isExpired()) {
            return entry.texture;
        }
        return class_310.method_1551().method_1531().method_4619(class_1047.method_4539());
    }

    private static class_1011 convertToNativeImage(PaletteImage image) {
        class_1011 nativeImage = new class_1011(image.width, image.height, false);
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                nativeImage.method_61941(x, y, PaletteImage.COLOURS[image.get(x, y)]);
            }
        }
        return nativeImage;
    }

    private static class Entry {
        private final class_2960 id;
        private final class_1043 texture;
        private final class_1921 renderType;
        private long lastDrawTime;
        private boolean expired;

        public Entry(PaletteImage image) {
            this.id = image.getId();
            this.texture = new class_1043(() -> "PaletteImage " + String.valueOf(this.id), TextureCache.convertToNativeImage(image));
            class_310.method_1551().method_1531().method_4616(image.getId(), (class_1044)this.texture);
            this.lastDrawTime = class_156.method_658();
            this.renderType = ClientServices.PLATFORM.createPaletteImageRenderType(this.id);
        }

        public class_2960 getId() {
            return this.id;
        }

        public class_1921 getRenderType() {
            return this.renderType;
        }

        public void ping() {
            this.lastDrawTime = class_156.method_658();
        }

        public boolean isExpired() {
            return this.expired || class_156.method_658() - this.lastDrawTime > 10000L;
        }

        public void release() {
            if (!this.expired) {
                class_310.method_1551().method_1531().method_4615(this.id);
                this.expired = true;
            }
        }
    }
}

