/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.iron;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.SlotConfiguration;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.util.RebornInventory;
import techreborn.config.TechRebornConfig;

public abstract class AbstractIronMachineBlockEntity
extends MachineBaseBlockEntity
implements InventoryProvider,
IToolDrop,
SlotConfiguration.SlotFilter {
    public RebornInventory<?> inventory;
    public int burnTime;
    public int totalBurnTime;
    public int progress;
    final int fuelSlot;
    final class_2248 toolDrop;

    public AbstractIronMachineBlockEntity(class_2591<?> blockEntityTypeIn, class_2338 pos, class_2680 state, int fuelSlot, class_2248 toolDrop) {
        super(blockEntityTypeIn, pos, state);
        this.fuelSlot = fuelSlot;
        this.toolDrop = toolDrop;
    }

    protected abstract boolean canSmelt();

    protected abstract void smelt();

    protected abstract int cookingTime();

    private int getItemBurnTime(class_1799 stack) {
        if (stack.method_7960() || this.field_11863 == null) {
            return 0;
        }
        return (int)((double)this.field_11863.method_61269().method_61755(stack) * TechRebornConfig.fuelScale);
    }

    public int getBurnTimeRemainingScaled(int scale) {
        if (this.totalBurnTime == 0) {
            return 0;
        }
        return this.burnTime * scale / this.totalBurnTime;
    }

    public int getProgressScaled(int scale) {
        if (this.cookingTime() > 0) {
            return this.progress * scale / this.cookingTime();
        }
        return 0;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    private void updateState() {
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)class_22482;
            if ((Boolean)state.method_11654((class_2769)BlockMachineBase.ACTIVE) != this.burnTime > 0) {
                blockMachineBase.setActive(Boolean.valueOf(this.burnTime > 0), this.field_11863, this.field_11867);
            }
        }
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.burnTime = view.method_71424("BurnTime", 0);
        this.totalBurnTime = view.method_71424("TotalBurnTime", 0);
        this.progress = view.method_71424("Progress", 0);
    }

    public void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71465("BurnTime", this.burnTime);
        view.method_71465("TotalBurnTime", this.totalBurnTime);
        view.method_71465("Progress", this.progress);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world.field_9236) {
            return;
        }
        boolean isBurning = this.isBurning();
        if (isBurning) {
            --this.burnTime;
        }
        boolean canSmelt = this.canSmelt();
        if (!isBurning && canSmelt) {
            this.burnTime = this.totalBurnTime = this.getItemBurnTime(this.inventory.method_5438(this.fuelSlot));
            if (this.burnTime > 0) {
                class_1799 fuelStack = this.inventory.method_5438(this.fuelSlot);
                class_1799 remainderStack = fuelStack.method_7909().method_7858();
                if (!remainderStack.method_7960()) {
                    this.inventory.method_5447(this.fuelSlot, remainderStack);
                } else if (fuelStack.method_7947() > 1) {
                    this.inventory.shrinkSlot(this.fuelSlot, 1);
                } else if (fuelStack.method_7947() == 1) {
                    this.inventory.method_5447(this.fuelSlot, class_1799.field_8037);
                }
            }
        }
        if (this.isBurning() && canSmelt) {
            ++this.progress;
            if (this.progress == this.cookingTime()) {
                this.progress = 0;
                this.smelt();
            }
        } else if (!canSmelt) {
            this.progress = 0;
        }
        if (isBurning != this.isBurning()) {
            this.inventory.setHashChanged();
            this.updateState();
        }
        if (this.inventory.hasChanged()) {
            this.method_5431();
        }
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public RebornInventory<?> getInventory() {
        return this.inventory;
    }

    public class_1799 getToolDrop(class_1657 entityPlayer) {
        return new class_1799((class_1935)this.toolDrop);
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getTotalBurnTime() {
        return this.totalBurnTime;
    }

    public void setTotalBurnTime(int totalBurnTime) {
        this.totalBurnTime = totalBurnTime;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }
}

