/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.rei;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.displays.crafting.CraftingDisplay;
import net.minecraft.class_1799;
import net.minecraft.class_1869;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import reborncore.common.crafting.RebornRecipe;
import techreborn.init.ModRecipes;
import techreborn.recipe.recipes.RollingMachineRecipe;

public class RollingMachineDisplay
implements CraftingDisplay {
    public static final DisplaySerializer<RollingMachineDisplay> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(RollingMachineDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(RollingMachineDisplay::getOutputEntries), (App)class_2960.field_25139.optionalFieldOf("location").forGetter(RollingMachineDisplay::getDisplayLocation), (App)Codec.INT.fieldOf("width").forGetter(RollingMachineDisplay::getWidth), (App)Codec.INT.fieldOf("height").forGetter(RollingMachineDisplay::getHeight), (App)Codec.INT.fieldOf("energy").forGetter(RollingMachineDisplay::getEnergy), (App)Codec.INT.fieldOf("time").forGetter(RollingMachineDisplay::getTime)).apply((Applicative)instance, RollingMachineDisplay::new)), (class_9139)class_9139.method_64265((class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), RollingMachineDisplay::getInputEntries, (class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), RollingMachineDisplay::getOutputEntries, (class_9139)class_9135.method_56382((class_9139)class_2960.field_48267), RollingMachineDisplay::getDisplayLocation, (class_9139)class_9135.field_49675, RollingMachineDisplay::getWidth, (class_9139)class_9135.field_49675, RollingMachineDisplay::getHeight, (class_9139)class_9135.field_49675, RollingMachineDisplay::getEnergy, (class_9139)class_9135.field_49675, RollingMachineDisplay::getTime, RollingMachineDisplay::new));
    private final List<EntryIngredient> inputs;
    private final List<EntryIngredient> outputs;
    private final Optional<class_2960> location;
    private final int width;
    private final int height;
    private final int energy;
    private final int time;

    public RollingMachineDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<class_2960> location, int width, int height, int energy, int time) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.location = location;
        this.width = width;
        this.height = height;
        this.energy = energy;
        this.time = time;
    }

    public RollingMachineDisplay(class_8786<RebornRecipe> entry) {
        RollingMachineRecipe recipe = (RollingMachineRecipe)entry.comp_1933();
        this.energy = recipe.power();
        this.time = recipe.time();
        class_1869 shapedRecipe = recipe.getShapedRecipe();
        this.inputs = CollectionUtils.map((Collection)shapedRecipe.method_61693(), opt -> opt.map(EntryIngredients::ofIngredient).orElse(EntryIngredient.empty()));
        this.outputs = List.of(EntryIngredients.of((class_1799)shapedRecipe.method_17727(null, null)));
        this.location = Optional.of(entry.comp_1932().method_29177());
        this.width = shapedRecipe.method_8150();
        this.height = shapedRecipe.method_8158();
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getTime() {
        return this.time;
    }

    public boolean isShapeless() {
        return false;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Optional<class_2960> getDisplayLocation() {
        return this.location;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return CategoryIdentifier.of((class_2960)Objects.requireNonNull(class_7923.field_41188.method_10221(ModRecipes.ROLLING_MACHINE)));
    }

    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}

