/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import org.jetbrains.annotations.NotNull;
import reborncore.api.items.InventoryBase;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.SlotConfiguration;
import reborncore.common.util.IInventoryAccess;

public class RebornInventory<T extends MachineBaseBlockEntity>
extends InventoryBase {
    private final String name;
    private final int stackLimit;
    private final T blockEntity;
    private boolean hasChanged = false;
    private final IInventoryAccess<T> inventoryAccess;

    public RebornInventory(int size, String invName, int invStackLimit, T blockEntity, IInventoryAccess<T> access) {
        super(size);
        this.name = invName;
        this.stackLimit = invStackLimit == 64 ? class_1802.field_8162.method_7882() : invStackLimit;
        this.blockEntity = blockEntity;
        this.inventoryAccess = access;
    }

    public RebornInventory(int size, String invName, int invStackLimit, T blockEntity) {
        this(size, invName, invStackLimit, (MachineBaseBlockEntity)blockEntity, (slotID, stack, facing, direction, be) -> {
            if (facing == null) {
                return true;
            }
            return switch (direction) {
                default -> throw new MatchException(null, null);
                case IInventoryAccess.AccessDirection.INSERT -> SlotConfiguration.canInsertItem(slotID, stack, facing, be);
                case IInventoryAccess.AccessDirection.EXTRACT -> SlotConfiguration.canExtractItem(slotID, stack, facing, be);
            };
        });
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void method_5447(int slot, @NotNull class_1799 stack) {
        super.method_5447(slot, stack);
        this.setHashChanged();
    }

    @Override
    public class_1799 method_5434(int i, int i1) {
        class_1799 stack = super.method_5434(i, i1);
        if (!stack.method_7960()) {
            this.setHashChanged();
        }
        return stack;
    }

    public int method_5444() {
        return this.stackLimit;
    }

    public class_1799 shrinkSlot(int slot, int count) {
        class_1799 stack = this.method_5438(slot);
        stack.method_7934(count);
        this.setHashChanged();
        return stack;
    }

    public void read(class_11368 view) {
        this.read(view, "Items");
    }

    public void read(class_11368 view, String tag) {
        view.method_71420(tag).ifPresent(data -> {
            this.readData((class_11368)data);
            this.hasChanged = true;
        });
    }

    public void write(class_11372 view) {
        this.write(view, "Items");
    }

    public void write(class_11372 view, String tag) {
        this.writeData(view.method_71461(tag));
    }

    public int getContents() {
        int count = 0;
        for (class_1799 stack : this.getStacks()) {
            if (stack.method_7960()) continue;
            count += stack.method_7947();
        }
        return count;
    }

    public T getBlockEntity() {
        return this.blockEntity;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setHashChanged() {
        this.hasChanged = true;
        this.method_5431();
    }

    public void setHashChanged(boolean changed) {
        this.hasChanged = changed;
    }

    public void resetHasChanged() {
        this.hasChanged = false;
    }

    public int getStackLimit() {
        return this.stackLimit;
    }

    @Override
    public void method_5431() {
        super.method_5431();
        this.blockEntity.method_5431();
    }
}

