/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.api.command.BalmCommands;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.command.CountWaystonesCommand;
import net.blay09.mods.waystones.command.OpenPlayerWaystonesGuiCommand;
import net.blay09.mods.waystones.comparator.WaystoneComparators;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2300;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class ModCommands {
    private static final SimpleCommandExceptionType ERROR_WAYSTONE_NOT_FOUND = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.waystones.waystone_not_found"));
    private static final class_2960 PERMISSION_WAYSTONES_ACTIVATE = class_2960.method_60655((String)"waystones", (String)"command.waystones.activate");
    private static final class_2960 PERMISSION_WAYSTONES_FORGET = class_2960.method_60655((String)"waystones", (String)"command.waystones.forget");
    private static final class_2960 PERMISSION_WAYSTONES_COUNT = class_2960.method_60655((String)"waystones", (String)"command.waystones.count");
    private static final class_2960 PERMISSION_WAYSTONES_LIST = class_2960.method_60655((String)"waystones", (String)"command.waystones.list");
    private static final class_2960 PERMISSION_WAYSTONES_GUI = class_2960.method_60655((String)"waystones", (String)"command.waystones.gui");

    public static void initialize(BalmCommands commands) {
        BalmCommands.registerPermission((class_2960)PERMISSION_WAYSTONES_ACTIVATE, (int)2);
        BalmCommands.registerPermission((class_2960)PERMISSION_WAYSTONES_FORGET, (int)2);
        BalmCommands.registerPermission((class_2960)PERMISSION_WAYSTONES_COUNT, (int)2);
        BalmCommands.registerPermission((class_2960)PERMISSION_WAYSTONES_LIST, (int)2);
        BalmCommands.registerPermission((class_2960)PERMISSION_WAYSTONES_GUI, (int)2);
        commands.register(dispatcher -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"waystones").requires(BalmCommands.requireAnyPermission((class_2960[])new class_2960[]{PERMISSION_WAYSTONES_ACTIVATE, PERMISSION_WAYSTONES_FORGET, PERMISSION_WAYSTONES_COUNT, PERMISSION_WAYSTONES_LIST, PERMISSION_WAYSTONES_GUI}))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"activate").requires(BalmCommands.requirePermission((class_2960)PERMISSION_WAYSTONES_ACTIVATE))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(context -> {
            Collection targets = class_2186.method_9312((CommandContext)context, (String)"targets");
            class_2338 pos = class_2262.method_9696((CommandContext)context, (String)"pos");
            Optional<Waystone> foundWaystone = WaystonesAPI.getWaystoneAt(((class_2168)context.getSource()).method_9225(), pos);
            if (foundWaystone.isPresent()) {
                Waystone waystone = foundWaystone.get();
                for (class_3222 player : targets) {
                    WaystonesAPI.activateWaystone(player, waystone);
                }
                if (targets.size() == 1) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.waystones.activate.success.single", (Object[])new Object[]{waystone.getName(), ((class_3222)targets.iterator().next()).method_5476()}), true);
                } else {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.waystones.activate.success.multiple", (Object[])new Object[]{waystone.getName(), targets.size()}), true);
                }
            } else {
                throw ERROR_WAYSTONE_NOT_FOUND.create();
            }
            return targets.size();
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"forget").requires(BalmCommands.requirePermission((class_2960)PERMISSION_WAYSTONES_FORGET))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(context -> {
            Collection targets = class_2186.method_9312((CommandContext)context, (String)"targets");
            class_2338 pos = class_2262.method_9696((CommandContext)context, (String)"pos");
            Optional<Waystone> foundWaystone = WaystonesAPI.getWaystoneAt(((class_2168)context.getSource()).method_9225(), pos);
            if (foundWaystone.isPresent()) {
                Waystone waystone = foundWaystone.get();
                for (class_3222 player : targets) {
                    WaystonesAPI.deactivateWaystone(player, waystone);
                }
                if (targets.size() == 1) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.waystones.forget.success.single", (Object[])new Object[]{waystone.getName(), ((class_3222)targets.iterator().next()).method_5476()}), true);
                } else {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.waystones.forget.success.multiple", (Object[])new Object[]{waystone.getName(), targets.size()}), true);
                }
            } else {
                throw ERROR_WAYSTONE_NOT_FOUND.create();
            }
            return targets.size();
        }))).then(class_2170.method_9247((String)"all").executes(context -> {
            Collection targets = class_2186.method_9312((CommandContext)context, (String)"targets");
            int totalDeactivated = 0;
            for (class_3222 player : targets) {
                Collection<Waystone> waystones = PlayerWaystoneManager.getActivatedWaystones((class_1657)player);
                for (Waystone waystone : waystones) {
                    WaystonesAPI.deactivateWaystone(player, waystone);
                }
                totalDeactivated += waystones.size();
            }
            if (targets.size() == 1) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.waystones.forget.all.success.single", (Object[])new Object[]{((class_3222)targets.iterator().next()).method_5476()}), true);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.waystones.forget.all.success.multiple", (Object[])new Object[]{targets.size()}), true);
            }
            return totalDeactivated;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"count").requires(BalmCommands.requirePermission((class_2960)PERMISSION_WAYSTONES_COUNT))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes((Command)new CountWaystonesCommand())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(BalmCommands.requirePermission((class_2960)PERMISSION_WAYSTONES_LIST))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> {
            class_3222 caller = ((class_2168)ctx.getSource()).method_9207();
            class_3222 target = ((class_2300)ctx.getArgument("player", class_2300.class)).method_9811((class_2168)ctx.getSource());
            List<Waystone> waystones = PlayerWaystoneManager.getActivatedWaystones((class_1657)target).stream().filter(it -> it.isOwner((class_1657)target)).sorted(WaystoneComparators.forAdminInspection((class_1657)caller, (class_1657)target)).toList();
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43469((String)"commands.waystones.list.header", (Object[])new Object[]{target.method_5820()}));
            for (Waystone waystone : waystones) {
                ((class_2168)ctx.getSource()).method_45068(ModCommands.componentForWaystoneList(caller, target, waystone));
            }
            class_5250 result = class_2561.method_43469((String)"commands.waystones.list.footer", (Object[])new Object[]{waystones.size()});
            ((class_2168)ctx.getSource()).method_9226(() -> result, false);
            return waystones.size();
        })).then(class_2170.method_9247((String)"all").executes(ctx -> {
            class_3222 caller = ((class_2168)ctx.getSource()).method_9207();
            class_3222 target = ((class_2300)ctx.getArgument("player", class_2300.class)).method_9811((class_2168)ctx.getSource());
            List<Waystone> waystones = PlayerWaystoneManager.getActivatedWaystones((class_1657)target).stream().sorted(WaystoneComparators.forAdminInspection((class_1657)caller, (class_1657)target)).toList();
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43469((String)"commands.waystones.list.all.header", (Object[])new Object[]{target.method_5820()}));
            for (Waystone waystone : waystones) {
                ((class_2168)ctx.getSource()).method_45068(ModCommands.componentForWaystoneList(caller, target, waystone));
            }
            long ownedCount = waystones.stream().filter(it -> it.isOwner((class_1657)target)).count();
            class_5250 result = class_2561.method_43469((String)"commands.waystones.list.all.footer", (Object[])new Object[]{waystones.size(), ownedCount});
            ((class_2168)ctx.getSource()).method_9226(() -> result, false);
            return waystones.size();
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"gui").requires(BalmCommands.requirePermission((class_2960)PERMISSION_WAYSTONES_GUI))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes((Command)new OpenPlayerWaystonesGuiCommand())))));
    }

    private static class_2561 componentForWaystoneList(class_3222 caller, class_3222 target, Waystone waystone) {
        class_5250 location;
        class_2960 waystoneDimensionId = waystone.getDimension().method_29177();
        class_2338 waystonePos = waystone.getPos();
        if (waystone.getDimension() != caller.method_51469().method_27983()) {
            location = class_2561.method_43469((String)"commands.waystones.list.in_dimension", (Object[])new Object[]{waystoneDimensionId});
        } else {
            int distance = (int)caller.method_19538().method_1022(waystonePos.method_46558());
            location = class_2561.method_43469((String)"commands.waystones.list.at_distance", (Object[])new Object[]{distance});
        }
        String suggestedCommand = String.format("/execute in %s run teleport %d %d %d", waystoneDimensionId, waystonePos.method_10263(), waystonePos.method_10264(), waystonePos.method_10260());
        class_5250 coordinates = class_2561.method_43469((String)"commands.waystones.list.coordinates", (Object[])new Object[]{waystonePos.method_10263(), waystonePos.method_10264(), waystonePos.method_10260()}).method_27692(class_124.field_1054).method_27696(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10610(suggestedCommand)));
        class_5250 waystoneName = waystone.getName().method_27661().method_27692(class_124.field_1060).method_27696(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10610(suggestedCommand)));
        String entryKey = waystone.isOwner((class_1657)target) ? "commands.waystones.list.entry.owned" : "commands.waystones.list.entry.activated";
        return class_2561.method_43469((String)entryKey, (Object[])new Object[]{location, coordinates, waystoneName});
    }
}

