/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.transformation;

import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3c;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.creativecore.common.util.math.vec.VectorUtils;

public enum Rotation {
    X_CLOCKWISE(Axis.X, new IntMatrix3(1, 0, 0, 0, 0, -1, 0, 1, 0), true){

        @Override
        public Rotation opposite() {
            return X_COUNTER_CLOCKWISE;
        }
    }
    ,
    X_COUNTER_CLOCKWISE(Axis.X, new IntMatrix3(1, 0, 0, 0, 0, 1, 0, -1, 0), false){

        @Override
        public Rotation opposite() {
            return X_CLOCKWISE;
        }
    }
    ,
    Y_CLOCKWISE(Axis.Y, new IntMatrix3(0, 0, 1, 0, 1, 0, -1, 0, 0), true){

        @Override
        public Rotation opposite() {
            return Y_COUNTER_CLOCKWISE;
        }
    }
    ,
    Y_COUNTER_CLOCKWISE(Axis.Y, new IntMatrix3(0, 0, -1, 0, 1, 0, 1, 0, 0), false){

        @Override
        public Rotation opposite() {
            return Y_CLOCKWISE;
        }
    }
    ,
    Z_CLOCKWISE(Axis.Z, new IntMatrix3(0, -1, 0, 1, 0, 0, 0, 0, 1), true){

        @Override
        public Rotation opposite() {
            return Z_COUNTER_CLOCKWISE;
        }
    }
    ,
    Z_COUNTER_CLOCKWISE(Axis.Z, new IntMatrix3(0, 1, 0, -1, 0, 0, 0, 0, 1), false){

        @Override
        public Rotation opposite() {
            return Z_CLOCKWISE;
        }
    };

    private static final Facing[][] FACING_ROTATION;
    public final Axis axis;
    public final int direction;
    public final boolean clockwise;
    private final class_2382 normal;
    private final IntMatrix3c rotMatrix;

    public static Rotation getRotation(Axis axis, boolean clockwise) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> {
                if (clockwise) {
                    yield X_CLOCKWISE;
                }
                yield X_COUNTER_CLOCKWISE;
            }
            case Axis.Y -> {
                if (clockwise) {
                    yield Y_CLOCKWISE;
                }
                yield Y_COUNTER_CLOCKWISE;
            }
            case Axis.Z -> clockwise ? Z_CLOCKWISE : Z_COUNTER_CLOCKWISE;
        };
    }

    public static Rotation ofNormal(class_2382 vec) {
        if (vec.method_10263() > 0) {
            return X_CLOCKWISE;
        }
        if (vec.method_10263() < 0) {
            return X_COUNTER_CLOCKWISE;
        }
        if (vec.method_10264() > 0) {
            return Y_CLOCKWISE;
        }
        if (vec.method_10264() < 0) {
            return Y_COUNTER_CLOCKWISE;
        }
        if (vec.method_10260() > 0) {
            return Z_CLOCKWISE;
        }
        if (vec.method_10260() < 0) {
            return Z_COUNTER_CLOCKWISE;
        }
        return null;
    }

    public static Rotation getRotation(class_2470 rotationIn) {
        return switch (rotationIn) {
            case class_2470.field_11463 -> Y_CLOCKWISE;
            case class_2470.field_11464 -> Y_CLOCKWISE;
            case class_2470.field_11465 -> Y_COUNTER_CLOCKWISE;
            default -> null;
        };
    }

    public static int getRotationCount(class_2470 rotationIn) {
        if (rotationIn == class_2470.field_11464) {
            return 2;
        }
        return 1;
    }

    private Rotation(Axis axis, IntMatrix3c matrix, boolean clockwise) {
        this.rotMatrix = matrix;
        this.axis = axis;
        this.clockwise = clockwise;
        this.direction = clockwise ? 1 : -1;
        this.normal = VectorUtils.set(class_2382.field_11176, this.direction, axis);
    }

    public IntMatrix3c getMatrix() {
        return this.rotMatrix;
    }

    public abstract Rotation opposite();

    public Facing rotate(Facing facing) {
        return FACING_ROTATION[facing.ordinal()][this.ordinal()];
    }

    public Axis rotate(Axis axis) {
        if (axis == this.axis) {
            return axis;
        }
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> {
                if (this.axis == Axis.Y) {
                    yield Axis.Z;
                }
                yield Axis.Y;
            }
            case Axis.Y -> {
                if (this.axis == Axis.Z) {
                    yield Axis.X;
                }
                yield Axis.Y;
            }
            case Axis.Z -> this.axis == Axis.X ? Axis.Y : Axis.X;
        };
    }

    public Rotation mirror(Axis axis) {
        return this.axis == axis ? this.opposite() : this;
    }

    public Rotation rotate(Rotation by) {
        return Rotation.ofNormal(by.getMatrix().transform(this.normal));
    }

    public Rotation transform(IntMatrix3c matrix) {
        return Rotation.ofNormal(matrix.transform(this.normal));
    }

    public class_2338 transform(class_2338 vec) {
        return this.rotMatrix.transform(vec);
    }

    public class_2382 transform(class_2382 vec) {
        return this.rotMatrix.transform(vec);
    }

    public class_243 transform(class_243 vec) {
        return this.rotMatrix.transform(vec);
    }

    public void transform(Vec3d vec) {
        this.rotMatrix.transform(vec);
    }

    public void transform(Vec3f vec) {
        this.rotMatrix.transform(vec);
    }

    static {
        FACING_ROTATION = new Facing[6][6];
        for (int i = 0; i < FACING_ROTATION.length; ++i) {
            Facing facing = Facing.get(i);
            block1: for (int j = 0; j < Rotation.values().length; ++j) {
                Rotation rotation = Rotation.values()[j];
                class_2382 rotatedNormal = new class_2382(rotation.getMatrix().getX(facing.normal), rotation.getMatrix().getY(facing.normal), rotation.getMatrix().getZ(facing.normal));
                for (int k = 0; k < Facing.values().length; ++k) {
                    if (!Facing.get((int)k).normal.equals((Object)rotatedNormal)) continue;
                    Rotation.FACING_ROTATION[i][j] = Facing.get(k);
                    continue block1;
                }
            }
        }
    }
}

