/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine;

import com.zurrtum.create.client.flywheel.backend.engine.LightStorage;
import com.zurrtum.create.client.flywheel.impl.compat.CompatMod;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import java.util.BitSet;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2804;
import net.minecraft.class_3558;
import net.minecraft.class_3560;
import net.minecraft.class_3562;
import net.minecraft.class_3569;
import net.minecraft.class_4076;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public abstract class LightDataCollector {
    private static final ConstantDataLayer ALWAYS_0 = new ConstantDataLayer(0);
    private static final ConstantDataLayer ALWAYS_15 = new ConstantDataLayer(15);
    protected final class_1936 level;
    protected final class_3562 skyLayerListener;
    protected final class_3562 blockLayerListener;

    protected LightDataCollector(class_1936 level, class_3562 skyLayerListener, class_3562 blockLayerListener) {
        this.level = level;
        this.skyLayerListener = skyLayerListener;
        this.blockLayerListener = blockLayerListener;
    }

    public static LightDataCollector of(class_1936 level) {
        class_3562 skyLayerListener = level.method_22336().method_15562(class_1944.field_9284);
        class_3562 blockLayerListener = level.method_22336().method_15562(class_1944.field_9282);
        Long2ObjectFunction<class_2804> fastSkyDataGetter = LightDataCollector.createFastSkyDataGetter(skyLayerListener);
        Long2ObjectFunction<class_2804> fastBlockDataGetter = LightDataCollector.createFastBlockDataGetter(blockLayerListener);
        if (fastSkyDataGetter != null && fastBlockDataGetter != null) {
            return new Fast(level, skyLayerListener, blockLayerListener, fastSkyDataGetter, fastBlockDataGetter);
        }
        return new Slow(level, skyLayerListener, blockLayerListener);
    }

    private static class_2804 getSkyDataLayer(class_3569 skyStorage, long section) {
        long l = section;
        int i = class_4076.method_18689((long)l);
        class_3569.class_3570 skyDataLayerStorageMap = (class_3569.class_3570)skyStorage.field_15806;
        int j = skyDataLayerStorageMap.field_15821.get(class_4076.method_18693((long)l));
        if (j != skyDataLayerStorageMap.field_15822 && i < j) {
            class_2804 dataLayer = skyStorage.method_20533(l);
            if (dataLayer == null) {
                while (dataLayer == null) {
                    if (++i >= j) {
                        return null;
                    }
                    l = class_4076.method_18679((long)l, (class_2350)class_2350.field_11036);
                    dataLayer = skyStorage.method_20533(l);
                }
            }
            return dataLayer;
        }
        return null;
    }

    @Nullable
    private static Long2ObjectFunction<class_2804> createFastSkyDataGetter(class_3562 layerListener) {
        if (layerListener == class_3562.class_3563.field_15812) {
            return section -> ALWAYS_0;
        }
        if (layerListener instanceof class_3558) {
            class_3558 accessor = (class_3558)layerListener;
            class_3560 class_35602 = accessor.field_15793;
            if (class_35602 instanceof class_3569) {
                class_3569 skyStorage = (class_3569)class_35602;
                return section -> {
                    class_2804 out = LightDataCollector.getSkyDataLayer(skyStorage, section);
                    return Objects.requireNonNullElse(out, ALWAYS_15);
                };
            }
        }
        if (CompatMod.SCALABLELUX.isLoaded) {
            return section -> Objects.requireNonNullElse(layerListener.method_15544(class_4076.method_18677((long)section)), ALWAYS_15);
        }
        return null;
    }

    @Nullable
    private static Long2ObjectFunction<class_2804> createFastBlockDataGetter(class_3562 layerListener) {
        if (layerListener == class_3562.class_3563.field_15812) {
            return section -> ALWAYS_0;
        }
        if (layerListener instanceof class_3558) {
            class_3558 accessor = (class_3558)layerListener;
            class_3560 storage = accessor.field_15793;
            return section -> {
                class_2804 out = storage.method_15522(section, false);
                return Objects.requireNonNullElse(out, ALWAYS_0);
            };
        }
        if (CompatMod.SCALABLELUX.isLoaded) {
            return section -> Objects.requireNonNullElse(layerListener.method_15544(class_4076.method_18677((long)section)), ALWAYS_0);
        }
        return null;
    }

    public void collectSection(long ptr, long section) {
        this.collectSolidData(ptr, section);
        this.collectLightData(ptr, section);
    }

    private void collectSolidData(long ptr, long section) {
        long[] longArray;
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        int xMin = class_4076.method_18688((int)class_4076.method_18686((long)section));
        int yMin = class_4076.method_18688((int)class_4076.method_18689((long)section));
        int zMin = class_4076.method_18688((int)class_4076.method_18690((long)section));
        BitSet bitSet = new BitSet(5832);
        int index = 0;
        for (int y = -1; y < 17; ++y) {
            for (int z = -1; z < 17; ++z) {
                for (int x = -1; x < 17; ++x) {
                    blockPos.method_10103(xMin + x, yMin + y, zMin + z);
                    class_2680 blockState = this.level.method_8320((class_2338)blockPos);
                    if (blockState.method_26225() && blockState.method_26234((class_1922)this.level, (class_2338)blockPos)) {
                        bitSet.set(index);
                    }
                    ++index;
                }
            }
        }
        for (long l : longArray = bitSet.toLongArray()) {
            MemoryUtil.memPutLong((long)ptr, (long)l);
            ptr += 8L;
        }
    }

    protected abstract void collectLightData(long var1, long var3);

    protected static void write(long ptr, int x, int y, int z, int block, int sky) {
        int x1 = x + 1;
        int y1 = y + 1;
        int z1 = z + 1;
        int offset = x1 + z1 * 18 + y1 * 18 * 18;
        long packedByte = block & 0xF | (sky & 0xF) << 4;
        MemoryUtil.memPutByte((long)(ptr + (long)LightStorage.SOLID_SIZE_BYTES + (long)offset), (byte)((byte)packedByte));
    }

    @Environment(value=EnvType.CLIENT)
    private static class Fast
    extends LightDataCollector {
        private final Long2ObjectFunction<class_2804> skyDataGetter;
        private final Long2ObjectFunction<class_2804> blockDataGetter;

        public Fast(class_1936 level, class_3562 skyLayerListener, class_3562 blockLayerListener, Long2ObjectFunction<class_2804> skyDataGetter, Long2ObjectFunction<class_2804> blockDataGetter) {
            super(level, skyLayerListener, blockLayerListener);
            this.skyDataGetter = skyDataGetter;
            this.blockDataGetter = blockDataGetter;
        }

        @Override
        protected void collectLightData(long ptr, long section) {
            this.collectCenter(ptr, section);
            for (SectionEdge i : SectionEdge.VALUES) {
                this.collectYZPlane(ptr, class_4076.method_18678((long)section, (int)i.sectionOffset, (int)0, (int)0), i);
                this.collectXZPlane(ptr, class_4076.method_18678((long)section, (int)0, (int)i.sectionOffset, (int)0), i);
                this.collectXYPlane(ptr, class_4076.method_18678((long)section, (int)0, (int)0, (int)i.sectionOffset), i);
                for (SectionEdge j : SectionEdge.VALUES) {
                    this.collectXStrip(ptr, class_4076.method_18678((long)section, (int)0, (int)i.sectionOffset, (int)j.sectionOffset), i, j);
                    this.collectYStrip(ptr, class_4076.method_18678((long)section, (int)i.sectionOffset, (int)0, (int)j.sectionOffset), i, j);
                    this.collectZStrip(ptr, class_4076.method_18678((long)section, (int)i.sectionOffset, (int)j.sectionOffset, (int)0), i, j);
                }
            }
            this.collectCorners(ptr, section);
        }

        private void collectXStrip(long ptr, long section, SectionEdge y, SectionEdge z) {
            class_2804 blockData = (class_2804)this.blockDataGetter.get(section);
            class_2804 skyData = (class_2804)this.skyDataGetter.get(section);
            for (int x = 0; x < 16; ++x) {
                Fast.write(ptr, x, y.relative, z.relative, blockData.method_12139(x, y.pos, z.pos), skyData.method_12139(x, y.pos, z.pos));
            }
        }

        private void collectYStrip(long ptr, long section, SectionEdge x, SectionEdge z) {
            class_2804 blockData = (class_2804)this.blockDataGetter.get(section);
            class_2804 skyData = (class_2804)this.skyDataGetter.get(section);
            for (int y = 0; y < 16; ++y) {
                Fast.write(ptr, x.relative, y, z.relative, blockData.method_12139(x.pos, y, z.pos), skyData.method_12139(x.pos, y, z.pos));
            }
        }

        private void collectZStrip(long ptr, long section, SectionEdge x, SectionEdge y) {
            class_2804 blockData = (class_2804)this.blockDataGetter.get(section);
            class_2804 skyData = (class_2804)this.skyDataGetter.get(section);
            for (int z = 0; z < 16; ++z) {
                Fast.write(ptr, x.relative, y.relative, z, blockData.method_12139(x.pos, y.pos, z), skyData.method_12139(x.pos, y.pos, z));
            }
        }

        private void collectYZPlane(long ptr, long section, SectionEdge x) {
            class_2804 blockData = (class_2804)this.blockDataGetter.get(section);
            class_2804 skyData = (class_2804)this.skyDataGetter.get(section);
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    Fast.write(ptr, x.relative, y, z, blockData.method_12139(x.pos, y, z), skyData.method_12139(x.pos, y, z));
                }
            }
        }

        private void collectXZPlane(long ptr, long section, SectionEdge y) {
            class_2804 blockData = (class_2804)this.blockDataGetter.get(section);
            class_2804 skyData = (class_2804)this.skyDataGetter.get(section);
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    Fast.write(ptr, x, y.relative, z, blockData.method_12139(x, y.pos, z), skyData.method_12139(x, y.pos, z));
                }
            }
        }

        private void collectXYPlane(long ptr, long section, SectionEdge z) {
            class_2804 blockData = (class_2804)this.blockDataGetter.get(section);
            class_2804 skyData = (class_2804)this.skyDataGetter.get(section);
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    Fast.write(ptr, x, y, z.relative, blockData.method_12139(x, y, z.pos), skyData.method_12139(x, y, z.pos));
                }
            }
        }

        private void collectCenter(long ptr, long section) {
            class_2804 blockData = (class_2804)this.blockDataGetter.get(section);
            class_2804 skyData = (class_2804)this.skyDataGetter.get(section);
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        Fast.write(ptr, x, y, z, blockData.method_12139(x, y, z), skyData.method_12139(x, y, z));
                    }
                }
            }
        }

        private void collectCorners(long ptr, long section) {
            class_3562 blockLayerListener = this.blockLayerListener;
            class_3562 skyLayerListener = this.skyLayerListener;
            class_2338.class_2339 blockPos = new class_2338.class_2339();
            int xMin = class_4076.method_18688((int)class_4076.method_18686((long)section));
            int yMin = class_4076.method_18688((int)class_4076.method_18689((long)section));
            int zMin = class_4076.method_18688((int)class_4076.method_18690((long)section));
            for (SectionEdge y : SectionEdge.VALUES) {
                for (SectionEdge z : SectionEdge.VALUES) {
                    for (SectionEdge x : SectionEdge.VALUES) {
                        blockPos.method_10103(x.relative + xMin, y.relative + yMin, z.relative + zMin);
                        Fast.write(ptr, x.relative, y.relative, z.relative, blockLayerListener.method_15543((class_2338)blockPos), skyLayerListener.method_15543((class_2338)blockPos));
                    }
                }
            }
        }

        @Environment(value=EnvType.CLIENT)
        private static enum SectionEdge {
            LOW(15, -1, -1),
            HIGH(0, 16, 1);

            public static final SectionEdge[] VALUES;
            private final int pos;
            private final int relative;
            private final int sectionOffset;

            private SectionEdge(int pos, int relative, int sectionOffset) {
                this.pos = pos;
                this.relative = relative;
                this.sectionOffset = sectionOffset;
            }

            static {
                VALUES = SectionEdge.values();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class Slow
    extends LightDataCollector {
        public Slow(class_1936 level, class_3562 skyLayerListener, class_3562 blockLayerListener) {
            super(level, skyLayerListener, blockLayerListener);
        }

        @Override
        protected void collectLightData(long ptr, long section) {
            class_3562 blockLayerListener = this.blockLayerListener;
            class_3562 skyLayerListener = this.skyLayerListener;
            class_2338.class_2339 blockPos = new class_2338.class_2339();
            int xMin = class_4076.method_18688((int)class_4076.method_18686((long)section));
            int yMin = class_4076.method_18688((int)class_4076.method_18689((long)section));
            int zMin = class_4076.method_18688((int)class_4076.method_18690((long)section));
            for (int y = -1; y < 17; ++y) {
                for (int z = -1; z < 17; ++z) {
                    for (int x = -1; x < 17; ++x) {
                        blockPos.method_10103(xMin + x, yMin + y, zMin + z);
                        Slow.write(ptr, x, y, z, blockLayerListener.method_15543((class_2338)blockPos), skyLayerListener.method_15543((class_2338)blockPos));
                    }
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ConstantDataLayer
    extends class_2804 {
        private final int value;

        private ConstantDataLayer(int value) {
            this.value = value;
        }

        public int method_12139(int x, int y, int z) {
            return this.value;
        }
    }
}

