/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.mixin;

import com.zurrtum.create.Create;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

@Environment(value=EnvType.CLIENT)
public class MixinPlugin
implements IMixinConfigPlugin {
    public static boolean SODIUM = false;
    public static boolean IRIS = false;
    public static boolean HMI = false;
    public static boolean HAS_RENDER;

    public void onLoad(String mixinPackage) {
        SODIUM = FabricLoader.getInstance().isModLoaded("sodium");
        IRIS = FabricLoader.getInstance().isModLoaded("iris");
        HMI = FabricLoader.getInstance().isModLoaded("holdmyitems");
        HAS_RENDER = FabricLoader.getInstance().isModLoaded("fabric-rendering-fluids-v1");
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        if (SODIUM) {
            mixins.add("FabricModelAccessMixin");
        }
        if (IRIS) {
            mixins.add("IrisPipelinesMixin");
        }
        if (HMI) {
            mixins.add("HoldMyItemsMixin");
            mixins.add("AnimationResourceLoaderMixin");
        }
        if (Create.Lazy) {
            mixins.add("FabricBlockStateModelMixin");
            mixins.add("WrapperBlockStateModelMixin");
            mixins.add("FluidVariantRenderHandlerMixin");
        } else {
            mixins.add("CreativeInventoryScreenMixin");
            mixins.add("DefaultClientResourcePackProviderMixin");
        }
        if (HAS_RENDER) {
            mixins.add("WaterRenderHandlerMixin");
        }
        return mixins;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

