/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorageWrapper;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.contraptions.bearing.StabilizedContraption;
import com.zurrtum.create.content.contraptions.minecart.MinecartSim2020;
import com.zurrtum.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import com.zurrtum.create.content.contraptions.minecart.capability.MinecartController;
import com.zurrtum.create.content.contraptions.mounted.CartAssemblerBlockEntity;
import com.zurrtum.create.content.contraptions.mounted.MountedContraption;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1688;
import net.minecraft.class_1696;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4844;
import org.jetbrains.annotations.Nullable;

public class OrientedContraptionEntity
extends AbstractContraptionEntity {
    private static final class_1856 FUEL_ITEMS = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8713, class_1802.field_8665});
    private static final class_2940<Optional<UUID>> COUPLING = class_2945.method_12791(OrientedContraptionEntity.class, AllSynchedDatas.OPTIONAL_UUID_HANDLER);
    private static final class_2940<class_2350> INITIAL_ORIENTATION = class_2945.method_12791(OrientedContraptionEntity.class, (class_2941)class_2943.field_13321);
    protected class_243 motionBeforeStall = class_243.field_1353;
    protected boolean forceAngle;
    private boolean attachedExtraInventories = false;
    private boolean manuallyPlaced;
    public float prevYaw;
    public float yaw;
    public float targetYaw;
    public float prevPitch;
    public float pitch;
    public int nonDamageTicks = 10;

    public OrientedContraptionEntity(class_1299<? extends OrientedContraptionEntity> type, class_1937 world) {
        super(type, world);
    }

    public static OrientedContraptionEntity create(class_1937 world, Contraption contraption, class_2350 initialOrientation) {
        OrientedContraptionEntity entity = new OrientedContraptionEntity((class_1299<? extends OrientedContraptionEntity>)AllEntityTypes.ORIENTED_CONTRAPTION, world);
        entity.setContraption(contraption);
        entity.setInitialOrientation(initialOrientation);
        entity.startAtInitialYaw();
        return entity;
    }

    public static OrientedContraptionEntity createAtYaw(class_1937 world, Contraption contraption, class_2350 initialOrientation, float initialYaw) {
        OrientedContraptionEntity entity = OrientedContraptionEntity.create(world, contraption, initialOrientation);
        entity.startAtYaw(initialYaw);
        entity.manuallyPlaced = true;
        return entity;
    }

    public void setInitialOrientation(class_2350 direction) {
        this.field_6011.method_12778(INITIAL_ORIENTATION, (Object)direction);
    }

    public class_2350 getInitialOrientation() {
        return (class_2350)this.field_6011.method_12789(INITIAL_ORIENTATION);
    }

    @Override
    public float getYawOffset() {
        return this.getInitialYaw();
    }

    public float getInitialYaw() {
        return (this.isInitialOrientationPresent() ? (class_2350)this.field_6011.method_12789(INITIAL_ORIENTATION) : class_2350.field_11035).method_10144();
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(COUPLING, Optional.empty());
        builder.method_56912(INITIAL_ORIENTATION, (Object)class_2350.field_11036);
    }

    @Override
    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        AbstractContraptionEntity.ContraptionRotationState crs = new AbstractContraptionEntity.ContraptionRotationState();
        float yawOffset = this.getYawOffset();
        crs.zRotation = this.pitch;
        crs.yRotation = -this.yaw + yawOffset;
        if (this.pitch != 0.0f && this.yaw != 0.0f) {
            crs.secondYRotation = -this.yaw;
            crs.yRotation = yawOffset;
        }
        return crs;
    }

    public void method_5848() {
        if (!this.method_37908().field_9236 && this.method_5805()) {
            this.disassemble();
        }
        super.method_5848();
    }

    @Override
    protected void readAdditional(class_11368 view, boolean spawnPacket) {
        super.readAdditional(view, spawnPacket);
        view.method_71426("InitialOrientation", (Codec)class_2350.field_29502).ifPresent(this::setInitialOrientation);
        this.yaw = view.method_71423("Yaw", 0.0f);
        this.pitch = view.method_71423("Pitch", 0.0f);
        this.manuallyPlaced = view.method_71433("Placed", false);
        float forceYaw = view.method_71423("ForceYaw", -1.0f);
        if (forceYaw != -1.0f) {
            this.startAtYaw(forceYaw);
        }
        view.method_71426("CachedMotion", class_243.field_38277).ifPresent(motion -> {
            this.motionBeforeStall = motion;
            if (!this.motionBeforeStall.equals((Object)class_243.field_1353)) {
                this.prevYaw = this.yaw += OrientedContraptionEntity.yawFromVector(this.motionBeforeStall);
                this.targetYaw = this.yaw;
            }
            this.method_18799(class_243.field_1353);
        });
        this.setCouplingId(view.method_71426("OnCoupling", class_4844.field_25122).orElse(null));
    }

    @Override
    protected void writeAdditional(class_11372 view, boolean spawnPacket) {
        class_2350 optional;
        super.writeAdditional(view, spawnPacket);
        if (this.motionBeforeStall != null) {
            view.method_71468("CachedMotion", class_243.field_38277, (Object)this.motionBeforeStall);
        }
        if ((optional = (class_2350)this.field_6011.method_12789(INITIAL_ORIENTATION)).method_10166().method_10179()) {
            view.method_71468("InitialOrientation", (Codec)class_2350.field_29502, (Object)optional);
        }
        if (this.forceAngle) {
            view.method_71464("ForceYaw", this.yaw);
            this.forceAngle = false;
        }
        view.method_71472("Placed", this.manuallyPlaced);
        view.method_71464("Yaw", this.yaw);
        view.method_71464("Pitch", this.pitch);
        if (this.getCouplingId() != null) {
            view.method_71468("OnCoupling", class_4844.field_25122, (Object)this.getCouplingId());
        }
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (INITIAL_ORIENTATION.equals(key) && this.isInitialOrientationPresent() && !this.manuallyPlaced) {
            this.startAtInitialYaw();
        }
    }

    public boolean isInitialOrientationPresent() {
        return ((class_2350)this.field_6011.method_12789(INITIAL_ORIENTATION)).method_10166().method_10179();
    }

    public void startAtInitialYaw() {
        this.startAtYaw(this.getInitialYaw());
    }

    public void startAtYaw(float yaw) {
        this.yaw = this.prevYaw = yaw;
        this.targetYaw = this.prevYaw;
        this.forceAngle = true;
    }

    @Override
    public class_243 applyRotation(class_243 localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, this.getInitialYaw(), class_2350.class_2351.field_11052);
        localPos = VecHelper.rotate(localPos, this.getViewXRot(partialTicks), class_2350.class_2351.field_11051);
        localPos = VecHelper.rotate(localPos, this.getViewYRot(partialTicks), class_2350.class_2351.field_11052);
        return localPos;
    }

    @Override
    public class_243 reverseRotation(class_243 localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, -this.getViewYRot(partialTicks), class_2350.class_2351.field_11052);
        localPos = VecHelper.rotate(localPos, -this.getViewXRot(partialTicks), class_2350.class_2351.field_11051);
        localPos = VecHelper.rotate(localPos, -this.getInitialYaw(), class_2350.class_2351.field_11052);
        return localPos;
    }

    public float getViewYRot(float partialTicks) {
        return -(partialTicks == 1.0f ? this.yaw : AngleHelper.angleLerp(partialTicks, this.prevYaw, this.yaw));
    }

    public float getViewXRot(float partialTicks) {
        return partialTicks == 1.0f ? this.pitch : AngleHelper.angleLerp(partialTicks, this.prevPitch, this.pitch);
    }

    @Override
    protected void tickContraption() {
        Optional<MinecartController> data;
        boolean rotating;
        class_1297 e;
        if (this.nonDamageTicks > 0) {
            --this.nonDamageTicks;
        }
        if ((e = this.method_5854()) == null) {
            return;
        }
        boolean rotationLock = false;
        boolean pauseWhileRotating = false;
        boolean wasStalled = this.isStalled();
        Contraption contraption = this.contraption;
        if (contraption instanceof MountedContraption) {
            MountedContraption mountedContraption = (MountedContraption)contraption;
            rotationLock = mountedContraption.rotationMode == CartAssemblerBlockEntity.CartMovementMode.ROTATION_LOCKED;
            pauseWhileRotating = mountedContraption.rotationMode == CartAssemblerBlockEntity.CartMovementMode.ROTATE_PAUSED;
        }
        class_1297 riding = e;
        while (riding.method_5854() != null && !(this.contraption instanceof StabilizedContraption)) {
            riding = riding.method_5854();
        }
        boolean isOnCoupling = false;
        UUID couplingId = this.getCouplingId();
        boolean bl = isOnCoupling = couplingId != null && riding instanceof class_1688;
        if (!this.attachedExtraInventories) {
            this.attachInventoriesFromRidingCarts(riding, isOnCoupling, couplingId);
            this.attachedExtraInventories = true;
        }
        if (!(rotating = this.updateOrientation(rotationLock, wasStalled, riding, isOnCoupling)) || !pauseWhileRotating) {
            this.tickActors();
        }
        boolean isStalled = this.isStalled();
        boolean isClient = this.method_37908().field_9236;
        boolean isUpdate = true;
        if (riding instanceof class_1688 && (data = AllSynchedDatas.MINECART_CONTROLLER.get(riding)).isPresent()) {
            if (!isClient) {
                data.get().setStalledExternally(isStalled);
            }
            isUpdate = false;
        }
        if (isUpdate) {
            if (isStalled) {
                if (!wasStalled) {
                    this.motionBeforeStall = riding.method_18798();
                }
                riding.method_18800(0.0, 0.0, 0.0);
            }
            if (wasStalled && !isStalled) {
                riding.method_18799(this.motionBeforeStall);
                this.motionBeforeStall = class_243.field_1353;
            }
        }
        if (isClient) {
            return;
        }
        if (!this.isStalled()) {
            if (isOnCoupling) {
                Couple<MinecartController> coupledCarts = this.getCoupledCartsIfPresent();
                if (coupledCarts == null) {
                    return;
                }
                coupledCarts.map(MinecartController::cart).forEach(this::powerFurnaceCartWithFuelFromStorage);
                return;
            }
            this.powerFurnaceCartWithFuelFromStorage(riding);
        }
    }

    private class_2338 getCurrentRailPosition(class_1688 entity) {
        int x = class_3532.method_15357((double)entity.method_23317());
        int y = class_3532.method_15357((double)entity.method_23318());
        int z = class_3532.method_15357((double)entity.method_23321());
        class_2338 pos = new class_2338(x, y, z);
        if (entity.method_37908().method_8320(pos.method_10074()).method_26164(class_3481.field_15463)) {
            pos = pos.method_10074();
        }
        return pos;
    }

    protected boolean updateOrientation(boolean rotationLock, boolean wasStalled, class_1297 riding, boolean isOnCoupling) {
        if (isOnCoupling) {
            Couple<MinecartController> coupledCarts = this.getCoupledCartsIfPresent();
            if (coupledCarts == null) {
                return false;
            }
            class_243 positionVec = ((MinecartController)coupledCarts.getFirst()).cart().method_19538();
            class_243 coupledVec = ((MinecartController)coupledCarts.getSecond()).cart().method_19538();
            double diffX = positionVec.field_1352 - coupledVec.field_1352;
            double diffY = positionVec.field_1351 - coupledVec.field_1351;
            double diffZ = positionVec.field_1350 - coupledVec.field_1350;
            this.prevYaw = this.yaw;
            this.prevPitch = this.pitch;
            this.yaw = (float)(class_3532.method_15349((double)diffZ, (double)diffX) * 180.0 / Math.PI);
            this.pitch = (float)(Math.atan2(diffY, Math.sqrt(diffX * diffX + diffZ * diffZ)) * 180.0 / Math.PI);
            if (this.getCouplingId().equals(riding.method_5667())) {
                this.pitch *= -1.0f;
                this.yaw += 180.0f;
            }
            return false;
        }
        Contraption positionVec = this.contraption;
        if (positionVec instanceof StabilizedContraption) {
            StabilizedContraption stabilized = (StabilizedContraption)positionVec;
            if (!(riding instanceof OrientedContraptionEntity)) {
                return false;
            }
            OrientedContraptionEntity parent = (OrientedContraptionEntity)riding;
            class_2350 facing = stabilized.getFacing();
            if (facing.method_10166().method_10178()) {
                return false;
            }
            this.prevYaw = this.yaw;
            this.yaw = AngleHelper.wrapAngle180(this.getInitialYaw() - parent.getInitialYaw()) - parent.getViewYRot(1.0f);
            return false;
        }
        this.prevYaw = this.yaw;
        if (wasStalled) {
            return false;
        }
        boolean rotating = false;
        class_243 movementVector = riding.method_18798();
        class_243 locationDiff = riding.method_19538().method_1023(riding.field_6014, riding.field_6036, riding.field_5969);
        if (!(riding instanceof class_1688)) {
            movementVector = locationDiff;
        }
        class_243 motion = movementVector.method_1029();
        if (!rotationLock) {
            if (riding instanceof class_1688) {
                class_1688 minecartEntity = (class_1688)riding;
                class_2338 railPosition = this.getCurrentRailPosition(minecartEntity);
                class_2680 blockState = this.method_37908().method_8320(railPosition);
                class_2248 class_22482 = blockState.method_26204();
                if (class_22482 instanceof class_2241) {
                    class_2241 abstractRailBlock = (class_2241)class_22482;
                    class_2768 railDirection = (class_2768)blockState.method_11654(abstractRailBlock.method_9474());
                    motion = VecHelper.project(motion, MinecartSim2020.getRailVec(railDirection));
                }
            }
            if (motion.method_1033() > 0.0) {
                this.targetYaw = OrientedContraptionEntity.yawFromVector(motion);
                if (this.targetYaw < 0.0f) {
                    this.targetYaw += 360.0f;
                }
                if (this.yaw < 0.0f) {
                    this.yaw += 360.0f;
                }
            }
            this.prevYaw = this.yaw;
            float maxApproachSpeed = (float)(motion.method_1033() * 12.0 / Math.max(1.0, this.method_5829().method_17939() / 6.0));
            float yawHint = AngleHelper.getShortestAngleDiff(this.yaw, OrientedContraptionEntity.yawFromVector(locationDiff));
            float approach = AngleHelper.getShortestAngleDiff(this.yaw, this.targetYaw, yawHint);
            approach = class_3532.method_15363((float)approach, (float)(-maxApproachSpeed), (float)maxApproachSpeed);
            this.yaw += approach;
            if (Math.abs(AngleHelper.getShortestAngleDiff(this.yaw, this.targetYaw)) < 1.0f) {
                this.yaw = this.targetYaw;
            } else {
                rotating = true;
            }
        }
        return rotating;
    }

    protected void powerFurnaceCartWithFuelFromStorage(class_1297 riding) {
        class_1799 coal;
        MountedItemStorageWrapper fuelItems;
        int fuel;
        if (!(riding instanceof class_1696)) {
            return;
        }
        class_1696 furnaceCart = (class_1696)riding;
        int fuelBefore = fuel = furnaceCart.field_7739;
        double pushX = furnaceCart.field_54300.field_1352;
        double pushZ = furnaceCart.field_54300.field_1350;
        int i = class_3532.method_15357((double)furnaceCart.method_23317());
        int j = class_3532.method_15357((double)furnaceCart.method_23318());
        int k = class_3532.method_15357((double)furnaceCart.method_23321());
        if (furnaceCart.method_37908().method_8320(new class_2338(i, j - 1, k)).method_26164(class_3481.field_15463)) {
            --j;
        }
        class_2338 blockpos = new class_2338(i, j, k);
        if (this.method_37908().method_8320(blockpos).method_26164(class_3481.field_15463) && fuel > 1) {
            riding.method_18799(riding.method_18798().method_1029().method_1021(1.0));
        }
        if (fuel < 5 && this.contraption != null && (fuelItems = this.contraption.getStorage().getFuelItems()) != null && !(coal = fuelItems.extract((Predicate)FUEL_ITEMS, 1)).method_7960()) {
            fuel += 3600;
        }
        if (fuel != fuelBefore || pushX != 0.0 || pushZ != 0.0) {
            furnaceCart.field_54300 = new class_243(pushX, 0.0, pushZ);
            furnaceCart.field_7739 = fuel;
        }
    }

    @Nullable
    public Couple<MinecartController> getCoupledCartsIfPresent() {
        UUID couplingId = this.getCouplingId();
        if (couplingId == null) {
            return null;
        }
        MinecartController controller = CapabilityMinecartController.getIfPresent(this.method_37908(), couplingId);
        if (controller == null || !controller.isPresent()) {
            return null;
        }
        UUID coupledCart = controller.getCoupledCart(true);
        MinecartController coupledController = CapabilityMinecartController.getIfPresent(this.method_37908(), coupledCart);
        if (coupledController == null || !coupledController.isPresent()) {
            return null;
        }
        return Couple.create(controller, coupledController);
    }

    protected void attachInventoriesFromRidingCarts(class_1297 riding, boolean isOnCoupling, UUID couplingId) {
        Contraption contraption = this.contraption;
        if (!(contraption instanceof MountedContraption)) {
            return;
        }
        MountedContraption mc = (MountedContraption)contraption;
        if (!isOnCoupling) {
            mc.addExtraInventories(riding);
            return;
        }
        Couple<MinecartController> coupledCarts = this.getCoupledCartsIfPresent();
        if (coupledCarts == null) {
            return;
        }
        coupledCarts.map(MinecartController::cart).forEach(mc::addExtraInventories);
    }

    @Nullable
    public UUID getCouplingId() {
        return ((Optional)this.field_6011.method_12789(COUPLING)).orElse(null);
    }

    public void setCouplingId(UUID id) {
        this.field_6011.method_12778(COUPLING, Optional.ofNullable(id));
    }

    public class_243 method_55668(class_1297 entity) {
        return entity instanceof AbstractContraptionEntity ? class_243.field_1353 : new class_243(0.0, 0.19, 0.0);
    }

    @Override
    public class_243 getAnchorVec() {
        class_243 anchorVec = super.getAnchorVec();
        return anchorVec.method_1023(0.5, 0.0, 0.5);
    }

    @Override
    public class_243 getPrevAnchorVec() {
        class_243 prevAnchorVec = super.getPrevAnchorVec();
        return prevAnchorVec.method_1023(0.5, 0.0, 0.5);
    }

    @Override
    protected StructureTransform makeStructureTransform() {
        class_2338 offset = class_2338.method_49638((class_2374)this.getAnchorVec().method_1031(0.5, 0.5, 0.5));
        return new StructureTransform(offset, 0.0f, -this.yaw + this.getInitialYaw(), 0.0f);
    }

    @Override
    protected float getStalledAngle() {
        return this.yaw;
    }

    @Override
    public void handleStallInformation(double x, double y, double z, float angle) {
        this.yaw = angle;
    }
}

