/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.behaviour;

import com.google.common.base.Suppliers;
import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.api.contraption.storage.fluid.MountedFluidStorage;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorage;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_3499;
import net.minecraft.class_6903;
import org.jetbrains.annotations.Nullable;

public class MovementContext {
    public class_243 position;
    public class_243 motion;
    public class_243 relativeMotion;
    public UnaryOperator<class_243> rotation;
    public class_1937 world;
    public class_2680 state;
    public class_2338 localPos;
    public class_2487 blockEntityData;
    public boolean stall;
    public boolean disabled;
    public boolean firstMovement;
    public class_2487 data;
    public Contraption contraption;
    public Object temporaryData;
    private FilterItemStack filter;
    private final Supplier<MountedItemStorage> itemStorage;
    private final Supplier<MountedFluidStorage> fluidStorage;

    public MovementContext(class_1937 world, class_3499.class_3501 info, Contraption contraption) {
        this.world = world;
        this.state = info.comp_1342();
        this.blockEntityData = info.comp_1343();
        this.contraption = contraption;
        this.localPos = info.comp_1341();
        this.disabled = false;
        this.firstMovement = true;
        this.motion = class_243.field_1353;
        this.relativeMotion = class_243.field_1353;
        this.rotation = v -> v;
        this.position = null;
        this.data = new class_2487();
        this.stall = false;
        this.filter = null;
        this.itemStorage = Suppliers.memoize(() -> (MountedItemStorage)contraption.getStorage().getAllItemStorages().get((Object)this.localPos));
        this.fluidStorage = Suppliers.memoize(() -> (MountedFluidStorage)contraption.getStorage().getFluids().storages.get((Object)this.localPos));
    }

    public float getAnimationSpeed() {
        int modifier = 1000;
        double length = -this.motion.method_1033();
        if (this.disabled) {
            return 0.0f;
        }
        if (this.world.field_9236 && this.contraption.stalled) {
            return 700.0f;
        }
        if (Math.abs(length) < 0.001953125) {
            return 0.0f;
        }
        return (int)(length * (double)modifier + 100.0 * Math.signum(length)) / 100 * 100;
    }

    public static MovementContext read(class_1937 world, class_3499.class_3501 info, class_11368 view, Contraption contraption) {
        MovementContext context = new MovementContext(world, info, contraption);
        context.motion = (class_243)view.method_71426("Motion", class_243.field_38277).orElseThrow();
        context.relativeMotion = (class_243)view.method_71426("RelativeMotion", class_243.field_38277).orElseThrow();
        view.method_71426("Position", class_243.field_38277).ifPresent(position -> {
            context.position = position;
        });
        context.stall = view.method_71433("Stall", false);
        context.firstMovement = view.method_71433("FirstMovement", false);
        context.data = (class_2487)view.method_71426("Data", class_2487.field_25128).orElseThrow();
        return context;
    }

    public void write(class_11372 view) {
        view.method_71468("Motion", class_243.field_38277, (Object)this.motion);
        view.method_71468("RelativeMotion", class_243.field_38277, (Object)this.relativeMotion);
        if (this.position != null) {
            view.method_71468("Position", class_243.field_38277, (Object)this.position);
        }
        view.method_71472("Stall", this.stall);
        view.method_71472("FirstMovement", this.firstMovement);
        view.method_71468("Data", class_2487.field_25128, (Object)this.data);
    }

    public FilterItemStack getFilterFromBE() {
        if (this.filter != null) {
            return this.filter;
        }
        class_6903 ops = this.world.method_30349().method_57093((DynamicOps)class_2509.field_11560);
        this.filter = this.blockEntityData.method_67492("Filter", FilterItemStack.CODEC, (DynamicOps)ops).orElseGet(FilterItemStack::empty);
        return this.filter;
    }

    @Nullable
    public MountedItemStorage getItemStorage() {
        return this.itemStorage.get();
    }

    @Nullable
    public MountedFluidStorage getFluidStorage() {
        return this.fluidStorage.get();
    }
}

