/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.nixieTube;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.compat.Mods;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.redstone.nixieTube.DoubleFaceAttachedBlock;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.RedStoneConnectBlock;
import com.zurrtum.create.infrastructure.component.ClipboardEntry;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5244;
import net.minecraft.class_5819;
import net.minecraft.class_9334;
import net.minecraft.class_9904;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NixieTubeBlock
extends DoubleFaceAttachedBlock
implements IBE<NixieTubeBlockEntity>,
IWrenchable,
class_3737,
SpecialBlockItemRequirement,
RedStoneConnectBlock {
    protected final class_1767 color;

    public NixieTubeBlock(class_4970.class_2251 properties, class_1767 color) {
        super(properties);
        this.color = color;
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACE, (Comparable)((Object)DoubleFaceAttachedBlock.DoubleAttachFace.FLOOR))).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
    }

    public NixieTubeBlock(class_4970.class_2251 properties) {
        this(properties, class_1767.field_7946);
    }

    public static Function<class_4970.class_2251, NixieTubeBlock> dyed(class_1767 color) {
        return properties -> new NixieTubeBlock((class_4970.class_2251)properties, color);
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        List<ClipboardEntry> entries;
        if (player.method_5715()) {
            return class_1269.field_52423;
        }
        NixieTubeBlockEntity nixie = (NixieTubeBlockEntity)this.getBlockEntity((class_1922)level, pos);
        if (nixie == null) {
            return class_1269.field_52423;
        }
        if (NixieTubeBlock.isInComputerControlledRow((class_1936)level, pos)) {
            return class_1269.field_52423;
        }
        if (stack.method_7960()) {
            if (nixie.reactsToRedstone()) {
                return class_1269.field_52423;
            }
            nixie.clearCustomText();
            this.updateDisplayedRedstoneValue(state, level, pos);
            return class_1269.field_5812;
        }
        boolean display = stack.method_7909() == class_1802.field_8448 && stack.method_57826(class_9334.field_49631) || stack.method_31574((class_1792)AllItems.CLIPBOARD);
        class_1767 dye = AllItemTags.getDyeColor(stack);
        if (!display && dye == null) {
            return class_1269.field_52423;
        }
        Object component = stack.method_31574((class_1792)AllItems.CLIPBOARD) ? ((entries = ClipboardEntry.getLastViewedEntries(stack)).isEmpty() ? (class_2561)stack.method_58695(class_9334.field_49631, (Object)class_5244.field_39003) : entries.getFirst().text) : (class_2561)stack.method_58695(class_9334.field_49631, (Object)class_5244.field_39003);
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        NixieTubeBlock.walkNixies((class_1936)level, pos, true, (arg_0, arg_1) -> this.lambda$onUseWithItem$2(display, level, (class_2561)component, dye, state, arg_0, arg_1));
        return class_1269.field_5812;
    }

    public static class_2350 getLeftNixieDirection(@NotNull class_2680 state) {
        class_2350 left = ((class_2350)state.method_11654((class_2769)field_11177)).method_10153();
        if (state.method_11654((class_2769)FACE) == DoubleFaceAttachedBlock.DoubleAttachFace.WALL) {
            left = class_2350.field_11036;
        }
        if (state.method_11654((class_2769)FACE) == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED) {
            left = class_2350.field_11033;
        }
        return left;
    }

    public static class_2350 getRightNixieDirection(@NotNull class_2680 state) {
        return NixieTubeBlock.getLeftNixieDirection(state).method_10153();
    }

    public static boolean isInComputerControlledRow(@NotNull class_1936 world, @NotNull class_2338 pos) {
        return Mods.COMPUTERCRAFT.isLoaded() && !NixieTubeBlock.walkNixies(world, pos, false, null);
    }

    public static boolean walkNixies(@NotNull class_1936 world, @NotNull class_2338 start, boolean allowComputerControlled, @Nullable BiConsumer<class_2338, Integer> callback) {
        class_2338 nextPos;
        class_2680 state = world.method_8320(start);
        if (!(state.method_26204() instanceof NixieTubeBlock)) {
            return false;
        }
        if (!Mods.COMPUTERCRAFT.isLoaded()) {
            allowComputerControlled = true;
        }
        class_2338 currentPos = start;
        class_2350 left = NixieTubeBlock.getLeftNixieDirection(state);
        class_2350 right = left.method_10153();
        while (NixieTubeBlock.areNixieBlocksEqual(world.method_8320(nextPos = currentPos.method_10093(left)), state)) {
            currentPos = nextPos;
        }
        if (!allowComputerControlled) {
            class_2338 nextPos2;
            class_2338 leftmostPos = currentPos;
            currentPos = start;
            while (NixieTubeBlock.areNixieBlocksEqual(world.method_8320(nextPos2 = currentPos.method_10093(right)), state)) {
                currentPos = nextPos2;
            }
            currentPos = leftmostPos;
        }
        int index = 0;
        while (true) {
            class_2338 nextPos3;
            int rowPosition = ++index;
            if (callback != null) {
                callback.accept(currentPos, rowPosition);
            }
            if (!NixieTubeBlock.areNixieBlocksEqual(world.method_8320(nextPos3 = currentPos.method_10093(right)), state)) break;
            currentPos = nextPos3;
        }
        return true;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(new class_2769[]{FACE, field_11177, class_2741.field_12508}));
    }

    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return AllItems.ORANGE_NIXIE_TUBE.method_7854();
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 be) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, (class_1792)AllItems.ORANGE_NIXIE_TUBE);
    }

    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        class_2350 facing = (class_2350)pState.method_11654((class_2769)field_11177);
        return switch ((DoubleFaceAttachedBlock.DoubleAttachFace)((Object)pState.method_11654((class_2769)FACE))) {
            case DoubleFaceAttachedBlock.DoubleAttachFace.CEILING -> AllShapes.NIXIE_TUBE_CEILING.get(facing.method_10170().method_10166());
            case DoubleFaceAttachedBlock.DoubleAttachFace.FLOOR -> AllShapes.NIXIE_TUBE.get(facing.method_10170().method_10166());
            default -> AllShapes.NIXIE_TUBE_WALL.get(facing);
        };
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }

    public class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighbourPos, class_2680 neighbourState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            tickView.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        return state;
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = super.method_9605(context);
        if (state == null) {
            return null;
        }
        if (state.method_11654((class_2769)FACE) != DoubleFaceAttachedBlock.DoubleAttachFace.WALL && state.method_11654((class_2769)FACE) != DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED) {
            state = (class_2680)state.method_11657((class_2769)field_11177, (Comparable)((class_2350)state.method_11654((class_2769)field_11177)).method_10170());
        }
        return (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(context.method_8045().method_8316(context.method_8037()).method_15772() == class_3612.field_15910));
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, @Nullable class_9904 wireOrientation, boolean isMoving) {
        if (level.field_9236) {
            return;
        }
        if (!level.method_8397().method_8677(pos, (Object)this)) {
            level.method_64310(pos, (class_2248)this, 1);
        }
    }

    public void method_9588(class_2680 state, class_3218 worldIn, class_2338 pos, class_5819 r) {
        this.updateDisplayedRedstoneValue(state, (class_1937)worldIn, pos);
    }

    public void method_9615(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 oldState, boolean isMoving) {
        if (state.method_26204() == oldState.method_26204() || isMoving || oldState.method_26204() instanceof NixieTubeBlock) {
            return;
        }
        if (Mods.COMPUTERCRAFT.isLoaded() && NixieTubeBlock.isInComputerControlledRow((class_1936)worldIn, pos)) {
            NixieTubeBlock.walkNixies((class_1936)worldIn, pos, true, (currentPos, rowPosition) -> {
                class_2586 patt0$temp = worldIn.method_8321(currentPos);
                if (patt0$temp instanceof NixieTubeBlockEntity) {
                    NixieTubeBlockEntity ntbe = (NixieTubeBlockEntity)patt0$temp;
                    ntbe.displayEmptyText((int)rowPosition);
                }
            });
            return;
        }
        this.updateDisplayedRedstoneValue(state, worldIn, pos);
    }

    public static void updateDisplayedRedstoneValue(NixieTubeBlockEntity be, class_2680 state, boolean force) {
        if (be.method_10997() == null || be.method_10997().field_9236) {
            return;
        }
        if (be.reactsToRedstone() || force) {
            be.updateRedstoneStrength(NixieTubeBlock.getPower(be.method_10997(), state, be.method_11016()));
        }
    }

    private void updateDisplayedRedstoneValue(class_2680 state, class_1937 level, class_2338 pos) {
        if (level.field_9236) {
            return;
        }
        this.withBlockEntityDo((class_1922)level, pos, be -> NixieTubeBlock.updateDisplayedRedstoneValue(be, state, false));
    }

    static boolean isValidBlock(class_1922 world, class_2338 pos, boolean above) {
        class_2680 state = world.method_8320(pos.method_10086(above ? 1 : -1));
        return !state.method_26218(world, pos).method_1110();
    }

    private static int getPower(class_1937 worldIn, class_2680 state, class_2338 pos) {
        int power = 0;
        for (class_2350 direction : Iterate.directions) {
            power = Math.max(worldIn.method_49808(pos.method_10093(direction), direction), power);
        }
        for (class_2350 direction : Iterate.directions) {
            if (((class_2350)state.method_11654((class_2769)field_11177)).method_10153() == direction) continue;
            power = Math.max(worldIn.method_49808(pos.method_10093(direction), class_2350.field_11036), power);
        }
        return power;
    }

    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    public boolean canConnectRedstone(class_2680 state, @Nullable class_2350 side) {
        return side != null;
    }

    @Override
    public Class<NixieTubeBlockEntity> getBlockEntityClass() {
        return NixieTubeBlockEntity.class;
    }

    @Override
    public class_2591<? extends NixieTubeBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.NIXIE_TUBE;
    }

    public class_1767 getColor() {
        return this.color;
    }

    public static NixieTubeBlock getColorBlock(class_1767 color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case class_1767.field_7952 -> AllBlocks.WHITE_NIXIE_TUBE;
            case class_1767.field_7946 -> AllBlocks.ORANGE_NIXIE_TUBE;
            case class_1767.field_7958 -> AllBlocks.MAGENTA_NIXIE_TUBE;
            case class_1767.field_7951 -> AllBlocks.LIGHT_BLUE_NIXIE_TUBE;
            case class_1767.field_7947 -> AllBlocks.YELLOW_NIXIE_TUBE;
            case class_1767.field_7961 -> AllBlocks.LIME_NIXIE_TUBE;
            case class_1767.field_7954 -> AllBlocks.PINK_NIXIE_TUBE;
            case class_1767.field_7944 -> AllBlocks.GRAY_NIXIE_TUBE;
            case class_1767.field_7967 -> AllBlocks.LIGHT_GRAY_NIXIE_TUBE;
            case class_1767.field_7955 -> AllBlocks.CYAN_NIXIE_TUBE;
            case class_1767.field_7945 -> AllBlocks.PURPLE_NIXIE_TUBE;
            case class_1767.field_7966 -> AllBlocks.BLUE_NIXIE_TUBE;
            case class_1767.field_7957 -> AllBlocks.BROWN_NIXIE_TUBE;
            case class_1767.field_7942 -> AllBlocks.GREEN_NIXIE_TUBE;
            case class_1767.field_7964 -> AllBlocks.RED_NIXIE_TUBE;
            case class_1767.field_7963 -> AllBlocks.BLACK_NIXIE_TUBE;
        };
    }

    public static boolean areNixieBlocksEqual(class_2680 blockState, class_2680 otherState) {
        if (!(blockState.method_26204() instanceof NixieTubeBlock)) {
            return false;
        }
        if (!(otherState.method_26204() instanceof NixieTubeBlock)) {
            return false;
        }
        return NixieTubeBlock.withColor(blockState, class_1767.field_7952) == NixieTubeBlock.withColor(otherState, class_1767.field_7952);
    }

    public static class_2680 withColor(class_2680 state, class_1767 color) {
        return (class_2680)((class_2680)((class_2680)(color == class_1767.field_7946 ? AllBlocks.ORANGE_NIXIE_TUBE : NixieTubeBlock.getColorBlock(color)).method_9564().method_11657((class_2769)field_11177, (Comparable)((class_2350)state.method_11654((class_2769)field_11177)))).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)state.method_11654((class_2769)class_2741.field_12508)))).method_11657((class_2769)FACE, (Comparable)((Object)((DoubleFaceAttachedBlock.DoubleAttachFace)((Object)state.method_11654((class_2769)FACE)))));
    }

    public static class_1767 colorOf(class_2680 blockState) {
        return blockState.method_26204() instanceof NixieTubeBlock ? ((NixieTubeBlock)blockState.method_26204()).color : class_1767.field_7946;
    }

    public static class_2350 getFacing(class_2680 sideState) {
        return NixieTubeBlock.getConnectedDirection(sideState);
    }

    private /* synthetic */ void lambda$onUseWithItem$2(boolean display, class_1937 level, class_2561 component, class_1767 dye, class_2680 state, class_2338 currentPos, Integer rowPosition) {
        if (display) {
            this.withBlockEntityDo((class_1922)level, currentPos, be -> be.displayCustomText(component, rowPosition));
        }
        if (dye != null) {
            level.method_8501(currentPos, NixieTubeBlock.withColor(state, dye));
        }
    }
}

