/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.signal;

import com.google.common.base.Predicates;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.signal.EdgeGroupColor;
import com.zurrtum.create.content.trains.signal.SignalBoundary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_4844;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.mutable.MutableInt;

public class SignalEdgeGroup {
    private static final Codec<Map<UUID, UUID>> INTERSECTING_CODEC = Codec.unboundedMap((Codec)class_4844.field_41525, (Codec)class_4844.field_41525);
    public static final Codec<SignalEdgeGroup> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_41525.fieldOf("Id").forGetter(i -> i.id), (App)EdgeGroupColor.CODEC.fieldOf("Color").forGetter(group -> group.color), (App)INTERSECTING_CODEC.fieldOf("Connected").forGetter(group -> group.intersecting), (App)Codec.BOOL.fieldOf("Fallback").forGetter(group -> group.fallbackGroup)).apply((Applicative)instance, SignalEdgeGroup::new));
    public UUID id;
    public EdgeGroupColor color;
    public Set<Train> trains;
    public SignalBoundary reserved;
    public Map<UUID, UUID> intersecting;
    public Set<SignalEdgeGroup> intersectingResolved;
    public Set<UUID> adjacent;
    public boolean fallbackGroup;

    public SignalEdgeGroup(UUID id) {
        this.id = id;
        this.trains = new HashSet<Train>();
        this.adjacent = new HashSet<UUID>();
        this.intersecting = new HashMap<UUID, UUID>();
        this.intersectingResolved = new HashSet<SignalEdgeGroup>();
        this.color = EdgeGroupColor.getDefault();
    }

    private SignalEdgeGroup(UUID id, EdgeGroupColor color, Map<UUID, UUID> intersecting, boolean fallbackGroup) {
        this.id = id;
        this.color = color;
        this.intersecting = new HashMap<UUID, UUID>(intersecting);
        this.fallbackGroup = fallbackGroup;
        this.trains = new HashSet<Train>();
        this.adjacent = new HashSet<UUID>();
        this.intersectingResolved = new HashSet<SignalEdgeGroup>();
    }

    public SignalEdgeGroup asFallback() {
        this.fallbackGroup = true;
        return this;
    }

    public boolean isOccupiedUnless(Train train) {
        if (this.intersectingResolved.isEmpty()) {
            this.walkIntersecting(this.intersectingResolved::add);
        }
        for (SignalEdgeGroup group : this.intersectingResolved) {
            if (!group.isThisOccupiedUnless(train)) continue;
            return true;
        }
        return false;
    }

    private boolean isThisOccupiedUnless(Train train) {
        return this.reserved != null || this.trains.size() > 1 || !this.trains.contains(train) && !this.trains.isEmpty();
    }

    public boolean isOccupiedUnless(SignalBoundary boundary) {
        if (this.intersectingResolved.isEmpty()) {
            this.walkIntersecting(this.intersectingResolved::add);
        }
        for (SignalEdgeGroup group : this.intersectingResolved) {
            if (!group.isThisOccupiedUnless(boundary)) continue;
            return true;
        }
        return false;
    }

    private boolean isThisOccupiedUnless(SignalBoundary boundary) {
        return !this.trains.isEmpty() || this.reserved != null && this.reserved != boundary;
    }

    public void putIntersection(MinecraftServer server, UUID intersectionId, UUID targetGroup) {
        this.intersecting.put(intersectionId, targetGroup);
        this.walkIntersecting(g -> g.intersectingResolved.clear());
        this.resolveColor(server);
    }

    public void removeIntersection(MinecraftServer server, UUID intersectionId) {
        this.walkIntersecting(g -> g.intersectingResolved.clear());
        UUID removed = this.intersecting.remove(intersectionId);
        SignalEdgeGroup other = Create.RAILWAYS.signalEdgeGroups.get(removed);
        if (other != null) {
            other.intersecting.remove(intersectionId);
        }
        this.resolveColor(server);
    }

    public void putAdjacent(UUID adjacent) {
        this.adjacent.add(adjacent);
    }

    public void removeAdjacent(UUID adjacent) {
        this.adjacent.remove(adjacent);
    }

    public void resolveColor(MinecraftServer server) {
        if (this.intersectingResolved.isEmpty()) {
            this.walkIntersecting(this.intersectingResolved::add);
        }
        MutableInt mask = new MutableInt(0);
        this.intersectingResolved.forEach(group -> group.adjacent.stream().map(Create.RAILWAYS.signalEdgeGroups::get).filter(Objects::nonNull).filter((Predicate<SignalEdgeGroup>)Predicates.not(this.intersectingResolved::contains)).forEach(adjacent -> mask.setValue(adjacent.color.strikeFrom(mask.getValue()))));
        EdgeGroupColor newColour = EdgeGroupColor.findNextAvailable(mask.getValue());
        if (newColour == this.color) {
            return;
        }
        this.walkIntersecting(group -> {
            group.color = newColour;
            Create.RAILWAYS.sync.edgeGroupCreated(server, group.id, group.color);
        });
        Create.RAILWAYS.markTracksDirty();
    }

    private void walkIntersecting(Consumer<SignalEdgeGroup> callback) {
        this.walkIntersectingRec(new HashSet<SignalEdgeGroup>(), callback);
    }

    private void walkIntersectingRec(Set<SignalEdgeGroup> visited, Consumer<SignalEdgeGroup> callback) {
        if (!visited.add(this)) {
            return;
        }
        callback.accept(this);
        for (UUID uuid : this.intersecting.values()) {
            SignalEdgeGroup group = Create.RAILWAYS.signalEdgeGroups.get(uuid);
            if (group == null) continue;
            group.walkIntersectingRec(visited, callback);
        }
    }
}

