/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.fluids;

import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.fluids.SidedFluidInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import java.util.Collections;
import java.util.NoSuchElementException;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CombinedTankWrapper
implements SidedFluidInventory {
    protected final FluidInventory[] itemHandler;
    protected final int[] baseIndex;
    private final boolean[] sideInventory;
    protected final int[] slots;

    public CombinedTankWrapper(FluidInventory ... itemHandler) {
        this.itemHandler = itemHandler;
        int length = itemHandler.length;
        this.baseIndex = new int[length];
        this.sideInventory = new boolean[length];
        int index = 0;
        for (int i = 0; i < length; ++i) {
            FluidInventory inventory = itemHandler[i];
            this.baseIndex[i] = index += inventory.size();
            this.sideInventory[i] = inventory instanceof SidedFluidInventory;
        }
        this.slots = SlotRangeCache.get(index);
    }

    protected int getIndexForSlot(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndex.length; ++i) {
            if (slot - this.baseIndex[i] >= 0) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    protected FluidInventory getHandlerFromIndex(int index) {
        if (index < 0 || index >= this.itemHandler.length) {
            return null;
        }
        return this.itemHandler[index];
    }

    protected int getSlotFromIndex(int slot, int index) {
        if (index <= 0 || index >= this.baseIndex.length) {
            return slot;
        }
        return slot - this.baseIndex[index - 1];
    }

    @Override
    public int[] getAvailableSlots(class_2350 side) {
        return this.slots;
    }

    @Override
    public boolean canInsert(int slot, FluidStack stack, @Nullable class_2350 dir) {
        int index = this.getIndexForSlot(slot);
        FluidInventory handler = this.getHandlerFromIndex(index);
        if (handler == null) {
            return false;
        }
        if (handler.isValid(slot, stack)) {
            if (this.sideInventory[index]) {
                return ((SidedFluidInventory)handler).canInsert(slot, stack, dir);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canExtract(int slot, FluidStack stack, class_2350 dir) {
        int index = this.getIndexForSlot(slot);
        FluidInventory handler = this.getHandlerFromIndex(index);
        if (handler == null) {
            return false;
        }
        if (this.sideInventory[index]) {
            return ((SidedFluidInventory)handler).canExtract(slot, stack, dir);
        }
        return true;
    }

    @Override
    public int size() {
        return this.slots.length;
    }

    @Override
    public FluidStack getStack(int slot) {
        int index = this.getIndexForSlot(slot);
        FluidInventory handler = this.getHandlerFromIndex(index);
        if (handler == null) {
            return FluidStack.EMPTY;
        }
        slot = this.getSlotFromIndex(slot, index);
        return handler.getStack(slot);
    }

    @Override
    public void setStack(int slot, FluidStack stack) {
        int index = this.getIndexForSlot(slot);
        FluidInventory handler = this.getHandlerFromIndex(index);
        if (handler == null) {
            return;
        }
        slot = this.getSlotFromIndex(slot, index);
        handler.setStack(slot, stack);
    }

    @Override
    public int insert(FluidStack stack, int maxAmount, class_2350 side) {
        int remaining = maxAmount;
        for (FluidInventory handler : this.itemHandler) {
            int insert = handler.insert(stack, remaining, side);
            if (remaining == insert) {
                this.markInventoryDirty();
                return maxAmount;
            }
            if (insert == 0) continue;
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.markInventoryDirty();
        return maxAmount - remaining;
    }

    @Override
    public int extract(FluidStack stack, int maxAmount, class_2350 side) {
        int remaining = maxAmount;
        for (FluidInventory handler : this.itemHandler) {
            int extract = handler.extract(stack, remaining, side);
            if (remaining == extract) {
                this.markInventoryDirty();
                return maxAmount;
            }
            if (extract == 0) continue;
            remaining -= extract;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.markInventoryDirty();
        return maxAmount - remaining;
    }

    public void markInventoryDirty() {
    }

    @Override
    public void markDirty() {
        for (FluidInventory inventory : this.itemHandler) {
            inventory.markDirty();
        }
        this.markInventoryDirty();
    }

    @Override
    @NotNull
    public java.util.Iterator<FluidStack> iterator(class_2350 side) {
        if (this.itemHandler.length == 0) {
            return Collections.emptyIterator();
        }
        return new Iterator(side);
    }

    class Iterator
    implements java.util.Iterator<FluidStack> {
        private int index;
        private final class_2350 side;
        private java.util.Iterator<FluidStack> iterator;

        public Iterator(class_2350 side) {
            this.side = side;
            this.iterator = CombinedTankWrapper.this.itemHandler[this.index].iterator(side);
        }

        @Override
        public boolean hasNext() {
            if (this.iterator.hasNext()) {
                return true;
            }
            do {
                ++this.index;
                if (this.index >= CombinedTankWrapper.this.itemHandler.length) {
                    return false;
                }
                this.iterator = CombinedTankWrapper.this.itemHandler[this.index].iterator(this.side);
            } while (!this.iterator.hasNext());
            return true;
        }

        @Override
        public FluidStack next() {
            if (this.hasNext()) {
                return this.iterator.next();
            }
            throw new NoSuchElementException();
        }
    }
}

