/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.fluid;

import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.FluidStateUtil;
import net.pitan76.mcpitanlib.api.util.FluidUtil;
import net.pitan76.mcpitanlib.midohra.item.ItemWrapper;
import org.jetbrains.annotations.Nullable;

public class FluidWrapper {
    private final class_3611 fluid;

    protected FluidWrapper() {
        this.fluid = null;
    }

    protected FluidWrapper(class_3611 fluid) {
        this.fluid = fluid;
    }

    public static FluidWrapper of(class_3611 fluid) {
        return new FluidWrapper(fluid);
    }

    public static FluidWrapper of() {
        return new FluidWrapper();
    }

    public static FluidWrapper of(CompatIdentifier id) {
        if (FluidUtil.isExist(id)) {
            return FluidWrapper.of(FluidUtil.fromId(id));
        }
        return FluidWrapper.of();
    }

    public static FluidWrapper of(CompatIdentifier id, CompatIdentifier ... ids) {
        if (FluidWrapper.of(id).isExist()) {
            return FluidWrapper.of(id);
        }
        for (CompatIdentifier id1 : ids) {
            if (!FluidWrapper.of(id1).isExist()) continue;
            return FluidWrapper.of(id1);
        }
        return FluidWrapper.of();
    }

    public boolean isExist() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.get() == null;
    }

    @Nullable
    public class_3611 get() {
        return this.fluid;
    }

    public class_3611 gerOrDefault(class_3611 defaultFluid) {
        return this.isEmpty() ? defaultFluid : this.get();
    }

    public CompatIdentifier getId() {
        if (this.isEmpty()) {
            return CompatIdentifier.empty();
        }
        return FluidUtil.toCompatId(this.get());
    }

    public String getName() {
        if (this.isEmpty()) {
            return "";
        }
        return this.get().toString();
    }

    public class_3610 getDefaultState() {
        return FluidStateUtil.getDefaultState(this.get());
    }

    public ItemWrapper getBucketItem() {
        return ItemWrapper.of(FluidUtil.getBucketItem(this.get()));
    }

    public boolean rawEquals(FluidWrapper fluid) {
        return this.get() == fluid.get();
    }
}

