/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1936;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.server.MinecraftServer;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.LoggerUtil;
import net.pitan76.mcpitanlib.api.util.ResourceUtil;
import net.pitan76.mcpitanlib.midohra.resource.Resource;
import net.pitan76.mcpitanlib.midohra.server.MCServer;
import net.pitan76.mcpitanlib.midohra.world.WorldAccess;

public class ResourceManager {
    private final class_3300 resourceManager;

    protected ResourceManager(class_3300 resourceManager) {
        this.resourceManager = resourceManager;
    }

    public static ResourceManager of(class_3300 resourceManager) {
        return new ResourceManager(resourceManager);
    }

    public static ResourceManager of(MinecraftServer server) {
        return ResourceManager.of(MCServer.of(server));
    }

    public static ResourceManager of(MCServer server) {
        return ResourceManager.of(server.getRaw());
    }

    @Environment(value=EnvType.CLIENT)
    public static ResourceManager of(class_310 client) {
        return ResourceManager.of(client.method_1478());
    }

    public static ResourceManager of(class_1936 worldAccess) {
        return ResourceManager.of(worldAccess.method_8503());
    }

    public static ResourceManager of(WorldAccess worldAccess) {
        return ResourceManager.of(worldAccess.getServer());
    }

    public class_3300 getRaw() {
        return this.resourceManager;
    }

    public class_3300 toMinecraft() {
        return this.getRaw();
    }

    public Map<CompatIdentifier, Resource> findResources(String startPath, String endPath) {
        HashMap<CompatIdentifier, Resource> map = new HashMap<CompatIdentifier, Resource>();
        try {
            Map<class_2960, class_3298> rawMap = ResourceUtil.findResources(this.resourceManager, startPath, endPath);
            for (Map.Entry<class_2960, class_3298> entry : rawMap.entrySet()) {
                map.put(CompatIdentifier.fromMinecraft(entry.getKey()), Resource.of(entry.getValue()));
            }
        }
        catch (IOException e) {
            LoggerUtil.error(LoggerUtil.getLogger(), "Failed to read " + startPath + ": " + e.getMessage());
            return null;
        }
        return map;
    }

    public Resource getResource(CompatIdentifier id) {
        Optional resource = this.resourceManager.method_14486(id.toMinecraft());
        return resource.map(Resource::of).orElse(null);
    }

    public List<Resource> getAllResources(CompatIdentifier id) {
        return this.resourceManager.method_14489(id.toMinecraft()).stream().map(Resource::of).toList();
    }
}

