/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.integration.eiv.cutting;

import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5251;
import vectorwing.farmersdelight.FarmersDelight;
import vectorwing.farmersdelight.integration.eiv.cutting.CuttingServerRecipe;
import vectorwing.farmersdelight.integration.eiv.cutting.CuttingViewType;

public class CuttingViewRecipe
implements IEivViewRecipe {
    private final LinkedHashMap<SlotContent, Float> rollableResults;
    private SlotContent ingredient;
    private List<SlotContent> results = new ArrayList<SlotContent>();
    private SlotContent tool;

    public CuttingViewRecipe(CuttingServerRecipe shapelessRecipe) {
        this.rollableResults = new LinkedHashMap();
        shapelessRecipe.getResults().forEach(ingredient -> this.results.add(SlotContent.of((class_1799)ingredient)));
        shapelessRecipe.getRollableResults().forEach(ingredient -> this.rollableResults.put(SlotContent.of((class_1799)ingredient.stack()), Float.valueOf(ingredient.chance())));
        this.ingredient = SlotContent.of((class_1856)shapelessRecipe.getIngredient());
        this.tool = SlotContent.of((class_1856)shapelessRecipe.getTool());
    }

    public IEivRecipeViewType getViewType() {
        return CuttingViewType.INSTANCE;
    }

    public void bindSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        int i = 0;
        slotFillContext.bindSlot(i, this.ingredient);
        slotFillContext.bindSlot(++i, this.tool);
        ++i;
        for (Map.Entry<SlotContent, Float> result : this.rollableResults.entrySet()) {
            Float chance = result.getValue();
            if ((double)chance.floatValue() != 1.0) {
                slotFillContext.bindOptionalSlot(i, result.getKey(), CuttingSlotRenderer.CHANCE_OUTPUT);
                slotFillContext.addAdditionalStackModifier(i, (stack, tooltip) -> tooltip.add(class_2561.method_43470((String)"Production chance: %s%%".formatted(Float.valueOf(chance.floatValue() * 100.0f))).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1065)))));
            } else {
                slotFillContext.bindOptionalSlot(i, result.getKey(), CuttingSlotRenderer.GUARANTEED_OUTPUT);
            }
            ++i;
        }
        if (i <= 2) {
            slotFillContext.bindOptionalSlot(i, SlotContent.of((class_1799)class_1799.field_8037), RecipeViewMenu.OptionalSlotRenderer.DEFAULT);
            ++i;
        }
        if (i <= 3) {
            slotFillContext.bindOptionalSlot(i, SlotContent.of((class_1799)class_1799.field_8037), RecipeViewMenu.OptionalSlotRenderer.DEFAULT);
            ++i;
        }
        if (i <= 4) {
            slotFillContext.bindOptionalSlot(i, SlotContent.of((class_1799)class_1799.field_8037), RecipeViewMenu.OptionalSlotRenderer.DEFAULT);
            ++i;
        }
        if (i <= 5) {
            slotFillContext.bindOptionalSlot(i, SlotContent.of((class_1799)class_1799.field_8037), RecipeViewMenu.OptionalSlotRenderer.DEFAULT);
        }
    }

    public List<SlotContent> getIngredients() {
        return Collections.singletonList(this.ingredient);
    }

    public List<SlotContent> getResults() {
        return this.results;
    }

    public static interface CuttingSlotRenderer {
        public static final class_2960 SLOT_TEXTURE = FarmersDelight.res("textures/gui/jei/cutting_board.png");
        public static final RecipeViewMenu.OptionalSlotRenderer GUARANTEED_OUTPUT = (guiGraphics, mouseX, mouseY, partialTicks) -> guiGraphics.method_25290(class_10799.field_56883, SLOT_TEXTURE, 0, 0, 0.0f, 58.0f, 18, 18, 256, 256);
        public static final RecipeViewMenu.OptionalSlotRenderer CHANCE_OUTPUT = (guiGraphics, mouseX, mouseY, partialTicks) -> guiGraphics.method_25290(class_10799.field_56883, SLOT_TEXTURE, 0, 0, 18.0f, 58.0f, 18, 18, 256, 256);

        public void render(class_332 var1, int var2, int var3, float var4);
    }
}

