/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.google.common.collect.ImmutableList;
import com.tristankechlo.livingthings.config.entity.MantarayConfig;
import com.tristankechlo.livingthings.entity.SharkEntity;
import com.tristankechlo.livingthings.entity.misc.IMobVariants;
import com.tristankechlo.livingthings.entity.misc.IScaleableMob;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1332;
import net.minecraft.class_1338;
import net.minecraft.class_1349;
import net.minecraft.class_1352;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1378;
import net.minecraft.class_1393;
import net.minecraft.class_1425;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5757;
import net.minecraft.class_5819;
import net.minecraft.class_6011;
import net.minecraft.class_7;

public class MantarayEntity
extends class_1425
implements IMobVariants,
IScaleableMob,
ILexiconEntry {
    private static final class_2940<Byte> MANTARAY_VARIANT = class_2945.method_12791(MantarayEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Byte> MANTARAY_SCALING = class_2945.method_12791(MantarayEntity.class, (class_2941)class_2943.field_13319);

    public MantarayEntity(class_1299<? extends MantarayEntity> type, class_1937 worldIn) {
        super(type, worldIn);
        this.method_5941(class_7.field_18, 0.0f);
        this.field_6207 = new class_5757((class_1308)this, 85, 10, 0.02f, 0.1f, true);
        this.field_6206 = new class_1332((class_1308)this, 10);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, MantarayConfig.health()).method_26868(class_5134.field_23719, MantarayConfig.movementSpeed());
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1393((class_1314)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.55));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, SharkEntity.class, 16.0f, 1.3, 1.45));
        this.field_6201.method_6277(3, (class_1352)new class_1349((class_1425)this));
        this.field_6201.method_6277(4, (class_1352)new SwimGoal(this));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(MANTARAY_VARIANT, (Object)0);
        builder.method_56912(MANTARAY_SCALING, (Object)0);
    }

    public void method_5652(class_11372 compound) {
        super.method_5652(compound);
        compound.method_71462("MantarayVariant", this.getVariant());
        compound.method_71462("MantarayScaling", this.getScaling());
    }

    public void method_5749(class_11368 compound) {
        super.method_5749(compound);
        this.setVariant(compound.method_71421("MantarayVariant", (byte)0));
        this.setScaling(compound.method_71421("MantarayScaling", (byte)0));
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn) {
        int colorBlueVariant = (Integer)MantarayConfig.get().colorBlueVariant.get();
        int colorBrownVariant = (Integer)MantarayConfig.get().colorBrownVariant.get();
        byte variant = this.getRandomVariant(this.field_5974, new byte[]{0, 1}, new int[]{colorBlueVariant, colorBrownVariant});
        this.setVariant(variant);
        this.setScaling(MantarayEntity.getWeightedRandomScaling(this.field_5974));
        return super.method_5943(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public static byte getWeightedRandomScaling(class_5819 random) {
        int scaling1Weight = (Integer)MantarayConfig.get().scalingSmallVariant.get();
        int scaling2Weight = (Integer)MantarayConfig.get().scalingNormalWeight.get();
        int scaling3Weight = (Integer)MantarayConfig.get().scalingLargeVariant.get();
        int scaling4Weight = (Integer)MantarayConfig.get().scalingExtraLargeWeight.get();
        if (scaling1Weight <= 0 && scaling2Weight <= 0 && scaling3Weight <= 0 && scaling4Weight <= 0) {
            return 0;
        }
        Optional scaling = class_6011.method_34986((class_5819)random, (List)ImmutableList.of((Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling1Weight), -2), (Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling2Weight), 0), (Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling3Weight), 2), (Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling4Weight), 6)), IScaleableMob.WeightedMobScaling::weight);
        return ((IScaleableMob.WeightedMobScaling)scaling.get()).scaling();
    }

    public static boolean checkMantaraySpawnRules(class_1299<MantarayEntity> entity, class_1936 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return world.method_8316(pos).method_15767(LivingThingsTags.MANTARAY_SPAWNABLE_ON) && world.method_8316(pos.method_10084()).method_15767(LivingThingsTags.MANTARAY_SPAWNABLE_ON);
    }

    public boolean method_5931() {
        return true;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return !this.method_16914();
    }

    public int method_5945() {
        return MantarayConfig.maxSpawnedInChunk();
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        return class_1269.field_5811;
    }

    @Override
    public byte getVariant() {
        return (Byte)this.field_6011.method_12789(MANTARAY_VARIANT);
    }

    @Override
    public void setVariant(byte variant) {
        this.field_6011.method_12778(MANTARAY_VARIANT, (Object)variant);
    }

    @Override
    public byte getScaling() {
        return (Byte)this.field_6011.method_12789(MANTARAY_SCALING);
    }

    @Override
    public void setScaling(byte scaling) {
        this.field_6011.method_12778(MANTARAY_SCALING, (Object)scaling);
    }

    public class_1799 method_6452() {
        return new class_1799((class_1935)class_1802.field_8550);
    }

    protected class_3414 method_6457() {
        return ModSounds.MANTARAY_FLOP.get();
    }

    @Override
    public class_2960 getLexiconEntry() {
        return LexiconEntries.MANTARAY;
    }

    static class SwimGoal
    extends class_1378 {
        private final MantarayEntity fish;

        public SwimGoal(MantarayEntity fish) {
            super((class_1314)fish, 1.0, 40);
            this.fish = fish;
        }

        public boolean method_6264() {
            return this.fish.method_6456() && super.method_6264();
        }
    }
}

