/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.armor;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_5244;
import net.minecraft.class_8051;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import reborncore.api.items.ArmorBlockEntityTicker;
import reborncore.api.items.ArmorRemoveHandler;
import reborncore.common.powerSystem.RcEnergyTier;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRItemSettings;
import techreborn.items.armor.AttributeModifierBuilder;
import techreborn.items.armor.QuantumSuitFlightHandler;
import techreborn.items.armor.TREnergyArmourItem;
import techreborn.items.armor.VanillaQuantumSuitFlightHandler;
import techreborn.utils.TRItemUtils;

public class QuantumSuitItem
extends TREnergyArmourItem
implements ArmorBlockEntityTicker,
ArmorRemoveHandler {
    public static QuantumSuitFlightHandler HANDLER = new VanillaQuantumSuitFlightHandler();
    private static final class_9285 FULL_SUIT = new AttributeModifierBuilder().armor(10).toughness(8).knockback(6.0).build();
    private final class_9285 noPowerAttributes;
    private final class_9285 hasPowerAttributes;
    private final class_9285 fullSuitAttributes;
    private final class_9285 hasPowerSprintAttributes;
    private final class_9285 fullSuitSprintAttributes;

    public QuantumSuitItem(class_1741 material, class_8051 slot, String name) {
        super(material, slot, TechRebornConfig.quantumSuitCapacity, RcEnergyTier.INSANE, name);
        switch (slot) {
            case field_41934: 
            case field_41937: {
                this.noPowerAttributes = new AttributeModifierBuilder(slot).armor(3).toughness(2).build();
                this.hasPowerAttributes = new AttributeModifierBuilder(slot).armor(3).toughness(3).knockback(1.0).build();
                this.fullSuitAttributes = new AttributeModifierBuilder(slot).armor(5).toughness(5).knockback(2.0).build();
                this.fullSuitSprintAttributes = null;
                this.hasPowerSprintAttributes = null;
                break;
            }
            case field_41935: {
                this.noPowerAttributes = new AttributeModifierBuilder(slot).armor(6).toughness(2).build();
                this.hasPowerAttributes = new AttributeModifierBuilder(slot).armor(6).toughness(3).knockback(1.0).build();
                this.fullSuitAttributes = new AttributeModifierBuilder(slot).armor(10).toughness(5).knockback(3.0).build();
                this.fullSuitSprintAttributes = null;
                this.hasPowerSprintAttributes = null;
                break;
            }
            case field_41936: {
                class_1322 modifier = new class_1322(class_2960.method_60655((String)"techreborn", (String)"quantum_movement_speed"), 0.15, class_1322.class_1323.field_6328);
                this.noPowerAttributes = new AttributeModifierBuilder(slot).armor(8).toughness(2).build();
                this.hasPowerAttributes = new AttributeModifierBuilder(slot).armor(8).toughness(3).knockback(1.0).build();
                this.hasPowerSprintAttributes = this.hasPowerAttributes.method_57484(class_5134.field_23719, modifier, class_9274.field_49221);
                this.fullSuitAttributes = new AttributeModifierBuilder(slot).armor(10).toughness(5).knockback(3.0).build();
                this.fullSuitSprintAttributes = this.fullSuitAttributes.method_57484(class_5134.field_23719, modifier, class_9274.field_49221);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid slot type");
            }
        }
    }

    public long getEnergyMaxOutput(class_1799 stack) {
        return 0L;
    }

    public void tickArmor(class_1799 stack, boolean hasFullSuit, class_1657 playerEntity) {
        switch (this.getSlotType()) {
            case field_6169: {
                if (playerEntity.method_5869() && this.tryUseEnergy(stack, TechRebornConfig.quantumSuitBreathingCost)) {
                    playerEntity.method_6092(new class_1293(class_1294.field_5923, 5, 1));
                }
                if (TRItemUtils.isActive(stack) && this.tryUseEnergy(stack, TechRebornConfig.suitNightVisionCost)) {
                    playerEntity.method_6092(new class_1293(class_1294.field_5925, 220, 1, false, false));
                    break;
                }
                playerEntity.method_6016(class_1294.field_5925);
                break;
            }
            case field_6174: {
                if (TechRebornConfig.quantumSuitEnableFlight && playerEntity instanceof class_3222 && !playerEntity.method_68878()) {
                    if (this.getStoredEnergy(stack) > TechRebornConfig.quantumSuitFlyingCost) {
                        HANDLER.setAllowFlight(playerEntity, true);
                        if (HANDLER.isFlying(playerEntity)) {
                            this.tryUseEnergy(stack, TechRebornConfig.quantumSuitFlyingCost);
                        }
                        playerEntity.method_24830(true);
                    } else {
                        HANDLER.setAllowFlight(playerEntity, false);
                    }
                }
                if (!playerEntity.method_5809() || !this.tryUseEnergy(stack, TechRebornConfig.fireExtinguishCost)) break;
                playerEntity.method_5646();
                break;
            }
            case field_6172: {
                boolean sprint;
                boolean bl = sprint = TechRebornConfig.quantumSuitEnableSprint && TRItemUtils.isActive(stack);
                if (sprint && playerEntity.method_5624()) {
                    this.tryUseEnergy(stack, TechRebornConfig.quantumSuitSprintingCost);
                }
                this.applyModifier(stack, hasFullSuit, sprint);
                return;
            }
            case field_6166: {
                if (!playerEntity.method_5681() || !this.tryUseEnergy(stack, TechRebornConfig.quantumSuitSwimmingCost)) break;
                playerEntity.method_6092(new class_1293(class_1294.field_5900, 5, 1, true, false));
            }
        }
        this.applyModifier(stack, hasFullSuit, false);
    }

    private void applyModifierAndHide(class_1799 stack, class_9285 attributes, class_9285 target) {
        if (attributes != target) {
            stack.method_57379(class_9334.field_49636, (Object)target);
            stack.method_57379(class_9334.field_56400, (Object)AttributeModifierBuilder.ATTRIBUTE_HIDE);
        }
    }

    private void applyModifierAndShow(class_1799 stack, class_9285 attributes, class_9285 target) {
        if (attributes != target) {
            stack.method_57379(class_9334.field_49636, (Object)target);
            stack.method_57379(class_9334.field_56400, (Object)TRItemSettings.UNBREAKABLE_HIDE);
        }
    }

    public void applyModifier(class_1799 stack, boolean hasFullSuit, boolean sprintEnable) {
        class_9285 attributes = (class_9285)stack.method_58694(class_9334.field_49636);
        long energy = this.getStoredEnergy(stack);
        if (energy > 0L) {
            if (sprintEnable && energy >= TechRebornConfig.quantumSuitSprintingCost) {
                if (hasFullSuit) {
                    this.applyModifierAndHide(stack, attributes, this.fullSuitSprintAttributes);
                } else {
                    this.applyModifierAndShow(stack, attributes, this.hasPowerSprintAttributes);
                }
            } else if (hasFullSuit) {
                this.applyModifierAndHide(stack, attributes, this.fullSuitAttributes);
            } else {
                this.applyModifierAndShow(stack, attributes, this.hasPowerAttributes);
            }
        } else {
            this.applyModifierAndShow(stack, attributes, this.noPowerAttributes);
        }
    }

    public void onRemoved(class_1657 playerEntity) {
        class_1799 stack;
        class_1792 class_17922;
        class_1304 slotType = this.getSlotType();
        if (slotType == class_1304.field_6174 && TechRebornConfig.quantumSuitEnableFlight) {
            if (!playerEntity.method_68878() && !playerEntity.method_7325()) {
                HANDLER.setAllowFlight(playerEntity, false);
            }
        } else if (slotType == class_1304.field_6169) {
            playerEntity.method_6016(class_1294.field_5925);
        }
        if ((class_17922 = (stack = playerEntity.field_7498.method_34255()).method_7909()) instanceof QuantumSuitItem) {
            QuantumSuitItem quantumSuitItem = (QuantumSuitItem)class_17922;
            quantumSuitItem.applyModifier(stack, false, false);
            stack.method_57381(class_9334.field_49628);
        } else {
            playerEntity.method_31548().method_67533().forEach(itemStack -> {
                class_1792 patt0$temp = itemStack.method_7909();
                if (patt0$temp instanceof QuantumSuitItem) {
                    QuantumSuitItem quantumSuitItem = (QuantumSuitItem)patt0$temp;
                    quantumSuitItem.applyModifier((class_1799)itemStack, false, false);
                    itemStack.method_57381(class_9334.field_49628);
                }
            });
        }
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 thisStack = user.method_5998(hand);
        class_1304 slotType = this.getSlotType();
        if (user.method_5715() && (slotType == class_1304.field_6169 || slotType == class_1304.field_6172)) {
            TRItemUtils.switchActive(thisStack, 1, (class_1297)user);
            return class_1269.field_5812;
        }
        return super.method_7836(world, user, hand);
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> tooltip, class_1836 type) {
        if (this.getSlotType() == class_1304.field_6169) {
            TRItemUtils.buildActiveTooltip(stack, tooltip);
        }
        if (this.getSlotType() == class_1304.field_6172 && TechRebornConfig.quantumSuitEnableSprint) {
            TRItemUtils.buildActiveTooltip(stack, tooltip);
        }
    }

    public void appendArmorTooltip(class_1799 stack, List<class_2561> tooltip, boolean shift) {
        ArrayList<class_2561> buffer = new ArrayList<class_2561>();
        class_9285 attributes = (class_9285)stack.method_58694(class_9334.field_49636);
        if (AttributeModifierBuilder.equals(attributes, this.hasPowerAttributes)) {
            if (shift) {
                buffer.add((class_2561)class_2561.method_43471((String)"item.modifiers.all_equipment").method_27692(class_124.field_1080));
                AttributeModifierBuilder.appendText(buffer, FULL_SUIT, class_124.field_1078);
            }
        } else if (AttributeModifierBuilder.equals(attributes, this.fullSuitAttributes)) {
            buffer.add(class_5244.field_39003);
            class_1304 slotType = this.getSlotType();
            buffer.add((class_2561)AttributeModifierBuilder.text(slotType).method_27692(class_124.field_1080));
            if (shift) {
                AttributeModifierBuilder.appendText(buffer, attributes, class_124.field_1078);
            } else {
                AttributeModifierBuilder.appendText(buffer, slotType == class_1304.field_6172 && TechRebornConfig.quantumSuitEnableSprint && TRItemUtils.isActive(stack) ? this.hasPowerSprintAttributes : this.hasPowerAttributes, class_124.field_1078);
            }
            AttributeModifierBuilder.appendEnchantmentText(buffer, stack, slotType, class_124.field_1078);
            AttributeModifierBuilder.appendArmorEnchantmentText(buffer, stack, class_124.field_1078);
            if (!shift) {
                buffer.add(class_5244.field_39003);
                buffer.add((class_2561)class_2561.method_43471((String)"item.modifiers.full_suit").method_27692(class_124.field_1054));
                AttributeModifierBuilder.appendText(buffer, FULL_SUIT, class_124.field_1054);
            }
        } else {
            if (!shift && stack.method_57826(class_9334.field_49628)) {
                return;
            }
            buffer.add((class_2561)class_2561.method_43471((String)"item.modifiers.power").method_27692(class_124.field_1080));
            AttributeModifierBuilder.appendDiffText(buffer, this.noPowerAttributes, this.hasPowerAttributes, class_124.field_1078);
            buffer.add((class_2561)class_2561.method_43471((String)"item.modifiers.all_equipment").method_27692(class_124.field_1080));
            AttributeModifierBuilder.appendText(buffer, FULL_SUIT, class_124.field_1078);
        }
        AttributeModifierBuilder.appendEnd(tooltip, buffer);
    }
}

