/*
 * Decompiled with CFR 0.152.
 */
package com.nenio.oasis;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_5218;

public final class OasisStore {
    private static final Gson GSON = new Gson();
    private static final Type LONG_ARRAY = new TypeToken<long[]>(){}.getType();
    private final class_3218 world;
    private final LongOpenHashSet positions = new LongOpenHashSet();
    private boolean loaded = false;
    private int lastAdded = 0;
    private static class_3218 CACHED_WORLD;
    private static OasisStore CACHED_STORE;

    private OasisStore(class_3218 world) {
        this.world = world;
    }

    public static OasisStore get(class_3218 world) {
        if (world == CACHED_WORLD && CACHED_STORE != null) {
            return CACHED_STORE;
        }
        CACHED_WORLD = world;
        CACHED_STORE = new OasisStore(world);
        return CACHED_STORE;
    }

    public boolean contains(class_2338 pos) {
        this.ensureLoaded();
        return this.positions.contains(pos.method_10063());
    }

    public void add(class_2338 pos) {
        this.ensureLoaded();
        if (this.positions.add(pos.method_10063())) {
            ++this.lastAdded;
            this.save();
        }
    }

    public void remove(class_2338 pos) {
        this.ensureLoaded();
        if (this.positions.remove(pos.method_10063())) {
            this.save();
        }
    }

    public int drainLastAdded() {
        int v = this.lastAdded;
        this.lastAdded = 0;
        return v;
    }

    public long[] snapshot() {
        this.ensureLoaded();
        return this.positions.toLongArray();
    }

    private Path file() {
        Path root = this.world.method_8503().method_27050(class_5218.field_24188);
        Path data = root.resolve("data");
        String dim = this.world.method_27983().method_29177().toString().replace(':', '_').replace('/', '_').toLowerCase(Locale.ROOT);
        return data.resolve("farmerenchants_oasis_" + dim + ".json");
    }

    private void ensureLoaded() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        Path f = this.file();
        if (!Files.exists(f, new LinkOption[0])) {
            return;
        }
        try (BufferedReader br = Files.newBufferedReader(f);){
            long[] arr = (long[])GSON.fromJson((Reader)br, LONG_ARRAY);
            if (arr != null) {
                for (long l : arr) {
                    this.positions.add(l);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void save() {
        Path f = this.file();
        try {
            Files.createDirectories(f.getParent(), new FileAttribute[0]);
            try (BufferedWriter bw = Files.newBufferedWriter(f, new OpenOption[0]);){
                GSON.toJson((Object)this.positions.toLongArray(), LONG_ARRAY, (Appendable)bw);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

