/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import reborncore.client.gui.Theme;

@Environment(value=EnvType.CLIENT)
public class ThemeManager
implements SimpleResourceReloadListener<Theme> {
    private static Theme theme = null;

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"reborncore", (String)"theme_manager");
    }

    public CompletableFuture<Theme> load(class_3300 manager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            Theme theme;
            Optional theme2 = manager.method_14486(class_2960.method_60655((String)"reborncore", (String)"theme.json"));
            if (theme2.isEmpty()) {
                throw new IllegalStateException("Failed to find reborn core theme.json");
            }
            InputStreamReader reader = new InputStreamReader(((class_3298)theme2.get()).method_14482());
            try {
                JsonElement element = JsonParser.parseReader((Reader)reader);
                theme = (Theme)Theme.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow(JsonParseException::new);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to parse reborn core theme.json", e);
                }
            }
            reader.close();
            return theme;
        }, executor);
    }

    public CompletableFuture<Void> apply(Theme theme, class_3300 manager, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            ThemeManager.theme = theme;
        }, executor);
    }

    public static Theme getTheme() {
        return Objects.requireNonNull(theme, "Theme not loaded");
    }
}

