/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.fluid;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_3518;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import reborncore.common.util.FluidTextHelper;

public record FluidValue(long rawValue) {
    public static final FluidValue EMPTY = new FluidValue(0L);
    public static final FluidValue BUCKET_QUARTER = new FluidValue(20250L);
    public static final FluidValue BUCKET = new FluidValue(81000L);
    public static final Codec<FluidValue> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("value").forGetter(FluidValue::getRawValue)).apply((Applicative)instance, FluidValue::fromRaw));
    public static final class_9139<ByteBuf, FluidValue> PACKET_CODEC = class_9139.method_56434((class_9139)class_9135.field_48551, FluidValue::getRawValue, FluidValue::new);

    public static FluidValue fromMillibuckets(long millibuckets) {
        return new FluidValue(millibuckets * 81L);
    }

    public FluidValue multiply(long value) {
        return FluidValue.fromRaw(this.rawValue * value);
    }

    public FluidValue fraction(long divider) {
        return FluidValue.fromRaw(this.rawValue / divider);
    }

    public FluidValue add(FluidValue fluidValue) {
        return FluidValue.fromRaw(this.rawValue + fluidValue.rawValue);
    }

    public FluidValue subtract(FluidValue fluidValue) {
        return FluidValue.fromRaw(this.rawValue - fluidValue.rawValue);
    }

    public FluidValue min(FluidValue fluidValue) {
        return FluidValue.fromRaw(Math.min(this.rawValue, fluidValue.rawValue));
    }

    public boolean isEmpty() {
        return this.rawValue == 0L;
    }

    public boolean moreThan(FluidValue value) {
        return this.rawValue > value.rawValue;
    }

    public boolean equalOrMoreThan(FluidValue value) {
        return this.rawValue >= value.rawValue;
    }

    public boolean lessThan(FluidValue value) {
        return this.rawValue < value.rawValue;
    }

    public boolean lessThanOrEqual(FluidValue value) {
        return this.rawValue <= value.rawValue;
    }

    @Override
    public String toString() {
        return FluidTextHelper.getValueDisplay(this) + " Mb";
    }

    @Deprecated
    public long getRawValue() {
        return this.rawValue;
    }

    @Deprecated
    public static FluidValue fromRaw(long rawValue) {
        if (rawValue < 0L) {
            rawValue = 0L;
        }
        return new FluidValue(rawValue);
    }

    public static FluidValue parseFluidValue(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has("buckets")) {
                int buckets = class_3518.method_15260((JsonObject)jsonObject, (String)"buckets");
                return BUCKET.multiply(buckets);
            }
            if (jsonObject.has("droplets")) {
                long droplets = class_3518.method_22449((JsonObject)jsonObject, (String)"droplets");
                return FluidValue.fromRaw(droplets);
            }
        } else if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isNumber()) {
            return FluidValue.fromMillibuckets(jsonElement.getAsJsonPrimitive().getAsInt());
        }
        throw new JsonSyntaxException("Could not parse fluid value");
    }
}

