/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.client.gui.ClientWorkbenchRecipeIngredientTooltip;
import com.mrcrayfish.furniture.refurbished.client.gui.ClientWorkbenchRecipeTooltip;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.ElectricityContainerScreen;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.core.ModTags;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.crafting.WorkbenchContructingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.WorkbenchMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWorkbench;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_361;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5683;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7919;
import net.minecraft.class_8001;
import net.minecraft.class_8666;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class WorkbenchScreen
extends ElectricityContainerScreen<WorkbenchMenu> {
    public static final class_2960 WORKBENCH_TEXTURE = Utils.resource("textures/gui/container/workbench.png");
    public static final class_8666 FILTER_BUTTON_SPRITES = new class_8666(class_2960.method_60656((String)"recipe_book/filter_enabled"), class_2960.method_60656((String)"recipe_book/filter_disabled"), class_2960.method_60656((String)"recipe_book/filter_enabled_highlighted"), class_2960.method_60656((String)"recipe_book/filter_disabled_highlighted"));
    public static final class_8666 SEARCH_NEIGHBOURS_SPRITES = new class_8666(Utils.resource("search_neighbours_selected"), Utils.resource("search_neighbours_unselected"), Utils.resource("search_neighbours_selected_focused"), Utils.resource("search_neighbours_unselected_focused"));
    private static final int BUTTON_SIZE = 20;
    private static final int RECIPES_PER_ROW = 6;
    private static final int WINDOW_WIDTH = 120;
    private static final int WINDOW_HEIGHT = 88;
    private static final int SCROLL_SPEED = 10;
    private static final int SCROLLBAR_HEIGHT = 15;
    private static final int SCROLLBAR_AREA = 106;
    private static final Category CATEGORY_ALL = new Category(new class_6862[0]);
    private static final Category CATEGORY_GENERAL = new Category(ModTags.Items.GENERAL, ModTags.Items.BEDROOM);
    private static final Category CATEGORY_KITCHEN = new Category(ModTags.Items.KITCHEN);
    private static final Category CATEGORY_OUTDOORS = new Category(ModTags.Items.OUTDOORS);
    private static final Category CATEGORY_BATHROOM = new Category(ModTags.Items.BATHROOM);
    private static final Category CATEGORY_ELECTRONICS = new Category(ModTags.Items.ELECTRONICS);
    private static final List<Category> CATEGORIES = List.of(CATEGORY_ALL, CATEGORY_GENERAL, CATEGORY_KITCHEN, CATEGORY_OUTDOORS, CATEGORY_BATHROOM, CATEGORY_ELECTRONICS);
    private static boolean craftableOnly;
    protected final Map<class_2960, Integer> recipeToIndex;
    protected final List<class_8786<WorkbenchContructingRecipe>> displayRecipes = new ArrayList<class_8786<WorkbenchContructingRecipe>>();
    protected class_361 craftableOnlyButton;
    protected class_361 searchNeighboursButton;
    protected double scroll;
    protected int hoveredIndex = -1;
    protected int clickedY = -1;

    public WorkbenchScreen(WorkbenchMenu menu, class_1661 playerInventory, class_2561 title) {
        super(menu, playerInventory, title);
        this.field_2792 = 216;
        this.field_2779 = 229;
        this.field_25269 = 28;
        this.field_25270 = this.field_2779 - 94;
        ((WorkbenchMenu)this.field_2797).setUpdateCallback(this::updateRecipes);
        this.recipeToIndex = (Map)class_156.method_656(() -> {
            HashMap<class_2960, Integer> map = new HashMap<class_2960, Integer>();
            List<class_8786<WorkbenchContructingRecipe>> recipes = menu.getRecipes();
            for (int i = 0; i < recipes.size(); ++i) {
                map.put(recipes.get(i).comp_1932().method_29177(), i);
            }
            return ImmutableMap.copyOf(map);
        });
        this.updateRecipes();
        this.scrollToSelected();
    }

    private void updateRecipes() {
        this.displayRecipes.clear();
        Category selectedCategory = CATEGORIES.stream().filter(Category::isEnabled).findFirst().orElse(CATEGORY_ALL);
        for (class_8786<WorkbenchContructingRecipe> holder2 : ((WorkbenchMenu)this.field_2797).getRecipes()) {
            if (!selectedCategory.in(((WorkbenchContructingRecipe)holder2.comp_1933()).getResult()) || craftableOnly && !((WorkbenchMenu)this.field_2797).canCraft(holder2)) continue;
            this.displayRecipes.add(holder2);
        }
        this.displayRecipes.sort(Comparator.comparing(holder -> ((WorkbenchContructingRecipe)holder.comp_1933()).getResultId()));
    }

    @Override
    protected int getBannerTop() {
        return this.field_2800 + 52;
    }

    protected void method_25426() {
        super.method_25426();
        this.craftableOnlyButton = (class_361)this.method_37063((class_364)new CraftableButton(this.field_2776 + 184, this.field_2800 + 44, 26, 16, craftableOnly));
        this.craftableOnlyButton.method_1962(FILTER_BUTTON_SPRITES);
        this.searchNeighboursButton = (class_361)this.method_37063((class_364)new SearchNeighboursButton(this.field_2776 + 184, this.field_2800 + 62, 26, 16, ((WorkbenchMenu)this.field_2797).shouldSearchNeighbours()));
        this.searchNeighboursButton.method_1962(SEARCH_NEIGHBOURS_SPRITES);
        this.method_37063((class_364)new CategoryButton(this.field_2776 + 46, this.field_2800 + 108, 236, 55, CATEGORY_ALL));
        this.method_37063((class_364)new CategoryButton(this.field_2776 + 66, this.field_2800 + 108, 236, 69, CATEGORY_GENERAL));
        this.method_37063((class_364)new CategoryButton(this.field_2776 + 86, this.field_2800 + 108, 236, 83, CATEGORY_KITCHEN));
        this.method_37063((class_364)new CategoryButton(this.field_2776 + 106, this.field_2800 + 108, 236, 97, CATEGORY_OUTDOORS));
        this.method_37063((class_364)new CategoryButton(this.field_2776 + 126, this.field_2800 + 108, 236, 111, CATEGORY_BATHROOM));
        this.method_37063((class_364)new CategoryButton(this.field_2776 + 146, this.field_2800 + 108, 236, 125, CATEGORY_ELECTRONICS));
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.searchNeighboursButton.method_1964(((WorkbenchMenu)this.field_2797).shouldSearchNeighbours());
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        this.method_2380(graphics, mouseX, mouseY);
        if (((WorkbenchMenu)this.field_2797).isPowered() && this.hoveredIndex != -1) {
            this.renderRecipeTooltip(graphics, mouseX, mouseY, this.hoveredIndex);
        }
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTick, int mouseX, int mouseY) {
        graphics.method_25290(class_10799.field_56883, WORKBENCH_TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
        this.renderScrollbar(graphics, mouseY);
        this.renderRecipes(graphics, partialTick, mouseX, mouseY);
        this.renderOverlay(graphics);
        super.method_2389(graphics, partialTick, mouseX, mouseY);
        if (this.method_2378(199, 5, 10, 10, mouseX, mouseY)) {
            graphics.method_71274(ScreenHelper.createMultilineTooltip(List.of(Utils.translation("gui", "how_to", new Object[0]).method_27692(class_124.field_1065), Utils.translation("gui", "workbench_info", new Object[0]))).method_47405(this.field_22787), mouseX, mouseY);
        }
    }

    private void renderScrollbar(class_332 graphics, int mouseY) {
        int textureU = this.getMaxScroll() > 0 ? 216 : 228;
        graphics.method_25290(class_10799.field_56883, WORKBENCH_TEXTURE, this.field_2776 + 169, this.field_2800 + 18 + this.getScrollbarPosition(mouseY), (float)textureU, 40.0f, 12, 15, 256, 256);
    }

    private void renderRecipes(class_332 graphics, float partialTick, int mouseX, int mouseY) {
        this.hoveredIndex = -1;
        graphics.method_44379(this.field_2776 + 46, this.field_2800 + 18, this.field_2776 + 46 + 120, this.field_2800 + 18 + 88);
        List<class_8786<WorkbenchContructingRecipe>> recipes = this.displayRecipes;
        double scroll = this.getScrollAmount(mouseY);
        int startIndex = (int)(scroll / 20.0) * 6;
        int endIndex = startIndex + class_3532.method_15384((double)5.4) * 6;
        boolean mouseInWindow = ScreenHelper.isMouseWithinBounds(mouseX, mouseY, this.field_2776 + 46, this.field_2800 + 18, 120, 88);
        for (int i = startIndex; i < endIndex && i < recipes.size(); ++i) {
            class_8786<WorkbenchContructingRecipe> recipe = recipes.get(i);
            int recipeIndex = this.recipeToIndex.get(recipe.comp_1932().method_29177());
            boolean canCraft = ((WorkbenchMenu)this.field_2797).canCraft(recipe);
            boolean selected = recipeIndex == ((WorkbenchMenu)this.field_2797).getSelectedRecipeIndex();
            int buttonX = this.field_2776 + 46 + i % 6 * 20;
            int buttonY = this.field_2800 + 18 + i / 6 * 20 - (int)scroll;
            int textureU = 216 + (!canCraft ? 20 : 0);
            int textureV = selected ? 20 : 0;
            graphics.method_25290(class_10799.field_56883, WORKBENCH_TEXTURE, buttonX, buttonY, (float)textureU, (float)textureV, 20, 20, 256, 256);
            graphics.method_51445(((WorkbenchContructingRecipe)recipe.comp_1933()).getResult(), buttonX + 2, buttonY + 2);
            if (!mouseInWindow || !ScreenHelper.isMouseWithinBounds(mouseX, mouseY, buttonX, buttonY, 20, 20)) continue;
            this.hoveredIndex = recipeIndex;
        }
        graphics.method_44380();
    }

    private void renderOverlay(class_332 graphics) {
        if (!((WorkbenchMenu)this.field_2797).isPowered()) {
            graphics.method_25294(this.field_2776 + 46, this.field_2800 + 18, this.field_2776 + 46 + 120, this.field_2800 + 18 + 88, -1442840576);
        }
    }

    private void renderRecipeTooltip(class_332 graphics, int mouseX, int mouseY, int recipeIndex) {
        class_8786<WorkbenchContructingRecipe> holder = ((WorkbenchMenu)this.field_2797).getRecipes().get(recipeIndex);
        ArrayList<Object> components = new ArrayList<Object>();
        components.add(new class_5683(((WorkbenchContructingRecipe)holder.comp_1933()).getResult().method_7964().method_30937()));
        if (!class_437.method_25442()) {
            components.add(new ClientWorkbenchRecipeTooltip((WorkbenchMenu)this.field_2797, (WorkbenchContructingRecipe)holder.comp_1933()));
            components.add(new class_5683(Components.GUI_HOLD_SHIFT_DETAILS.method_30937()));
        } else {
            HashMap counted = new HashMap();
            ((WorkbenchContructingRecipe)holder.comp_1933()).getMaterials().forEach(material -> components.add(new ClientWorkbenchRecipeIngredientTooltip((WorkbenchMenu)this.field_2797, (StackedIngredient)material, counted)));
        }
        graphics.method_51435(this.field_22793, components, mouseX, mouseY, class_8001.field_41687, null);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (((WorkbenchMenu)this.field_2797).isPowered() && this.hoveredIndex != -1 && this.field_22787 != null && this.field_22787.field_1761 != null) {
                Network.getPlay().sendToServer((Object)new MessageWorkbench.SelectRecipe(this.hoveredIndex));
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                return true;
            }
            if (ScreenHelper.isMouseWithinBounds(mouseX, mouseY, this.field_2776 + 169, this.field_2800 + 18 + this.getScrollbarPosition((int)mouseY), 12, 15)) {
                this.clickedY = (int)mouseY;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.clickedY != -1) {
            this.scroll = this.getScrollAmount((int)mouseY);
            this.clickedY = -1;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.clickedY == -1 && ScreenHelper.isMouseWithinBounds(mouseX, mouseY, this.field_2776 + 46, this.field_2800 + 18, 135, 88)) {
            this.scroll = class_3532.method_15350((double)(this.scroll - deltaY * 10.0), (double)0.0, (double)this.getMaxScroll());
            return true;
        }
        return super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    private void updateScroll() {
        this.scroll = class_3532.method_15350((double)this.scroll, (double)0.0, (double)this.getMaxScroll());
    }

    private double getScrollAmount(int mouseY) {
        return class_3532.method_15350((double)(this.scroll + (double)this.getScrollbarDelta(mouseY)), (double)0.0, (double)this.getMaxScroll());
    }

    private int getMaxScroll() {
        return !((WorkbenchMenu)this.field_2797).isPowered() ? 0 : Math.max(0, (int)(Math.ceil((double)this.displayRecipes.size() / 6.0) * 20.0) - 88);
    }

    private int getScrollbarPosition(int mouseY) {
        return (int)(this.getScrollAmount(mouseY) / (double)this.getMaxScroll() * 91.0);
    }

    private int getScrollbarDelta(int mouseY) {
        double scrollPerUnit = (double)this.getMaxScroll() / 91.0;
        return this.clickedY != -1 ? (int)((double)(mouseY - this.clickedY) * scrollPerUnit) : 0;
    }

    private void scrollToSelected() {
        int selectedIndex = ((WorkbenchMenu)this.field_2797).getSelectedRecipeIndex();
        if (selectedIndex >= 0 && selectedIndex < this.displayRecipes.size()) {
            int newScroll = selectedIndex / 6 * 20;
            this.scroll = class_3532.method_15340((int)(newScroll -= 34), (int)0, (int)this.getMaxScroll());
        }
    }

    public void method_25395(@Nullable class_364 listener) {
        if (listener == this.craftableOnlyButton || listener == this.searchNeighboursButton) {
            return;
        }
        super.method_25395(listener);
    }

    public static class Category {
        private final class_6862<class_1792>[] tags;
        private boolean enabled;

        @SafeVarargs
        private Category(class_6862<class_1792> ... tags) {
            this.tags = tags;
            this.enabled = tags.length == 0;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean in(class_1799 result) {
            if (this.tags.length == 0) {
                return true;
            }
            for (class_6862<class_1792> tag : this.tags) {
                if (!result.method_31573(tag)) continue;
                return true;
            }
            return false;
        }
    }

    private class CraftableButton
    extends class_361 {
        private static final class_2561 VANILLA_ONLY_CRAFTABLE = class_2561.method_43471((String)"gui.recipebook.toggleRecipes.craftable");
        private static final class_2561 VANILLA_ALL_RECIPES = class_2561.method_43471((String)"gui.recipebook.toggleRecipes.all");

        public CraftableButton(int x, int y, int width, int height, boolean state) {
            super(x, y, width, height, state);
            this.updateTooltip();
        }

        public void method_25348(double mouseX, double mouseY) {
            craftableOnly = this.field_2194 = !this.field_2194;
            WorkbenchScreen.this.updateRecipes();
            this.updateTooltip();
        }

        private void updateTooltip() {
            this.method_47400(class_7919.method_47407((class_2561)(this.field_2194 ? VANILLA_ONLY_CRAFTABLE : VANILLA_ALL_RECIPES)));
        }
    }

    private static class SearchNeighboursButton
    extends class_361 {
        private static final class_2561 SEARCH_NEIGHBOURS_OFF = Utils.translation("gui", "workbench.search_neighbours.off", new Object[0]);
        private static final class_2561 SEARCH_NEIGHBOURS_ON = Utils.translation("gui", "workbench.search_neighbours.on", new Object[0]);

        public SearchNeighboursButton(int x, int y, int width, int height, boolean state) {
            super(x, y, width, height, state);
            this.updateTooltip();
        }

        public void method_25348(double mouseX, double mouseY) {
            Network.getPlay().sendToServer((Object)new MessageWorkbench.SearchNeighbours());
        }

        public void method_1964(boolean state) {
            boolean original = this.method_1965();
            super.method_1964(state);
            if (original != state) {
                this.updateTooltip();
            }
        }

        private void updateTooltip() {
            this.method_47400(class_7919.method_47407((class_2561)(this.field_2194 ? SEARCH_NEIGHBOURS_ON : SEARCH_NEIGHBOURS_OFF)));
        }
    }

    public class CategoryButton
    extends class_4185 {
        private final int iconU;
        private final int iconV;
        private final Category category;

        protected CategoryButton(int x, int y, int iconU, int iconV, Category category) {
            super(x, y, 20, 16, class_5244.field_39003, btn -> ((CategoryButton)btn).toggle(), field_40754);
            this.iconU = iconU;
            this.iconV = iconV;
            this.category = category;
            this.updateTooltip();
        }

        private void updateTooltip() {
            if (this.category.tags.length > 0) {
                class_2960 tagId = this.category.tags[0].comp_327();
                String tooltipTitle = String.format("filterCategory.%s.%s", tagId.method_12836(), tagId.method_12832().replace("/", "."));
                String tooltipDesc = tooltipTitle + ".desc";
                this.method_47400(ScreenHelper.createMultilineTooltip(List.of(class_2561.method_43471((String)tooltipTitle), class_2561.method_43471((String)tooltipDesc).method_27692(class_124.field_1080))));
            } else {
                this.method_47400(class_7919.method_47407((class_2561)Components.GUI_SHOW_ALL_CATEGORIES));
            }
        }

        private void toggle() {
            CATEGORIES.forEach(c -> c.setEnabled(false));
            this.category.enabled = true;
            WorkbenchScreen.this.updateRecipes();
            WorkbenchScreen.this.updateScroll();
        }

        protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            int textureV = this.field_22762 ? 87 : (this.category.enabled ? 71 : 55);
            graphics.method_25290(class_10799.field_56883, WORKBENCH_TEXTURE, this.method_46426(), this.method_46427(), 216.0f, (float)textureV, 20, 16, 256, 256);
            graphics.method_25290(class_10799.field_56883, WORKBENCH_TEXTURE, this.method_46426() + 3, this.method_46427() + 1, (float)this.iconU, (float)this.iconV, 14, 14, 256, 256);
        }
    }
}

