/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.mail;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.blockentity.MailboxBlockEntity;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryResult;
import com.mrcrayfish.furniture.refurbished.mail.IMailbox;
import com.mrcrayfish.furniture.refurbished.mail.Mailbox;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.class_10741;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class DeliveryService
extends class_18 {
    private static final Function<MinecraftServer, Codec<DeliveryService>> CODEC = server -> RecordCodecBuilder.create(instance -> instance.group((App)Mailbox.CODEC.listOf().fieldOf("Mailboxes").forGetter(service -> List.copyOf(service.mailboxes.values()))).apply((Applicative)instance, mailboxes -> {
        DeliveryService service = new DeliveryService((MinecraftServer)server);
        mailboxes.forEach(service::addMailbox);
        return service;
    }));
    private static final class_10741<DeliveryService> TYPE = new class_10741("refurbished_furniture_delivery_service", context -> new DeliveryService(context.method_67417().method_8503()), context -> CODEC.apply(context.method_67417().method_8503()), null);
    private final MinecraftServer server;
    private final Map<Pair<class_2960, class_2338>, Mailbox> locator = new HashMap<Pair<class_2960, class_2338>, Mailbox>();
    private final Map<UUID, Mailbox> mailboxes = new ConcurrentHashMap<UUID, Mailbox>();
    private final Queue<Mailbox> removal = new ArrayDeque<Mailbox>();
    private final Map<UUID, Pair<class_2960, class_2338>> pendingNames = new HashMap<UUID, Pair<class_2960, class_2338>>();

    public static Optional<DeliveryService> get(MinecraftServer server) {
        class_3218 level = server.method_3847(class_1937.field_25179);
        if (level != null) {
            return Optional.of((DeliveryService)level.method_17983().method_17924(TYPE));
        }
        return Optional.empty();
    }

    public DeliveryService(MinecraftServer server) {
        this.server = server;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public void serverTick() {
        while (!this.removal.isEmpty()) {
            Mailbox mailbox2 = this.removal.poll();
            mailbox2.spawnQueueIntoLevel(this);
            this.mailboxes.remove(mailbox2.id());
            this.locator.remove(Pair.of((Object)mailbox2.levelKey().method_29177(), (Object)mailbox2.pos()));
            this.method_80();
        }
        this.mailboxes.forEach((uuid, mailbox) -> mailbox.tick(this));
    }

    public DeliveryResult sendMail(UUID id, class_1799 stack) {
        if (stack.method_7960()) {
            return DeliveryResult.createFail("delivery_service.invalid_item");
        }
        Mailbox mailbox = this.mailboxes.get(id);
        if (mailbox == null) {
            return DeliveryResult.createFail(Utils.translationKey("gui", "delivery_service.unknown_mailbox"));
        }
        if (mailbox.queue().size() >= (Integer)Config.SERVER.mailing.deliveryQueueSize.get()) {
            return DeliveryResult.createFail(Utils.translationKey("gui", "delivery_service.mailbox_queue_full"));
        }
        if (!DeliveryService.isDeliverableDimension(mailbox.levelKey())) {
            return DeliveryResult.createFail(Utils.translationKey("gui", "delivery_service.undeliverable_dimension"));
        }
        mailbox.queue().offer(stack);
        this.method_80();
        return DeliveryResult.createSuccess(Utils.translationKey("gui", "delivery_service.package_sent"));
    }

    public void removeMailbox(Mailbox mailbox) {
        this.removal.offer(mailbox);
    }

    public void removeMailbox(UUID mailboxId) {
        Mailbox mailbox = this.mailboxes.get(mailboxId);
        if (mailbox != null) {
            this.removal.offer(mailbox);
        }
    }

    public boolean canCreateMailbox(class_1657 player) {
        long count = this.mailboxes.values().stream().filter(box -> box.owner().stream().anyMatch(uuid -> uuid.equals(player.method_5667()))).count();
        return (long)((Integer)Config.SERVER.mailing.maxMailboxesPerPlayer.get()).intValue() > count;
    }

    @Nullable
    public Mailbox getOrCreateMailBox(MailboxBlockEntity entity) {
        if (entity.method_11015()) {
            return null;
        }
        this.duplicateIdCheck(entity);
        Mailbox mailbox = this.mailboxes.get(entity.getId());
        if (mailbox != null) {
            return this.removal.contains(mailbox) ? null : mailbox;
        }
        class_5321 levelKey = entity.method_10997().method_27983();
        class_2338 pos = entity.method_11016();
        return this.addMailbox(new Mailbox(entity.getId(), (class_5321<class_1937>)levelKey, pos));
    }

    private Mailbox addMailbox(Mailbox mailbox) {
        this.mailboxes.put(mailbox.id(), mailbox);
        this.locator.put((Pair<class_2960, class_2338>)Pair.of((Object)mailbox.levelKey().method_29177(), (Object)mailbox.pos()), mailbox);
        mailbox.setService(this);
        this.method_80();
        return mailbox;
    }

    private void duplicateIdCheck(MailboxBlockEntity blockEntity) {
        Mailbox box = this.mailboxes.get(blockEntity.getId());
        if (box != null && !box.pos().equals((Object)blockEntity.method_11016())) {
            blockEntity.regenerateId();
        }
    }

    public Optional<Mailbox> getMailboxAtPosition(class_1937 level, class_2338 pos) {
        return Optional.ofNullable(this.locator.get(Pair.of((Object)level.method_27983().method_29177(), (Object)pos)));
    }

    public void markMailboxAsPendingName(class_1657 player, class_1937 level, class_2338 pos) {
        this.pendingNames.put(player.method_5667(), (Pair<class_2960, class_2338>)Pair.of((Object)level.method_27983().method_29177(), (Object)pos));
    }

    public boolean renameMailbox(class_1657 player, class_1937 level, class_2338 pos, String customName) {
        Pair<class_2960, class_2338> pendingLocation = this.pendingNames.remove(player.method_5667());
        return this.getMailboxAtPosition(level, pos).map(mailbox -> {
            if (!Objects.equals(mailbox.owner().orElse(null), player.method_5667())) {
                return false;
            }
            Pair location = Pair.of((Object)level.method_27983().method_29177(), (Object)pos);
            return Objects.equals(location, pendingLocation) && mailbox.rename(customName);
        }).orElse(false);
    }

    public Collection<IMailbox> getMailboxes() {
        return Collections.unmodifiableCollection(this.mailboxes.values());
    }

    private void load(class_11368 input) {
        class_11368.class_11369 list = input.method_71437("Mailboxes", Mailbox.CODEC);
        list.forEach(this::addMailbox);
    }

    public void save(class_11372 output) {
        class_11372.class_11373 list = output.method_71467("Mailboxes", Mailbox.CODEC);
        this.mailboxes.forEach((id, mailbox) -> list.method_71484(mailbox));
    }

    @Nullable
    private static class_5321<class_1937> createLevelKey(String levelKey) {
        class_5321 class_53212;
        if (levelKey.isBlank()) {
            class_53212 = null;
        } else {
            switch (levelKey) {
                case "minecraft:overworld": {
                    class_53212 = class_1937.field_25179;
                    break;
                }
                case "minecraft:the_nether": {
                    class_53212 = class_1937.field_25180;
                    break;
                }
                case "minecraft:the_end": {
                    class_53212 = class_1937.field_25181;
                    break;
                }
                default: {
                    class_53212 = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)levelKey));
                }
            }
        }
        return class_53212;
    }

    public static boolean isBannedItem(class_1799 stack) {
        if (((Boolean)Config.SERVER.mailing.banSendingItemsWithInventories.get()).booleanValue() && !stack.method_7909().method_31568()) {
            return true;
        }
        String name = stack.method_7909().method_7876();
        return ((List)Config.SERVER.mailing.bannedItems.get()).contains(name);
    }

    public static boolean isDeliverableDimension(class_1937 level) {
        return DeliveryService.isDeliverableDimension((class_5321<class_1937>)level.method_27983());
    }

    public static boolean isDeliverableDimension(class_5321<class_1937> key) {
        List validDimensions = (List)Config.SERVER.mailing.allowedDimensions.get();
        if (!validDimensions.isEmpty()) {
            return validDimensions.contains(key.method_29177().toString());
        }
        return true;
    }
}

