/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.bytecodecs;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.base.object.ObjectByteCodec;
import com.teamresourceful.resourcefullib.common.ApiProxy;
import com.teamresourceful.resourcefullib.common.bytecodecs.CompoundTagByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.IdMapByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.StreamCodecByteCodec;
import com.teamresourceful.resourcefullib.common.exceptions.UtilityClassException;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_4076;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import org.joml.Vector3f;

public final class ExtraByteCodecs {
    public static final ByteCodec<class_2960> RESOURCE_LOCATION = ByteCodec.STRING.map(class_2960::method_60654, class_2960::toString);
    public static final ByteCodec<class_5321<class_1937>> DIMENSION = ExtraByteCodecs.resourceKey(class_7924.field_41223);
    public static final ByteCodec<class_2338> BLOCK_POS = ByteCodec.LONG.map(class_2338::method_10092, class_2338::method_10063);
    public static final ByteCodec<class_1923> CHUNK_POS = ByteCodec.LONG.map(class_1923::new, class_1923::method_8324);
    public static final ByteCodec<class_4076> SECTION_POS = ByteCodec.LONG.map(class_4076::method_18677, class_4076::method_18694);
    public static final ByteCodec<class_4208> GLOBAL_POS = ObjectByteCodec.create((ObjectEntryByteCodec)DIMENSION.fieldOf(class_4208::comp_2207), (ObjectEntryByteCodec)BLOCK_POS.fieldOf(class_4208::comp_2208), class_4208::method_19443);
    public static final ByteCodec<Vector3f> VECTOR_3F = ObjectByteCodec.create((ObjectEntryByteCodec)ByteCodec.FLOAT.fieldOf(Vector3f::x), (ObjectEntryByteCodec)ByteCodec.FLOAT.fieldOf(Vector3f::y), (ObjectEntryByteCodec)ByteCodec.FLOAT.fieldOf(Vector3f::z), Vector3f::new);
    public static final ByteCodec<class_2487> NULLABLE_COMPOUND_TAG = CompoundTagByteCodec.INSTANCE.map(value -> value.orElse(null), Optional::ofNullable);
    public static final ByteCodec<class_2487> NONNULL_COMPOUND_TAG = CompoundTagByteCodec.INSTANCE.map(Optional::orElseThrow, Optional::of);
    public static final ByteCodec<Optional<class_2487>> COMPOUND_TAG = CompoundTagByteCodec.INSTANCE;
    public static final ByteCodec<class_2561> COMPONENT = StreamCodecByteCodec.ofRegistry(class_8824.field_48540);
    public static final ByteCodec<class_1792> ITEM = ExtraByteCodecs.registry(class_7923.field_41178);
    public static final ByteCodec<class_3611> FLUID = ExtraByteCodecs.registry(class_7923.field_41173);
    public static final ByteCodec<class_1799> ITEM_STACK = StreamCodecByteCodec.ofRegistry(class_1799.field_48349);
    public static final ByteCodec<class_1856> INGREDIENT = StreamCodecByteCodec.ofRegistry(class_1856.field_48355);

    private ExtraByteCodecs() throws UtilityClassException {
        throw new UtilityClassException();
    }

    public static <T, R extends class_2378<T>> ByteCodec<class_5321<T>> resourceKey(class_5321<R> registry) {
        return RESOURCE_LOCATION.map(id -> class_5321.method_29179((class_5321)registry, (class_2960)id), class_5321::method_29177);
    }

    public static <T> ByteCodec<T> registry(class_2359<T> map) {
        return new IdMapByteCodec<T>(map);
    }

    public static <A, B> ByteCodec<Pair<A, B>> pair(ByteCodec<A> first, ByteCodec<B> second) {
        return ObjectByteCodec.create((ObjectEntryByteCodec)first.fieldOf(Pair::getFirst), (ObjectEntryByteCodec)second.fieldOf(Pair::getSecond), Pair::of);
    }

    public static <A, B> ByteCodec<Either<A, B>> either(ByteCodec<A> first, ByteCodec<B> second) {
        ByteCodec left = first.map(Either::left, either -> either.left().orElseThrow());
        ByteCodec right = second.map(Either::right, either -> either.right().orElseThrow());
        return ByteCodec.BOOLEAN.dispatch(value -> value != false ? left : right, either -> (Boolean)either.map(l -> true, r -> false));
    }

    public static class_2540 toFriendly(ByteBuf buffer) {
        class_2540 friendlyByteBuf;
        return buffer instanceof class_2540 ? (friendlyByteBuf = (class_2540)buffer) : new class_2540(buffer);
    }

    public static class_9129 toRegistry(ByteBuf buffer) {
        if (buffer instanceof class_9129) {
            class_9129 registryFriendlyByteBuf = (class_9129)buffer;
            return registryFriendlyByteBuf;
        }
        if (!ApiProxy.hasProxy()) {
            throw new IllegalStateException("No proxy found.");
        }
        return new class_9129(buffer, ApiProxy.getRegistry());
    }
}

