/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.render;

import com.zurrtum.create.AllContraptionTypeTags;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.content.contraptions.render.ContraptionEntityRenderer;
import com.zurrtum.create.client.content.contraptions.render.OrientedContraptionVisual;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_5617;

@Environment(value=EnvType.CLIENT)
public class OrientedContraptionEntityRenderer<C extends OrientedContraptionEntity, S extends OrientedContraptionState>
extends ContraptionEntityRenderer<C, S> {
    public OrientedContraptionEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public S createRenderState() {
        return (S)((Object)new OrientedContraptionState());
    }

    @Override
    public boolean shouldRender(C entity, class_4604 frustum, double cameraX, double cameraY, double cameraZ) {
        if (!super.shouldRender(entity, frustum, cameraX, cameraY, cameraZ)) {
            return false;
        }
        return entity.method_5854() != null || !((AbstractContraptionEntity)((Object)entity)).getContraption().getType().is(AllContraptionTypeTags.REQUIRES_VEHICLE_FOR_RENDER);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateRenderState(C entity, S state, float tickProgress) {
        super.updateRenderState(entity, state, tickProgress);
        ((OrientedContraptionState)((Object)state)).seed = entity.method_5628();
        ((OrientedContraptionState)((Object)state)).angleInitialYaw = ((OrientedContraptionEntity)((Object)entity)).getInitialYaw();
        ((OrientedContraptionState)((Object)state)).prevYaw = ((OrientedContraptionEntity)((Object)entity)).prevYaw;
        ((OrientedContraptionState)((Object)state)).yaw = ((OrientedContraptionEntity)((Object)entity)).yaw;
        ((OrientedContraptionState)((Object)state)).prevPitch = ((OrientedContraptionEntity)((Object)entity)).prevPitch;
        ((OrientedContraptionState)((Object)state)).pitch = ((OrientedContraptionEntity)((Object)entity)).pitch;
        class_1297 ridingEntity = entity.method_5854();
        if (ridingEntity instanceof class_1688) {
            class_1688 cart;
            ((OrientedContraptionState)((Object)state)).cart = cart = (class_1688)ridingEntity;
        } else if (ridingEntity instanceof AbstractContraptionEntity) {
            class_1688 cart;
            AbstractContraptionEntity be = (AbstractContraptionEntity)ridingEntity;
            class_1297 class_12972 = ridingEntity.method_5854();
            if (!(class_12972 instanceof class_1688)) {
                ((OrientedContraptionState)((Object)state)).cart = null;
                ((OrientedContraptionState)((Object)state)).entity = entity;
                ((OrientedContraptionState)((Object)state)).riding = be;
                return;
            }
            ((OrientedContraptionState)((Object)state)).cart = cart = (class_1688)class_12972;
        } else {
            ((OrientedContraptionState)((Object)state)).cart = null;
        }
        ((OrientedContraptionState)((Object)state)).entity = null;
        ((OrientedContraptionState)((Object)state)).riding = null;
    }

    @Override
    public void transform(OrientedContraptionState state, class_4587 matrixStack, float partialTicks) {
        float angleYaw = -(partialTicks == 1.0f ? state.yaw : AngleHelper.angleLerp(partialTicks, state.prevYaw, state.yaw));
        float anglePitch = partialTicks == 1.0f ? state.pitch : AngleHelper.angleLerp(partialTicks, state.prevPitch, state.pitch);
        matrixStack.method_46416(-0.5f, 0.0f, -0.5f);
        if (state.cart != null) {
            OrientedContraptionVisual.repositionOnCart(matrixStack, partialTicks, state.cart);
        } else if (state.riding != null) {
            OrientedContraptionVisual.repositionOnContraption(state.entity, matrixStack, partialTicks, state.riding);
        }
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(matrixStack).nudge(state.seed)).center()).rotateYDegrees(angleYaw)).rotateZDegrees(anglePitch)).rotateYDegrees(state.angleInitialYaw)).uncenter();
    }

    @Environment(value=EnvType.CLIENT)
    public static class OrientedContraptionState
    extends ContraptionEntityRenderer.AbstractContraptionState {
        int seed;
        float angleInitialYaw;
        float prevYaw;
        float yaw;
        float prevPitch;
        float pitch;
        class_1688 cart = null;
        OrientedContraptionEntity entity = null;
        AbstractContraptionEntity riding = null;
    }
}

