/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.blueprint;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.logistics.tableCloth.BlueprintOverlayShopContext;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.content.equipment.blueprint.BlueprintEntity;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.tableCloth.TableClothBlockEntity;
import com.zurrtum.create.content.trains.track.TrackPlacement;
import com.zurrtum.create.infrastructure.component.ShoppingList;
import com.zurrtum.create.infrastructure.packet.c2s.BlueprintPreviewRequestPacket;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3966;
import net.minecraft.class_5684;
import net.minecraft.class_746;
import net.minecraft.class_8001;
import net.minecraft.class_8002;

@Environment(value=EnvType.CLIENT)
public class BlueprintOverlayRenderer {
    static boolean active;
    static boolean empty;
    static boolean noOutput;
    static boolean lastSneakState;
    static BlueprintEntity.BlueprintSection lastTargetedSection;
    static BlueprintOverlayShopContext shopContext;
    static Map<class_1799, class_1799[]> cachedRenderedFilters;
    static List<Pair<class_1799, Boolean>> ingredients;
    static List<class_1799> results;
    static boolean resultCraftable;

    public static void tick(class_310 mc) {
        BlueprintEntity.BlueprintSection last = lastTargetedSection;
        lastTargetedSection = null;
        active = false;
        noOutput = false;
        shopContext = null;
        if (mc.field_1761.method_2920() == class_1934.field_9219) {
            return;
        }
        class_239 mouseOver = mc.field_1765;
        if (mouseOver == null) {
            return;
        }
        if (mouseOver.method_17783() != class_239.class_240.field_1331) {
            return;
        }
        class_3966 entityRay = (class_3966)mouseOver;
        class_1297 class_12972 = entityRay.method_17782();
        if (!(class_12972 instanceof BlueprintEntity)) {
            return;
        }
        BlueprintEntity blueprintEntity = (BlueprintEntity)class_12972;
        BlueprintEntity.BlueprintSection sectionAt = blueprintEntity.getSectionAt(entityRay.method_17784().method_1020(blueprintEntity.method_19538()));
        lastTargetedSection = last;
        active = true;
        boolean sneak = mc.field_1724.method_5715();
        if (sectionAt != lastTargetedSection || AnimationTickHolder.getTicks() % 10 == 0 || lastSneakState != sneak) {
            BlueprintOverlayRenderer.rebuild(mc, blueprintEntity, sectionAt, sneak);
        }
        lastTargetedSection = sectionAt;
        lastSneakState = sneak;
    }

    public static void displayTrackRequirements(TrackPlacement.PlacementInfo info, class_1799 pavementItem) {
        if (active) {
            return;
        }
        BlueprintOverlayRenderer.prepareCustomOverlay();
        for (int tracks = info.requiredTracks; tracks > 0; tracks -= 64) {
            ingredients.add(Pair.of(new class_1799((class_1935)info.trackMaterial.getBlock(), Math.min(64, tracks)), info.hasRequiredTracks));
        }
        for (int pavement = info.requiredPavement; pavement > 0; pavement -= 64) {
            ingredients.add(Pair.of(pavementItem.method_46651(Math.min(64, pavement)), info.hasRequiredPavement));
        }
    }

    public static void displayChainRequirements(class_1792 chainItem, int count, boolean fulfilled) {
        if (active) {
            return;
        }
        BlueprintOverlayRenderer.prepareCustomOverlay();
        for (int chains = count; chains > 0; chains -= 64) {
            ingredients.add(Pair.of(new class_1799((class_1935)chainItem, Math.min(64, chains)), fulfilled));
        }
    }

    public static void displayClothShop(TableClothBlockEntity dce, int alreadyPurchased, ShoppingList list) {
        if (active) {
            return;
        }
        BlueprintOverlayRenderer.prepareCustomOverlay();
        noOutput = false;
        shopContext = new BlueprintOverlayShopContext(false, dce.getStockLevelForTrade(list), alreadyPurchased);
        ingredients.add(Pair.of(dce.getPaymentItem().method_46651(dce.getPaymentAmount()), !dce.getPaymentItem().method_7960() && shopContext.stockLevel() > shopContext.purchases()));
        for (BigItemStack entry : dce.requestData.encodedRequest().stacks()) {
            results.add(entry.stack.method_46651(entry.count));
        }
    }

    public static void displayShoppingList(class_746 player, Couple<InventorySummary> bakedList) {
        if (active || bakedList == null) {
            return;
        }
        BlueprintOverlayRenderer.prepareCustomOverlay();
        noOutput = false;
        shopContext = new BlueprintOverlayShopContext(true, 1, 0);
        for (BigItemStack entry : ((InventorySummary)bakedList.getSecond()).getStacksByCount()) {
            ingredients.add(Pair.of(entry.stack.method_46651(entry.count), BlueprintOverlayRenderer.canAfford(player, entry)));
        }
        for (BigItemStack entry : ((InventorySummary)bakedList.getFirst()).getStacksByCount()) {
            results.add(entry.stack.method_46651(entry.count));
        }
    }

    private static boolean canAfford(class_746 player, BigItemStack entry) {
        int itemsPresent = 0;
        class_1661 playerInventory = player.method_31548();
        for (int i = 0; i < 36; ++i) {
            class_1799 item = playerInventory.method_5438(i);
            if (item.method_7960() || !class_1799.method_31577((class_1799)item, (class_1799)entry.stack)) continue;
            itemsPresent += item.method_7947();
        }
        return itemsPresent >= entry.count;
    }

    private static void prepareCustomOverlay() {
        active = true;
        empty = false;
        noOutput = true;
        ingredients.clear();
        results.clear();
        shopContext = null;
    }

    public static void rebuild(class_310 mc, BlueprintEntity blueprintEntity, BlueprintEntity.BlueprintSection sectionAt, boolean sneak) {
        empty = sectionAt.getItems().method_5442();
        if (empty) {
            cachedRenderedFilters.clear();
            ingredients.clear();
            results.clear();
            return;
        }
        mc.field_1724.field_3944.method_52787((class_2596)new BlueprintPreviewRequestPacket(blueprintEntity.method_5628(), sectionAt.index, sneak));
    }

    public static void updatePreview(List<class_1799> available, List<class_1799> missing, class_1799 result) {
        cachedRenderedFilters.clear();
        ingredients.clear();
        results.clear();
        if (available.isEmpty() && missing.isEmpty()) {
            return;
        }
        for (class_1799 stack : available) {
            ingredients.add(Pair.of(stack, true));
        }
        if (!missing.isEmpty()) {
            for (class_1799 stack : missing) {
                ingredients.add(Pair.of(stack, false));
            }
            results.add(result);
            resultCraftable = false;
        } else if (result.method_7960()) {
            resultCraftable = false;
        } else {
            results.add(result);
            resultCraftable = true;
        }
    }

    public static void renderOverlay(class_310 mc, class_332 guiGraphics) {
        if (mc.field_1755 != null) {
            return;
        }
        if (!active || empty) {
            return;
        }
        boolean invalidShop = shopContext != null && (ingredients.isEmpty() || ingredients.getFirst().getFirst().method_7960() || shopContext.stockLevel() == 0);
        int w = 21 * ingredients.size();
        if (!noOutput) {
            w += 21 * results.size();
            w += 30;
        }
        int width = guiGraphics.method_51421();
        int x = (width - w) / 2;
        int y = guiGraphics.method_51443() - 100;
        if (shopContext != null) {
            class_8002.method_47946((class_332)guiGraphics, (int)(x - 2), (int)(y + 1), (int)(w + 4), (int)19, null);
            AllGuiTextures.TRADE_OVERLAY.render(guiGraphics, width / 2 - 48, y - 19);
            if (shopContext.purchases() > 0) {
                guiGraphics.method_51427(AllItems.SHOPPING_LIST.method_7854(), width / 2 + 20, y - 20);
                guiGraphics.method_51439(mc.field_1772, (class_2561)class_2561.method_43470((String)("x" + shopContext.purchases())), width / 2 + 20 + 16, y - 20 + 4, -1118482, true);
            }
        }
        for (Pair<class_1799, Boolean> pair : ingredients) {
            (pair.getSecond() != false ? AllGuiTextures.HOTSLOT_ACTIVE : AllGuiTextures.HOTSLOT).render(guiGraphics, x, y);
            class_1799 itemStack = pair.getFirst();
            String count = shopContext != null && !shopContext.checkout() || pair.getSecond() != false ? null : class_124.field_1065.toString() + itemStack.method_7947();
            BlueprintOverlayRenderer.drawItemStack(guiGraphics, mc, x, y, itemStack, count);
            x += 21;
        }
        if (noOutput) {
            return;
        }
        x += 5;
        if (invalidShop) {
            AllGuiTextures.HOTSLOT_ARROW_BAD.render(guiGraphics, x, y + 4);
        } else {
            AllGuiTextures.HOTSLOT_ARROW.render(guiGraphics, x, y + 4);
        }
        x += 25;
        if (results.isEmpty()) {
            AllGuiTextures.HOTSLOT.render(guiGraphics, x, y);
            guiGraphics.method_51427(class_1802.field_8077.method_7854(), x + 3, y + 3);
        } else {
            for (class_1799 result : results) {
                AllGuiTextures slot;
                AllGuiTextures allGuiTextures = slot = resultCraftable ? AllGuiTextures.HOTSLOT_SUPER_ACTIVE : AllGuiTextures.HOTSLOT;
                if (!invalidShop && shopContext != null && shopContext.stockLevel() > shopContext.purchases()) {
                    slot = AllGuiTextures.HOTSLOT_ACTIVE;
                }
                slot.render(guiGraphics, resultCraftable ? x - 1 : x, resultCraftable ? y - 1 : y);
                BlueprintOverlayRenderer.drawItemStack(guiGraphics, mc, x, y, result, null);
                x += 21;
            }
        }
        if (shopContext != null && !shopContext.checkout()) {
            int cycle = 0;
            for (boolean count : Iterate.trueAndFalse) {
                for (int i = 0; i < results.size(); ++i) {
                    class_1799 result = results.get(i);
                    List tooltipLines = result.method_7950(class_1792.class_9635.method_59528((class_1937)mc.field_1687), (class_1657)mc.field_1724, (class_1836)class_1836.class_1837.field_41070);
                    if (tooltipLines.size() <= 1) continue;
                    if (count) {
                        ++cycle;
                        continue;
                    }
                    if (mc.field_1705.method_1738() / 40 % cycle != i) continue;
                    class_1041 window = mc.method_22683();
                    guiGraphics.method_51434(mc.field_1772, tooltipLines, 0, 0);
                    guiGraphics.method_51435(mc.field_1772, tooltipLines.stream().map(class_2561::method_30937).map(class_5684::method_32662).toList(), window.method_4486(), window.method_4502(), class_8001.field_41687, null);
                }
            }
        }
    }

    public static void drawItemStack(class_332 graphics, class_310 mc, int x, int y, class_1799 itemStack, String count) {
        if (itemStack.method_7909() instanceof FilterItem) {
            int step = AnimationTickHolder.getTicks((class_1936)mc.field_1687) / 10;
            class_1799[] itemsMatchingFilter = BlueprintOverlayRenderer.getItemsMatchingFilter(itemStack);
            if (itemsMatchingFilter.length > 0) {
                itemStack = itemsMatchingFilter[step % itemsMatchingFilter.length];
            }
        }
        graphics.method_51427(itemStack, x + 3, y + 3);
        graphics.method_51432(mc.field_1772, itemStack, x + 3, y + 3, count);
    }

    private static class_1799[] getItemsMatchingFilter(class_1799 filter) {
        return cachedRenderedFilters.computeIfAbsent(filter, itemStack -> {
            class_1792 patt0$temp = itemStack.method_7909();
            if (patt0$temp instanceof FilterItem) {
                FilterItem filterItem = (FilterItem)patt0$temp;
                return filterItem.getFilterItems((class_1799)itemStack);
            }
            return new class_1799[0];
        });
    }

    static {
        cachedRenderedFilters = new IdentityHashMap<class_1799, class_1799[]>();
        ingredients = new ArrayList<Pair<class_1799, Boolean>>();
        results = new ArrayList<class_1799>();
        resultCraftable = false;
    }
}

