/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.redstone.link.controller;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.client.catnip.lang.FontHelper;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.ControlsUtil;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.infrastructure.model.LinkedControllerModel;
import com.zurrtum.create.content.redstone.link.ServerLinkBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.packet.c2s.LinkedControllerBindPacket;
import com.zurrtum.create.infrastructure.packet.c2s.LinkedControllerInputPacket;
import com.zurrtum.create.infrastructure.packet.c2s.LinkedControllerStopLecternPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_8001;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public class LinkedControllerClientHandler {
    public static Mode MODE = Mode.IDLE;
    public static int PACKET_RATE = 5;
    public static Collection<Integer> currentlyPressed = new HashSet<Integer>();
    private static class_2338 lecternPos;
    private static class_2338 selectedLocation;
    private static int packetCooldown;

    public static void toggleBindMode(class_746 player, class_2338 location) {
        if (MODE == Mode.IDLE) {
            MODE = Mode.BIND;
            selectedLocation = location;
        } else {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset(player);
        }
    }

    public static void toggle(class_746 player) {
        if (MODE == Mode.IDLE) {
            MODE = Mode.ACTIVE;
            lecternPos = null;
        } else {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset(player);
        }
    }

    public static void activateInLectern(class_2338 lecternAt) {
        if (MODE == Mode.IDLE) {
            MODE = Mode.ACTIVE;
            lecternPos = lecternAt;
        }
    }

    public static boolean deactivateInLectern(class_746 player) {
        if (MODE == Mode.ACTIVE && LinkedControllerClientHandler.inLectern()) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset(player);
            return true;
        }
        return false;
    }

    public static boolean inLectern() {
        return lecternPos != null;
    }

    protected static void onReset(class_746 player) {
        ControlsUtil.getControls().forEach(kb -> kb.method_23481(ControlsUtil.isActuallyPressed(kb)));
        packetCooldown = 0;
        selectedLocation = class_2338.field_10980;
        if (LinkedControllerClientHandler.inLectern()) {
            player.field_3944.method_52787((class_2596)new LinkedControllerStopLecternPacket(lecternPos));
        }
        lecternPos = null;
        if (!currentlyPressed.isEmpty()) {
            player.field_3944.method_52787((class_2596)new LinkedControllerInputPacket(currentlyPressed, false));
        }
        currentlyPressed.clear();
        LinkedControllerModel.resetButtons();
    }

    public static void tick(class_310 mc) {
        LinkedControllerModel.tick(mc);
        if (MODE == Mode.IDLE) {
            return;
        }
        if (packetCooldown > 0) {
            --packetCooldown;
        }
        class_746 player = mc.field_1724;
        class_638 world = mc.field_1687;
        class_1799 heldItem = player.method_6047();
        if (player.method_7325()) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset(player);
            return;
        }
        if (!(LinkedControllerClientHandler.inLectern() || heldItem.method_31574((class_1792)AllItems.LINKED_CONTROLLER) || (heldItem = player.method_6079()).method_31574((class_1792)AllItems.LINKED_CONTROLLER))) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset(player);
            return;
        }
        if (LinkedControllerClientHandler.inLectern() && AllBlocks.LECTERN_CONTROLLER.getBlockEntityOptional((class_1922)world, lecternPos).map(be -> !be.isUsedBy((class_1657)mc.field_1724)).orElse(true).booleanValue()) {
            LinkedControllerClientHandler.deactivateInLectern(player);
            return;
        }
        if (mc.field_1755 != null) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset(player);
            return;
        }
        if (class_3675.method_15987((long)mc.method_22683().method_4490(), (int)256)) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset(player);
            return;
        }
        List<class_304> controls = ControlsUtil.getControls();
        HashSet<Integer> pressedKeys = new HashSet<Integer>();
        for (int i = 0; i < controls.size(); ++i) {
            if (!ControlsUtil.isActuallyPressed(controls.get(i))) continue;
            pressedKeys.add(i);
        }
        HashSet<Integer> newKeys = new HashSet<Integer>(pressedKeys);
        Collection<Integer> releasedKeys = currentlyPressed;
        newKeys.removeAll(releasedKeys);
        releasedKeys.removeAll(pressedKeys);
        if (MODE == Mode.ACTIVE) {
            if (!releasedKeys.isEmpty()) {
                player.field_3944.method_52787((class_2596)new LinkedControllerInputPacket(releasedKeys, false, lecternPos));
                AllSoundEvents.CONTROLLER_CLICK.playAt(player.method_37908(), (class_2382)player.method_24515(), 1.0f, 0.5f, true);
            }
            if (!newKeys.isEmpty()) {
                player.field_3944.method_52787((class_2596)new LinkedControllerInputPacket(newKeys, true, lecternPos));
                packetCooldown = PACKET_RATE;
                AllSoundEvents.CONTROLLER_CLICK.playAt(player.method_37908(), (class_2382)player.method_24515(), 1.0f, 0.75f, true);
            }
            if (packetCooldown == 0 && !pressedKeys.isEmpty()) {
                player.field_3944.method_52787((class_2596)new LinkedControllerInputPacket(pressedKeys, true, lecternPos));
                packetCooldown = PACKET_RATE;
            }
        }
        if (MODE == Mode.BIND) {
            Iterator iterator;
            class_265 shape = world.method_8320(selectedLocation).method_26218((class_1922)world, selectedLocation);
            if (!shape.method_1110()) {
                Outliner.getInstance().showAABB("controller", shape.method_1107().method_996(selectedLocation)).colored(12008493).lineWidth(0.0625f);
            }
            if ((iterator = newKeys.iterator()).hasNext()) {
                Integer integer = (Integer)iterator.next();
                ServerLinkBehaviour linkBehaviour = BlockEntityBehaviour.get((class_1922)world, selectedLocation, ServerLinkBehaviour.TYPE);
                if (linkBehaviour != null) {
                    player.field_3944.method_52787((class_2596)new LinkedControllerBindPacket(integer, selectedLocation));
                    CreateLang.translate("linked_controller.key_bound", controls.get(integer).method_16007().getString()).sendStatus((class_1657)mc.field_1724);
                }
                MODE = Mode.IDLE;
            }
        }
        currentlyPressed = pressedKeys;
        controls.forEach(kb -> kb.method_23481(false));
    }

    public static void renderOverlay(class_310 mc, class_332 guiGraphics) {
        if (MODE != Mode.BIND) {
            return;
        }
        int width1 = guiGraphics.method_51421();
        int height1 = guiGraphics.method_51443();
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        poseStack.pushMatrix();
        Object[] keys = new Object[6];
        List<class_304> controls = ControlsUtil.getControls();
        for (int i = 0; i < controls.size(); ++i) {
            class_304 keyBinding = controls.get(i);
            keys[i] = keyBinding.method_16007().getString();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(CreateLang.translateDirect("linked_controller.bind_mode", new Object[0]).method_27692(class_124.field_1065));
        list.addAll(TooltipHelper.cutTextComponent((class_2561)CreateLang.translateDirect("linked_controller.press_keybind", keys), FontHelper.Palette.ALL_GRAY));
        int width = 0;
        int n = list.size();
        Objects.requireNonNull(mc.field_1772);
        int height = n * 9;
        for (class_2561 class_25612 : list) {
            width = Math.max(width, mc.field_1772.method_27525((class_5348)class_25612));
        }
        int x = width1 / 3 - width / 2;
        int n2 = height1 - height - 24;
        guiGraphics.method_51435(mc.field_1772, list.stream().map(class_2561::method_30937).map(class_5684::method_32662).collect(Collectors.toList()), x, n2, class_8001.field_41687, null);
        poseStack.popMatrix();
    }

    static {
        selectedLocation = class_2338.field_10980;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Mode {
        IDLE,
        ACTIVE,
        BIND;

    }
}

