/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.task;

import com.zurrtum.create.client.flywheel.api.task.Plan;
import com.zurrtum.create.client.flywheel.api.task.TaskExecutor;
import com.zurrtum.create.client.flywheel.lib.task.SimplyComposedPlan;
import com.zurrtum.create.client.flywheel.lib.task.functional.BooleanSupplierWithContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public record ConditionalPlan<C>(BooleanSupplierWithContext<C> condition, Plan<C> onTrue) implements SimplyComposedPlan<C>
{
    public static <C> Builder<C> on(BooleanSupplierWithContext<C> condition) {
        return new Builder<C>(condition);
    }

    public static <C> Builder<C> on(BooleanSupplierWithContext.Ignored<C> condition) {
        return new Builder<C>(condition);
    }

    @Override
    public void execute(TaskExecutor taskExecutor, C context, Runnable onCompletion) {
        if (this.condition.getAsBoolean(context)) {
            this.onTrue.execute(taskExecutor, context, onCompletion);
        } else {
            onCompletion.run();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Builder<C> {
        private final BooleanSupplierWithContext<C> condition;

        public Builder(BooleanSupplierWithContext<C> condition) {
            this.condition = condition;
        }

        public ConditionalPlan<C> then(Plan<C> onTrue) {
            return new ConditionalPlan<C>(this.condition, onTrue);
        }
    }
}

