/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.potatoCannon;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.AllEnchantments;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.equipment.potatoCannon.PotatoCannonProjectileType;
import com.zurrtum.create.api.equipment.potatoCannon.PotatoProjectileRenderMode;
import com.zurrtum.create.api.registry.CreateRegistryKeys;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.potatoCannon.AllPotatoProjectileRenderModes;
import com.zurrtum.create.content.equipment.potatoCannon.AllPotatoProjectileTypes;
import com.zurrtum.create.infrastructure.packet.s2c.NbtSpawnPacket;
import com.zurrtum.create.infrastructure.particle.AirParticleData;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1528;
import net.minecraft.class_1657;
import net.minecraft.class_1668;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2668;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8942;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotatoProjectileEntity
extends class_1668 {
    protected PotatoCannonProjectileType type;
    protected class_1799 stack = class_1799.field_8037;
    protected class_1297 stuckEntity;
    protected class_243 stuckOffset;
    protected PotatoProjectileRenderMode stuckRenderer;
    protected double stuckFallSpeed;
    protected float additionalDamageMult = 1.0f;
    protected float additionalKnockback = 0.0f;
    protected float recoveryChance = 0.0f;

    public PotatoProjectileEntity(class_1299<? extends class_1668> type, class_1937 level) {
        super(type, level);
    }

    public void setItem(class_1799 stack) {
        this.stack = stack;
        class_5455 registryManager = this.method_56673();
        this.type = (PotatoCannonProjectileType)PotatoCannonProjectileType.getTypeForItem(registryManager, stack.method_7909()).orElseGet(() -> registryManager.method_30530(CreateRegistryKeys.POTATO_PROJECTILE_TYPE).method_46747(AllPotatoProjectileTypes.FALLBACK)).comp_349();
    }

    public void setEnchantmentEffectsFromCannon(class_1799 cannon) {
        class_2378 enchantmentRegistry = this.method_56673().method_30530(class_7924.field_41265);
        int recovery = cannon.method_58657().method_57536((class_6880)enchantmentRegistry.method_46747(AllEnchantments.POTATO_RECOVERY));
        if (recovery > 0) {
            this.recoveryChance = 0.125f + (float)recovery * 0.125f;
        }
    }

    public class_1799 getItem() {
        return this.stack;
    }

    @Nullable
    public PotatoCannonProjectileType getProjectileType() {
        return this.type;
    }

    public void method_5749(class_11368 view) {
        this.setItem(view.method_71426("Item", class_1799.field_24671).orElse(class_1799.field_8037));
        this.additionalDamageMult = view.method_71423("AdditionalDamage", 0.0f);
        this.additionalKnockback = view.method_71423("AdditionalKnockback", 0.0f);
        this.recoveryChance = view.method_71423("Recovery", 0.0f);
        super.method_5749(view);
    }

    public void method_5652(class_11372 view) {
        if (!this.stack.method_7960()) {
            view.method_71468("Item", class_1799.field_24671, (Object)this.stack);
        }
        view.method_71464("AdditionalDamage", this.additionalDamageMult);
        view.method_71464("AdditionalKnockback", this.additionalKnockback);
        view.method_71464("Recovery", this.recoveryChance);
        super.method_5652(view);
    }

    @Nullable
    public class_1297 getStuckEntity() {
        if (this.stuckEntity == null) {
            return null;
        }
        if (!this.stuckEntity.method_5805()) {
            return null;
        }
        return this.stuckEntity;
    }

    public void setStuckEntity(class_1297 stuckEntity) {
        this.stuckEntity = stuckEntity;
        this.stuckOffset = this.method_19538().method_1020(stuckEntity.method_19538());
        this.stuckRenderer = new AllPotatoProjectileRenderModes.StuckToEntity(this.stuckOffset);
        this.stuckFallSpeed = 0.0;
        this.method_18799(class_243.field_1353);
    }

    public PotatoProjectileRenderMode getRenderMode() {
        if (this.getStuckEntity() != null) {
            return this.stuckRenderer;
        }
        return this.type.renderMode();
    }

    public void method_5773() {
        class_1297 stuckEntity = this.getStuckEntity();
        if (stuckEntity != null) {
            if (this.method_23318() < stuckEntity.method_23318() - 0.1) {
                this.pop(this.method_19538());
                class_1937 class_19372 = this.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)class_19372;
                    this.method_5768(serverWorld);
                }
            } else {
                this.stuckFallSpeed += 0.007 * (double)this.type.gravityMultiplier();
                this.stuckOffset = this.stuckOffset.method_1031(0.0, -this.stuckFallSpeed, 0.0);
                class_243 pos = stuckEntity.method_19538().method_1019(this.stuckOffset);
                this.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
            }
        } else {
            this.method_18799(this.method_18798().method_1031(0.0, -0.05 * (double)this.type.gravityMultiplier(), 0.0).method_1021((double)this.type.drag()));
        }
        super.method_5773();
    }

    protected float method_7466() {
        return 1.0f;
    }

    protected class_2394 method_7467() {
        return new AirParticleData(1.0f, 10.0f);
    }

    protected boolean method_7468() {
        return false;
    }

    public boolean method_5863() {
        return true;
    }

    protected void method_7454(class_3966 ray) {
        class_243 appliedMotion;
        class_1528 wither;
        super.method_7454(ray);
        if (this.getStuckEntity() != null) {
            return;
        }
        class_243 hit = ray.method_17784();
        class_1297 target = ray.method_17782();
        float damage = (float)this.type.damage() * this.additionalDamageMult;
        float knockback = this.type.knockback() + this.additionalKnockback;
        class_1297 owner = this.method_24921();
        if (!target.method_5805()) {
            return;
        }
        if (owner instanceof class_1309) {
            class_1309 entity = (class_1309)owner;
            entity.method_6114(target);
        }
        if (target instanceof PotatoProjectileEntity) {
            PotatoProjectileEntity ppe = (PotatoProjectileEntity)target;
            if (this.field_6012 < 10 && target.field_6012 < 10) {
                return;
            }
            if (ppe.getProjectileType() != this.getProjectileType()) {
                class_1297 class_12972;
                class_3222 p;
                if (owner instanceof class_3222) {
                    p = (class_3222)owner;
                    AllAdvancements.POTATO_CANNON_COLLIDE.trigger(p);
                }
                if ((class_12972 = ppe.method_24921()) instanceof class_3222) {
                    p = (class_3222)class_12972;
                    AllAdvancements.POTATO_CANNON_COLLIDE.trigger(p);
                }
            }
        }
        this.pop(hit);
        if (target instanceof class_1528 && (wither = (class_1528)target).method_6872()) {
            return;
        }
        if (this.type.preEntityHit(this.stack, ray)) {
            return;
        }
        boolean targetIsEnderman = target.method_5864() == class_1299.field_6091;
        int k = target.method_20802();
        if (this.method_5809() && !targetIsEnderman) {
            target.method_5639(5.0f);
        }
        class_1937 world = this.method_37908();
        boolean onServer = !world.field_9236;
        class_1282 damageSource = this.causePotatoDamage();
        if (onServer && !target.method_64397((class_3218)world, damageSource, damage)) {
            target.method_20803(k);
            this.method_5768((class_3218)world);
            return;
        }
        if (targetIsEnderman) {
            return;
        }
        if (!this.type.onEntityHit(this.stack, ray) && onServer) {
            if (this.field_5974.method_43058() <= (double)this.recoveryChance) {
                this.recoverItem();
            } else {
                this.method_5775((class_3218)world, this.type.dropStack());
            }
        }
        if (!(target instanceof class_1309)) {
            PotatoProjectileEntity.playHitSound(world, this.method_19538());
            if (onServer) {
                this.method_5768((class_3218)world);
            }
            return;
        }
        class_1309 livingentity = (class_1309)target;
        if (this.type.reloadTicks() < 10) {
            livingentity.field_6008 = this.type.reloadTicks() + 10;
        }
        if (onServer && knockback > 0.0f && (appliedMotion = this.method_18798().method_18805(1.0, 0.0, 1.0).method_1029()).method_1027() > 0.0) {
            livingentity.method_6005((double)knockback * 0.6, -appliedMotion.field_1352, -appliedMotion.field_1350);
        }
        if (onServer && owner instanceof class_1309) {
            class_1890.method_60107((class_3218)((class_3218)world), (class_1297)livingentity, (class_1282)damageSource);
        }
        if (livingentity != owner && livingentity instanceof class_1657 && owner instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)owner;
            if (!this.method_5701()) {
                serverPlayer.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25651, 0.0f));
            }
        }
        if (onServer && owner instanceof class_3222) {
            class_3222 serverplayerentity = (class_3222)owner;
            if (!target.method_5805() && target.method_5864().method_5891() == class_1311.field_6302 || target instanceof class_1657 && target != owner) {
                AllAdvancements.POTATO_CANNON.trigger(serverplayerentity);
            }
        }
        if (this.type.sticky() && target.method_5805()) {
            this.setStuckEntity(target);
        } else if (onServer) {
            this.method_5768((class_3218)world);
        }
    }

    private void recoverItem() {
        class_1937 class_19372;
        if (!this.stack.method_7960() && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            this.method_5775(serverWorld, this.stack.method_46651(1));
        }
    }

    public static void playHitSound(class_1937 world, class_243 location) {
        AllSoundEvents.POTATO_HIT.playOnServer(world, (class_2382)class_2338.method_49638((class_2374)location));
    }

    public static void playLaunchSound(class_1937 world, class_243 location, float pitch) {
        AllSoundEvents.FWOOMP.playAt(world, location, 1.0f, pitch, true);
    }

    protected void method_24920(class_3965 ray) {
        class_243 hit = ray.method_17784();
        this.pop(hit);
        class_1937 world = this.method_37908();
        if (!this.type.onBlockHit((class_1936)world, this.stack, ray) && !world.field_9236) {
            if (this.field_5974.method_43058() <= (double)this.recoveryChance) {
                this.recoverItem();
            } else {
                this.method_5775((class_3218)world, this.getProjectileType().dropStack());
            }
        }
        super.method_24920(ray);
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            this.method_5768(serverWorld);
        }
    }

    public boolean method_64397(class_3218 world, @NotNull class_1282 source, float amt) {
        if (source.method_48789(class_8103.field_42246)) {
            return false;
        }
        if (this.method_64421(source)) {
            return false;
        }
        this.pop(this.method_19538());
        this.method_5768(world);
        return true;
    }

    private void pop(class_243 hit) {
        if (!this.stack.method_7960()) {
            for (int i = 0; i < 7; ++i) {
                class_243 m = VecHelper.offsetRandomly(class_243.field_1353, this.field_5974, 0.25f);
                this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, this.stack), hit.field_1352, hit.field_1351, hit.field_1350, m.field_1352, m.field_1351, m.field_1350);
            }
        }
        if (!this.method_37908().field_9236) {
            PotatoProjectileEntity.playHitSound(this.method_37908(), this.method_19538());
        }
    }

    private class_1282 causePotatoDamage() {
        return AllDamageSources.get(this.method_37908()).potatoCannon((class_1297)this, this.method_24921());
    }

    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        try (class_8942.class_11340 logging = new class_8942.class_11340(this.method_71370(), Create.LOGGER);){
            class_11362 view = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)this.method_56673());
            this.method_5652((class_11372)view);
            NbtSpawnPacket nbtSpawnPacket = new NbtSpawnPacket((class_1297)this, entityTrackerEntry, view.method_71475());
            return nbtSpawnPacket;
        }
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        class_2487 nbt = ((NbtSpawnPacket)packet).getNbt();
        if (nbt == null) {
            return;
        }
        try (class_8942.class_11340 logging = new class_8942.class_11340(this.method_71370(), Create.LOGGER);){
            this.method_5749(class_11352.method_71417((class_8942)logging, (class_7225.class_7874)this.method_56673(), (class_2487)nbt));
        }
    }
}

