/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.tank.storage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllMountedStorageTypes;
import com.zurrtum.create.api.contraption.storage.SyncedMountedStorage;
import com.zurrtum.create.api.contraption.storage.fluid.MountedFluidStorageType;
import com.zurrtum.create.api.contraption.storage.fluid.WrapperMountedFluidStorage;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import com.zurrtum.create.foundation.fluid.FluidTank;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;

public class FluidTankMountedStorage
extends WrapperMountedFluidStorage<Handler>
implements SyncedMountedStorage {
    public static final MapCodec<FluidTankMountedStorage> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)class_5699.field_33441.fieldOf("capacity").forGetter(FluidTankMountedStorage::getCapacity), (App)FluidStack.OPTIONAL_CODEC.fieldOf("fluid").forGetter(FluidTankMountedStorage::getFluid)).apply((Applicative)i, FluidTankMountedStorage::new));
    private boolean dirty;

    protected FluidTankMountedStorage(MountedFluidStorageType<?> type, int capacity, FluidStack stack) {
        super(type);
        this.wrapped = new Handler(capacity, stack);
    }

    protected FluidTankMountedStorage(int capacity, FluidStack stack) {
        this(AllMountedStorageTypes.FLUID_TANK, capacity, stack);
    }

    @Override
    public void unmount(class_1937 level, class_2680 state, class_2338 pos, @Nullable class_2586 be) {
        FluidTankBlockEntity tank;
        if (be instanceof FluidTankBlockEntity && (tank = (FluidTankBlockEntity)be).isController()) {
            FluidTank inventory = tank.getTankInventory();
            inventory.setFluid(((Handler)this.wrapped).getFluid());
        }
    }

    public FluidStack getFluid() {
        return ((Handler)this.wrapped).getFluid();
    }

    public int getCapacity() {
        return ((Handler)this.wrapped).getMaxAmountPerStack();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markClean() {
        this.dirty = false;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public void afterSync(Contraption contraption, class_2338 localPos) {
        class_2586 be = AllClientHandle.INSTANCE.getBlockEntityClientSide(contraption, localPos);
        if (!(be instanceof FluidTankBlockEntity)) {
            return;
        }
        FluidTankBlockEntity tank = (FluidTankBlockEntity)be;
        FluidTank inv = tank.getTankInventory();
        inv.setFluid(this.getFluid());
        float fillLevel = (float)inv.getFluid().getAmount() / (float)inv.getMaxAmountPerStack();
        if (tank.getFluidLevel() == null) {
            tank.setFluidLevel(LerpedFloat.linear().startWithValue(fillLevel));
        }
        tank.getFluidLevel().chase(fillLevel, 0.5, LerpedFloat.Chaser.EXP);
    }

    public static FluidTankMountedStorage fromTank(FluidTankBlockEntity tank) {
        FluidTank inventory = tank.getTankInventory();
        return new FluidTankMountedStorage(inventory.getMaxAmountPerStack(), inventory.getFluid().copy());
    }

    public final class Handler
    extends FluidTank {
        public Handler(int capacity, FluidStack stack) {
            super(capacity);
            this.setFluid(stack);
        }

        @Override
        public void markDirty() {
            FluidTankMountedStorage.this.dirty = true;
        }
    }
}

