/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.base;

import com.zurrtum.create.content.kinetics.KineticNetwork;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public abstract class GeneratingKineticBlockEntity
extends KineticBlockEntity {
    public boolean reActivateSource;

    public GeneratingKineticBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    protected void notifyStressCapacityChange(float capacity) {
        this.getOrCreateNetwork().updateCapacityFor(this, capacity);
    }

    @Override
    public void removeSource() {
        if (this.hasSource() && this.isSource()) {
            this.reActivateSource = true;
        }
        super.removeSource();
    }

    @Override
    public void setSource(class_2338 source) {
        super.setSource(source);
        class_2586 blockEntity = this.field_11863.method_8321(source);
        if (!(blockEntity instanceof KineticBlockEntity)) {
            return;
        }
        KineticBlockEntity sourceBE = (KineticBlockEntity)blockEntity;
        if (this.reActivateSource && Math.abs(sourceBE.getSpeed()) >= Math.abs(this.getGeneratedSpeed())) {
            this.reActivateSource = false;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.reActivateSource) {
            this.updateGeneratedRotation();
            this.reActivateSource = false;
        }
    }

    public void updateGeneratedRotation() {
        float speed = this.getGeneratedSpeed();
        float prevSpeed = this.speed;
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        if (prevSpeed != speed) {
            IRotate.SpeedLevel levelafter;
            IRotate.SpeedLevel levelBefore;
            if (!this.hasSource() && (levelBefore = IRotate.SpeedLevel.of(this.speed)) != (levelafter = IRotate.SpeedLevel.of(speed))) {
                this.effects.queueRotationIndicators();
            }
            this.applyNewSpeed(prevSpeed, speed);
        }
        if (this.hasNetwork() && speed != 0.0f) {
            KineticNetwork network = this.getOrCreateNetwork();
            this.notifyStressCapacityChange(this.calculateAddedStressCapacity());
            this.getOrCreateNetwork().updateStressFor(this, this.calculateStressApplied());
            network.updateStress();
        }
        this.onSpeedChanged(prevSpeed);
        this.sendData();
    }

    public void applyNewSpeed(float prevSpeed, float speed) {
        if (speed == 0.0f) {
            if (this.hasSource()) {
                this.notifyStressCapacityChange(0.0f);
                this.getOrCreateNetwork().updateStressFor(this, this.calculateStressApplied());
                return;
            }
            this.detachKinetics();
            this.setSpeed(0.0f);
            this.setNetwork(null);
            return;
        }
        if (prevSpeed == 0.0f) {
            this.setSpeed(speed);
            this.setNetwork(this.createNetworkId());
            this.attachKinetics();
            return;
        }
        if (this.hasSource()) {
            if (Math.abs(prevSpeed) >= Math.abs(speed)) {
                if (Math.signum(prevSpeed) != Math.signum(speed)) {
                    this.field_11863.method_22352(this.field_11867, true);
                }
                return;
            }
            this.detachKinetics();
            this.setSpeed(speed);
            this.source = null;
            this.setNetwork(this.createNetworkId());
            this.attachKinetics();
            return;
        }
        this.detachKinetics();
        this.setSpeed(speed);
        this.attachKinetics();
    }

    public Long createNetworkId() {
        return this.field_11867.method_10063();
    }
}

