/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.crusher;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.zurrtum.create.content.kinetics.crusher.CrushingWheelBlockEntity;
import com.zurrtum.create.content.kinetics.crusher.CrushingWheelControllerBlock;
import com.zurrtum.create.foundation.block.IBE;
import net.minecraft.class_10774;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class CrushingWheelBlock
extends RotatedPillarKineticBlock
implements IBE<CrushingWheelBlockEntity> {
    public CrushingWheelBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    @Override
    public class_2350.class_2351 getRotationAxis(class_2680 state) {
        return (class_2350.class_2351)state.method_11654((class_2769)AXIS);
    }

    public class_265 method_9549(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return AllShapes.CRUSHING_WHEEL_COLLISION_SHAPE;
    }

    public void method_66388(class_2680 state, class_3218 worldIn, class_2338 pos, boolean isMoving) {
        for (class_2350 d : Iterate.directions) {
            if (d.method_10166() == state.method_11654((class_2769)AXIS) || !worldIn.method_8320(pos.method_10093(d)).method_27852((class_2248)AllBlocks.CRUSHING_WHEEL_CONTROLLER)) continue;
            worldIn.method_8650(pos.method_10093(d), isMoving);
        }
        super.method_66388(state, worldIn, pos, isMoving);
    }

    public void updateControllers(class_2680 state, class_1937 world, class_2338 pos, class_2350 side) {
        if (side.method_10166() == state.method_11654((class_2769)AXIS)) {
            return;
        }
        if (world == null) {
            return;
        }
        class_2338 controllerPos = pos.method_10093(side);
        class_2338 otherWheelPos = pos.method_10079(side, 2);
        boolean controllerExists = world.method_8320(controllerPos).method_27852((class_2248)AllBlocks.CRUSHING_WHEEL_CONTROLLER);
        boolean controllerIsValid = controllerExists && (Boolean)world.method_8320(controllerPos).method_11654((class_2769)CrushingWheelControllerBlock.VALID) != false;
        class_2350 controllerOldDirection = controllerExists ? (class_2350)world.method_8320(controllerPos).method_11654((class_2769)CrushingWheelControllerBlock.field_10927) : null;
        boolean controllerShouldExist = false;
        boolean controllerShouldBeValid = false;
        class_2350 controllerNewDirection = class_2350.field_11033;
        class_2680 otherState = world.method_8320(otherWheelPos);
        if (otherState.method_27852((class_2248)AllBlocks.CRUSHING_WHEEL)) {
            controllerShouldExist = true;
            CrushingWheelBlockEntity be = (CrushingWheelBlockEntity)this.getBlockEntity((class_1922)world, pos);
            CrushingWheelBlockEntity otherBE = (CrushingWheelBlockEntity)this.getBlockEntity((class_1922)world, otherWheelPos);
            if (be != null && otherBE != null && be.getSpeed() > 0.0f != otherBE.getSpeed() > 0.0f && be.getSpeed() != 0.0f && otherBE.getSpeed() != 0.0f) {
                class_2350.class_2351 wheelAxis = (class_2350.class_2351)state.method_11654((class_2769)AXIS);
                class_2350.class_2351 sideAxis = side.method_10166();
                int controllerADO = Math.round(Math.signum(be.getSpeed())) * side.method_10171().method_10181();
                class_243 controllerDirVec = new class_243(wheelAxis == class_2350.class_2351.field_11048 ? 1.0 : 0.0, wheelAxis == class_2350.class_2351.field_11052 ? 1.0 : 0.0, wheelAxis == class_2350.class_2351.field_11051 ? 1.0 : 0.0).method_1036(new class_243(sideAxis == class_2350.class_2351.field_11048 ? 1.0 : 0.0, sideAxis == class_2350.class_2351.field_11052 ? 1.0 : 0.0, sideAxis == class_2350.class_2351.field_11051 ? 1.0 : 0.0));
                controllerNewDirection = class_2350.method_10142((double)(controllerDirVec.field_1352 * (double)controllerADO), (double)(controllerDirVec.field_1351 * (double)controllerADO), (double)(controllerDirVec.field_1350 * (double)controllerADO));
                controllerShouldBeValid = true;
            }
            if (otherState.method_11654((class_2769)AXIS) != state.method_11654((class_2769)AXIS)) {
                controllerShouldExist = false;
            }
        }
        if (!controllerShouldExist) {
            if (controllerExists) {
                world.method_8501(controllerPos, class_2246.field_10124.method_9564());
            }
            return;
        }
        if (!controllerExists) {
            if (!world.method_8320(controllerPos).method_45474()) {
                return;
            }
            world.method_8501(controllerPos, (class_2680)((class_2680)AllBlocks.CRUSHING_WHEEL_CONTROLLER.method_9564().method_11657((class_2769)CrushingWheelControllerBlock.VALID, (Comparable)Boolean.valueOf(controllerShouldBeValid))).method_11657((class_2769)CrushingWheelControllerBlock.field_10927, (Comparable)controllerNewDirection));
        } else if (controllerIsValid != controllerShouldBeValid || controllerOldDirection != controllerNewDirection) {
            world.method_8501(controllerPos, (class_2680)((class_2680)world.method_8320(controllerPos).method_11657((class_2769)CrushingWheelControllerBlock.VALID, (Comparable)Boolean.valueOf(controllerShouldBeValid))).method_11657((class_2769)CrushingWheelControllerBlock.field_10927, (Comparable)controllerNewDirection));
        }
        AllBlocks.CRUSHING_WHEEL_CONTROLLER.updateSpeed(world.method_8320(controllerPos), (class_4538)world, controllerPos);
    }

    public void method_9548(class_2680 state, class_1937 worldIn, class_2338 pos, class_1297 entityIn, class_10774 handler) {
        if (entityIn.method_23318() < (double)((float)pos.method_10264() + 1.25f) || !entityIn.method_24828()) {
            return;
        }
        float speed = this.getBlockEntityOptional((class_1922)worldIn, pos).map(KineticBlockEntity::getSpeed).orElse(Float.valueOf(0.0f)).floatValue();
        double x = 0.0;
        double z = 0.0;
        if (state.method_11654((class_2769)AXIS) == class_2350.class_2351.field_11048) {
            z = speed / 20.0f;
            x += ((double)((float)pos.method_10263() + 0.5f) - entityIn.method_23317()) * (double)0.1f;
        }
        if (state.method_11654((class_2769)AXIS) == class_2350.class_2351.field_11051) {
            x = speed / -20.0f;
            z += ((double)((float)pos.method_10260() + 0.5f) - entityIn.method_23321()) * (double)0.1f;
        }
        entityIn.method_18799(entityIn.method_18798().method_1031(x, 0.0, z));
    }

    public boolean method_9558(class_2680 state, class_4538 worldIn, class_2338 pos) {
        for (class_2350 direction : Iterate.directions) {
            class_2338 neighbourPos = pos.method_10093(direction);
            class_2680 neighbourState = worldIn.method_8320(neighbourPos);
            class_2350.class_2351 stateAxis = (class_2350.class_2351)state.method_11654((class_2769)AXIS);
            if (neighbourState.method_27852((class_2248)AllBlocks.CRUSHING_WHEEL_CONTROLLER) && direction.method_10166() != stateAxis) {
                return false;
            }
            if (!neighbourState.method_27852((class_2248)AllBlocks.CRUSHING_WHEEL) || neighbourState.method_11654((class_2769)AXIS) == stateAxis && stateAxis == direction.method_10166()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return face.method_10166() == state.method_11654((class_2769)AXIS);
    }

    @Override
    public float getParticleTargetRadius() {
        return 1.125f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 1.0f;
    }

    @Override
    public Class<CrushingWheelBlockEntity> getBlockEntityClass() {
        return CrushingWheelBlockEntity.class;
    }

    @Override
    public class_2591<? extends CrushingWheelBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.CRUSHING_WHEEL;
    }
}

