/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity.behaviour.fluid;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.fluids.SidedFluidInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2350;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public class SmartFluidTankBehaviour
extends BlockEntityBehaviour<SmartBlockEntity> {
    public static final BehaviourType<SmartFluidTankBehaviour> TYPE = new BehaviourType();
    public static final BehaviourType<SmartFluidTankBehaviour> INPUT = new BehaviourType("Input");
    public static final BehaviourType<SmartFluidTankBehaviour> OUTPUT = new BehaviourType("Output");
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    protected final TankSegment[] tanks;
    protected SidedFluidInventory capability;
    protected boolean extractionAllowed = true;
    protected boolean insertionAllowed = true;
    protected Runnable fluidUpdateCallback;
    private final BehaviourType<SmartFluidTankBehaviour> behaviourType;

    public static SmartFluidTankBehaviour single(SmartBlockEntity be, int capacity) {
        return new SmartFluidTankBehaviour(TYPE, be, 1, capacity, false);
    }

    public static SmartFluidTankBehaviour single(SmartBlockEntity be, int capacity, TriFunction<SmartFluidTankBehaviour, Boolean, Optional<Integer>, InternalFluidHandler> factory) {
        return new SmartFluidTankBehaviour(TYPE, be, 1, capacity, false, factory);
    }

    public SmartFluidTankBehaviour(BehaviourType<SmartFluidTankBehaviour> type, SmartBlockEntity be, int tanks, int tankCapacity, boolean enforceVariety, TriFunction<SmartFluidTankBehaviour, Boolean, Optional<Integer>, InternalFluidHandler> factory) {
        super(be);
        this.behaviourType = type;
        this.tanks = new TankSegment[tanks];
        Optional<Integer> capacity = Optional.of(tankCapacity);
        for (int i = 0; i < tanks; ++i) {
            this.tanks[i] = new TankSegment(capacity);
        }
        this.capability = (SidedFluidInventory)factory.apply((Object)this, (Object)enforceVariety, capacity);
        this.fluidUpdateCallback = () -> {};
    }

    public SmartFluidTankBehaviour(BehaviourType<SmartFluidTankBehaviour> type, SmartBlockEntity be, int tanks, int tankCapacity, boolean enforceVariety) {
        this(type, be, tanks, tankCapacity, enforceVariety, (TriFunction<SmartFluidTankBehaviour, Boolean, Optional<Integer>, InternalFluidHandler>)((TriFunction)InternalFluidHandler::new));
    }

    public SmartFluidTankBehaviour whenFluidUpdates(Runnable fluidUpdateCallback) {
        this.fluidUpdateCallback = fluidUpdateCallback;
        return this;
    }

    public SmartFluidTankBehaviour allowInsertion() {
        this.insertionAllowed = true;
        return this;
    }

    public SmartFluidTankBehaviour allowExtraction() {
        this.extractionAllowed = true;
        return this;
    }

    public SmartFluidTankBehaviour forbidInsertion() {
        this.insertionAllowed = false;
        return this;
    }

    public SmartFluidTankBehaviour forbidExtraction() {
        this.extractionAllowed = false;
        return this;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.getWorld().field_9236) {
            return;
        }
        this.forEach(ts -> {
            ts.fluidLevel.forceNextSync();
            ts.markDirty();
        });
    }

    @Override
    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.updateFluids();
            }
        }
        this.forEach(be -> {
            LerpedFloat fluidLevel = be.getFluidLevel();
            if (fluidLevel != null) {
                fluidLevel.tickChaser();
            }
        });
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.updateFluids();
    }

    public void sendDataLazily() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        this.updateFluids();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    protected void updateFluids() {
        this.fluidUpdateCallback.run();
        this.blockEntity.sendData();
        this.blockEntity.method_5431();
    }

    public TankSegment getPrimaryHandler() {
        return this.getPrimaryTank();
    }

    public TankSegment getPrimaryTank() {
        return this.tanks[0];
    }

    public TankSegment[] getTanks() {
        return this.tanks;
    }

    public boolean isEmpty() {
        for (TankSegment tankSegment : this.tanks) {
            if (tankSegment.getFluid().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void forEach(Consumer<TankSegment> action) {
        for (TankSegment tankSegment : this.tanks) {
            action.accept(tankSegment);
        }
    }

    public SidedFluidInventory getCapability() {
        return this.capability;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        class_11372.class_11374 list = view.method_71476(this.getType().getName() + "Tanks");
        this.forEach(ts -> ts.write(list.method_71480()));
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        int i = 0;
        int size = this.tanks.length;
        for (class_11368 item : view.method_71438(this.getType().getName() + "Tanks")) {
            if (i >= size) break;
            this.tanks[i].read(item, clientPacket);
            ++i;
        }
    }

    @Override
    public BehaviourType<?> getType() {
        return this.behaviourType;
    }

    public class TankSegment
    implements FluidInventory {
        protected LerpedFloat fluidLevel = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.25, LerpedFloat.Chaser.EXP);
        protected FluidStack renderedFluid = FluidStack.EMPTY;
        protected FluidStack fluid = FluidStack.EMPTY;
        protected Optional<Integer> max;
        protected int capacity;

        public TankSegment(Optional<Integer> max) {
            this.max = max;
            this.capacity = max.get();
        }

        @Override
        public FluidStack onExtract(FluidStack stack) {
            return this.removeMaxSize(stack, this.max);
        }

        @Override
        public int getMaxAmountPerStack() {
            return this.capacity;
        }

        @Override
        public int size() {
            return 1;
        }

        public FluidStack getFluid() {
            return this.fluid;
        }

        public void setFluid(FluidStack fluid) {
            if (fluid != FluidStack.EMPTY) {
                this.setMaxSize(fluid, this.max);
            }
            this.fluid = fluid;
        }

        @Override
        public FluidStack getStack(int slot) {
            if (slot != 0) {
                return FluidStack.EMPTY;
            }
            return this.fluid;
        }

        @Override
        public void setStack(int slot, FluidStack stack) {
            if (slot == 0) {
                this.setFluid(stack);
            }
        }

        @Override
        public void markDirty() {
            if (!SmartFluidTankBehaviour.this.blockEntity.method_11002()) {
                return;
            }
            this.fluidLevel.chase((float)this.fluid.getAmount() / (float)this.capacity, 0.25, LerpedFloat.Chaser.EXP);
            if (!SmartFluidTankBehaviour.this.getWorld().field_9236) {
                SmartFluidTankBehaviour.this.sendDataLazily();
            }
            if (SmartFluidTankBehaviour.this.blockEntity.isVirtual() && !this.fluid.isEmpty()) {
                this.renderedFluid = this.fluid;
            }
        }

        public FluidStack getRenderedFluid() {
            return this.renderedFluid;
        }

        public LerpedFloat getFluidLevel() {
            return this.fluidLevel;
        }

        public float getTotalUnits(float partialTicks) {
            return this.fluidLevel.getValue(partialTicks) * (float)this.capacity;
        }

        public void write(class_11372 view) {
            view.method_71468("TankContent", FluidStack.OPTIONAL_CODEC, (Object)this.fluid);
            this.fluidLevel.write(view);
        }

        public void read(class_11368 view, boolean clientPacket) {
            this.fluid = view.method_71426("TankContent", FluidStack.OPTIONAL_CODEC).orElse(FluidStack.EMPTY);
            this.fluidLevel.read(view, clientPacket);
            if (!this.fluid.isEmpty()) {
                this.renderedFluid = this.fluid;
            }
        }

        public boolean isEmpty(float partialTicks) {
            if (this.getRenderedFluid().isEmpty()) {
                return true;
            }
            return this.getTotalUnits(partialTicks) < 1.0f;
        }
    }

    public static class InternalFluidHandler
    implements SidedFluidInventory {
        private final boolean enforceVariety;
        private final int[] slots;
        private final SmartFluidTankBehaviour behaviour;
        private final TankSegment[] tanks;
        private final Optional<Integer> max;
        private final int capacity;

        public InternalFluidHandler(SmartFluidTankBehaviour behaviour, boolean enforceVariety, Optional<Integer> max) {
            this.behaviour = behaviour;
            this.tanks = behaviour.tanks;
            this.enforceVariety = enforceVariety;
            this.slots = SlotRangeCache.get(this.tanks.length);
            this.max = max;
            this.capacity = max.get();
        }

        @Override
        public FluidStack onExtract(FluidStack stack) {
            return this.removeMaxSize(stack, this.max);
        }

        @Override
        public int getMaxAmountPerStack() {
            return this.capacity;
        }

        @Override
        public int[] getAvailableSlots(@Nullable class_2350 side) {
            return this.slots;
        }

        @Override
        public boolean canInsert(int slot, FluidStack stack, @Nullable class_2350 dir) {
            if (!this.behaviour.insertionAllowed) {
                return false;
            }
            if (this.enforceVariety) {
                FluidStack fluid = this.tanks[slot].getFluid();
                if (fluid.isEmpty()) {
                    int i;
                    for (i = 0; i < slot; ++i) {
                        fluid = this.tanks[i].getFluid();
                        if (fluid.isEmpty() || !this.matches(fluid, stack)) continue;
                        return false;
                    }
                    int size = this.tanks.length;
                    for (i = slot + 1; i < size; ++i) {
                        fluid = this.tanks[i].getFluid();
                        if (fluid.isEmpty() || !this.matches(fluid, stack)) continue;
                        return false;
                    }
                } else {
                    return this.matches(fluid, stack);
                }
            }
            return true;
        }

        @Override
        public boolean canExtract(int slot, FluidStack stack, class_2350 dir) {
            return this.behaviour.extractionAllowed;
        }

        @Override
        public int size() {
            return this.tanks.length;
        }

        @Override
        public FluidStack getStack(int slot) {
            if (slot >= this.tanks.length) {
                return FluidStack.EMPTY;
            }
            return this.tanks[slot].getFluid();
        }

        @Override
        public void setStack(int slot, FluidStack stack) {
            if (slot >= this.tanks.length) {
                return;
            }
            TankSegment tank = this.tanks[slot];
            tank.setFluid(stack);
        }

        @Override
        public void markDirty() {
            for (TankSegment tank : this.tanks) {
                tank.markDirty();
            }
        }
    }
}

