/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.fluids;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllFluids;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public final class FluidInteractionRegistry {
    public static final Map<class_3611, List<InteractionInformation>> INTERACTIONS = new HashMap<class_3611, List<InteractionInformation>>();

    public static synchronized void addInteraction(class_3611 source, InteractionInformation interaction) {
        if (source instanceof class_3609) {
            class_3609 flowableFluid = (class_3609)source;
            INTERACTIONS.computeIfAbsent(flowableFluid.method_15751(), s -> new ArrayList()).add(interaction);
            INTERACTIONS.computeIfAbsent(flowableFluid.method_15750(), s -> new ArrayList()).add(interaction);
        } else {
            INTERACTIONS.computeIfAbsent(source, s -> new ArrayList()).add(interaction);
        }
    }

    public static boolean canInteract(class_1937 level, class_2338 pos) {
        class_3610 state = level.method_8316(pos);
        List interactions = INTERACTIONS.getOrDefault(state.method_15772(), Collections.emptyList());
        for (class_2350 direction : class_2404.field_34006) {
            class_2338 relativePos = pos.method_10093(direction.method_10153());
            for (InteractionInformation interaction : interactions) {
                if (!interaction.predicate().test(level, pos, relativePos, state)) continue;
                interaction.interaction().interact(level, pos, relativePos, state);
                return true;
            }
        }
        return false;
    }

    static {
        FluidInteractionRegistry.addInteraction((class_3611)class_3612.field_15908, new InteractionInformation((class_3611)class_3612.field_15910, fluidState -> fluidState.method_15771() ? class_2246.field_10540.method_9564() : class_2246.field_10445.method_9564()));
        FluidInteractionRegistry.addInteraction((class_3611)class_3612.field_15908, new InteractionInformation((level, currentPos, relativePos, currentState) -> level.method_8320(currentPos.method_10074()).method_27852(class_2246.field_22090) && level.method_8320(relativePos).method_27852(class_2246.field_10384), class_2246.field_22091.method_9564()));
        FluidInteractionRegistry.addInteraction((class_3611)class_3612.field_15908, new InteractionInformation((class_3611)AllFluids.HONEY, fluidState -> {
            if (fluidState.method_15771()) {
                return class_2246.field_10540.method_9564();
            }
            return AllBlocks.LIMESTONE.method_9564();
        }));
        FluidInteractionRegistry.addInteraction((class_3611)class_3612.field_15908, new InteractionInformation((class_3611)AllFluids.CHOCOLATE, fluidState -> {
            if (fluidState.method_15771()) {
                return class_2246.field_10540.method_9564();
            }
            return AllBlocks.SCORIA.method_9564();
        }));
    }

    public record InteractionInformation(HasFluidInteraction predicate, FluidInteraction interaction) {
        public InteractionInformation(class_3611 type, class_2680 state) {
            this(type, (class_3610 fluidState) -> state);
        }

        public InteractionInformation(HasFluidInteraction predicate, class_2680 state) {
            this(predicate, (class_3610 fluidState) -> state);
        }

        public InteractionInformation(class_3611 type, Function<class_3610, class_2680> getState) {
            this((class_1937 level, class_2338 currentPos, class_2338 relativePos, class_3610 currentState) -> {
                class_3610 state = level.method_8316(relativePos);
                class_3611 fluid = state.method_15772();
                if (!fluid.method_15793(state) && fluid instanceof class_3609) {
                    class_3609 flowableFluid = (class_3609)fluid;
                    fluid = flowableFluid.method_15751();
                }
                return fluid == type;
            }, getState);
        }

        public InteractionInformation(HasFluidInteraction predicate, Function<class_3610, class_2680> getState) {
            this(predicate, (class_1937 level, class_2338 currentPos, class_2338 relativePos, class_3610 currentState) -> {
                level.method_8501(currentPos, (class_2680)getState.apply(currentState));
                level.method_20290(1501, currentPos, 0);
            });
        }
    }

    @FunctionalInterface
    public static interface HasFluidInteraction {
        public boolean test(class_1937 var1, class_2338 var2, class_2338 var3, class_3610 var4);
    }

    @FunctionalInterface
    public static interface FluidInteraction {
        public void interact(class_1937 var1, class_2338 var2, class_2338 var3, class_3610 var4);
    }
}

