/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.fluids;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_2350;
import net.minecraft.class_3829;
import net.minecraft.class_9335;
import org.jetbrains.annotations.NotNull;

public interface FluidInventory
extends class_3829,
Iterable<FluidStack> {
    public static final Hash.Strategy<FluidStack> FLUID_STACK_HASH_STRATEGY = new Hash.Strategy<FluidStack>(){

        public boolean equals(FluidStack stack, FluidStack other) {
            return stack == other || stack != null && other != null && FluidStack.areFluidsAndComponentsEqual(stack, other);
        }

        public int hashCode(FluidStack stack) {
            return FluidStack.hashCode(stack);
        }
    };

    default public void method_5448() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.setStack(i, FluidStack.EMPTY);
        }
        this.markDirty();
    }

    default public int count(FluidStack stack, class_2350 side) {
        return this.count(stack);
    }

    default public int count(FluidStack stack) {
        int maxAmount = stack.getAmount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.count(stack, maxAmount);
    }

    default public int count(FluidStack stack, int maxAmount, class_2350 side) {
        return this.count(stack, maxAmount);
    }

    default public int count(FluidStack stack, int maxAmount) {
        int amount = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            FluidStack target = this.getStack(i);
            if (target.isEmpty() || !this.matches(target, stack) || (amount += target.getAmount()) < maxAmount) continue;
            return maxAmount;
        }
        return amount;
    }

    default public FluidStack count(Predicate<FluidStack> predicate, class_2350 side) {
        return this.count(predicate);
    }

    default public FluidStack count(Predicate<FluidStack> predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            FluidStack stack = this.getStack(i);
            if (stack.isEmpty() || !predicate.test(stack)) continue;
            return this.onExtract(stack);
        }
        return FluidStack.EMPTY;
    }

    default public FluidStack count(Predicate<FluidStack> predicate, int maxAmount, class_2350 side) {
        return this.count(predicate, maxAmount);
    }

    default public FluidStack count(Predicate<FluidStack> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return FluidStack.EMPTY;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            FluidStack findStack = this.getStack(i);
            if (findStack.isEmpty() || !predicate.test(findStack)) continue;
            int amount = findStack.getAmount();
            if (amount >= maxAmount) {
                return this.onExtract(findStack.directCopy(maxAmount));
            }
            ++i;
            while (i < size) {
                FluidStack stack = this.getStack(i);
                if (!stack.isEmpty() && this.matches(stack, findStack) && (amount += stack.getAmount()) >= maxAmount) {
                    return this.onExtract(findStack.directCopy(maxAmount));
                }
                ++i;
            }
            return this.onExtract(findStack.directCopy(amount));
        }
        return FluidStack.EMPTY;
    }

    default public FluidStack countAny(class_2350 side) {
        return this.countAny();
    }

    default public FluidStack countAny() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            FluidStack target = this.getStack(i);
            if (target.isEmpty()) continue;
            return this.onExtract(target.directCopy(target.getAmount()));
        }
        return FluidStack.EMPTY;
    }

    default public FluidStack countAny(int maxAmount, class_2350 side) {
        return this.extractAny(maxAmount);
    }

    default public FluidStack countAny(int maxAmount) {
        if (maxAmount == 0) {
            return FluidStack.EMPTY;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            FluidStack findStack = this.getStack(i);
            if (findStack.isEmpty()) continue;
            int amount = findStack.getAmount();
            if (amount >= maxAmount) {
                return this.onExtract(findStack.directCopy(maxAmount));
            }
            ++i;
            while (i < size) {
                FluidStack stack = this.getStack(i);
                if (!stack.isEmpty() && this.matches(stack, findStack) && (amount += stack.getAmount()) >= maxAmount) {
                    return this.onExtract(findStack.directCopy(maxAmount));
                }
                ++i;
            }
            return this.onExtract(findStack.directCopy(amount));
        }
        return FluidStack.EMPTY;
    }

    default public int countSpace(FluidStack stack, class_2350 side) {
        return this.countSpace(stack);
    }

    default public int countSpace(FluidStack stack) {
        int maxAmount = stack.getAmount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.countSpace(stack, maxAmount);
    }

    default public int countSpace(FluidStack stack, int maxAmount, class_2350 side) {
        return this.countSpace(stack, maxAmount);
    }

    default public int countSpace(FluidStack stack, int maxAmount) {
        int amount = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            FluidStack target;
            if (!this.isValid(i, stack) || !((target = this.getStack(i)).isEmpty() ? (amount += this.getMaxAmount(stack)) >= maxAmount : this.matches(target, stack) && (amount += target.getMaxAmount() - target.getAmount()) >= maxAmount)) continue;
            return maxAmount;
        }
        return amount;
    }

    default public boolean countSpace(List<FluidStack> stacks, class_2350 side) {
        return this.countSpace(stacks);
    }

    default public boolean countSpace(List<FluidStack> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            int amount;
            FluidStack stack = stacks.getFirst();
            return this.countSpace(stack, amount = stack.getAmount()) == amount;
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(FLUID_STACK_HASH_STRATEGY);
        for (FluidStack stack : stacks) {
            map.merge((Object)stack, stack.getAmount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int amount;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            FluidStack stack = (FluidStack)entry.getKey();
            return this.countSpace(stack, amount = entry.getIntValue()) == amount;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            FluidStack target = this.getStack(i);
            boolean empty = target.isEmpty();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int insert;
                Object2IntMap.Entry entry;
                FluidStack stack;
                if (!this.isValid(i, stack = (FluidStack)(entry = (Object2IntMap.Entry)iterator.next()).getKey())) continue;
                if (empty) {
                    int insert2;
                    int remaining = entry.getIntValue();
                    if (remaining == (insert2 = Math.min(remaining, this.getMaxAmount(stack)))) {
                        iterator.remove();
                        if (!entries.isEmpty()) continue;
                        return true;
                    }
                    entry.setValue(remaining - insert2);
                    continue;
                }
                if (!this.matches(target, stack)) continue;
                int maxAmount = target.getMaxAmount();
                int amount = target.getAmount();
                if (amount == maxAmount) continue;
                int remaining = entry.getIntValue();
                if (remaining == (insert = Math.min(remaining, maxAmount - amount))) {
                    iterator.remove();
                    if (!entries.isEmpty()) continue;
                    return true;
                }
                entry.setValue(remaining - insert);
            } while (iterator.hasNext());
        }
        return false;
    }

    default public int extract(FluidStack stack, class_2350 side) {
        return this.extract(stack);
    }

    default public int extract(FluidStack stack) {
        int maxAmount = stack.getAmount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.extract(stack, maxAmount);
    }

    default public int extract(FluidStack stack, int maxAmount, class_2350 side) {
        return this.extract(stack, maxAmount);
    }

    default public int extract(FluidStack stack, int maxAmount) {
        int remaining = maxAmount;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            FluidStack target = this.getStack(i);
            if (target.isEmpty() || !this.matches(target, stack)) continue;
            int amount = target.getAmount();
            if (amount > remaining) {
                target.setAmount(amount - remaining);
                this.markDirty();
                return maxAmount;
            }
            this.setStack(i, FluidStack.EMPTY);
            if (amount == remaining) {
                this.markDirty();
                return maxAmount;
            }
            remaining -= amount;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.markDirty();
        return maxAmount - remaining;
    }

    default public FluidStack extract(Predicate<FluidStack> predicate, class_2350 side) {
        return this.extract(predicate);
    }

    default public FluidStack extract(Predicate<FluidStack> predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            FluidStack stack = this.getStack(i);
            if (stack.isEmpty() || !predicate.test(stack)) continue;
            this.setStack(i, FluidStack.EMPTY);
            this.markDirty();
            return this.onExtract(stack);
        }
        return FluidStack.EMPTY;
    }

    default public FluidStack extract(Predicate<FluidStack> predicate, int maxAmount, class_2350 side) {
        return this.extract(predicate, maxAmount);
    }

    default public FluidStack extract(Predicate<FluidStack> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return FluidStack.EMPTY;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            FluidStack findStack = this.getStack(i);
            if (findStack.isEmpty() || !predicate.test(findStack)) continue;
            int amount = findStack.getAmount();
            if (amount > maxAmount) {
                findStack.setAmount(amount - maxAmount);
                this.markDirty();
                return this.onExtract(findStack.directCopy(maxAmount));
            }
            this.setStack(i, FluidStack.EMPTY);
            if (amount == maxAmount) {
                this.markDirty();
                return this.onExtract(findStack);
            }
            int remaining = maxAmount - amount;
            ++i;
            while (i < size) {
                FluidStack stack = this.getStack(i);
                if (!stack.isEmpty() && this.matches(stack, findStack)) {
                    amount = stack.getAmount();
                    if (amount < remaining) {
                        this.setStack(i, FluidStack.EMPTY);
                        remaining -= amount;
                    } else {
                        if (amount == remaining) {
                            this.setStack(i, FluidStack.EMPTY);
                        } else {
                            stack.setAmount(amount - remaining);
                        }
                        this.markDirty();
                        findStack.setAmount(maxAmount);
                        return this.onExtract(findStack);
                    }
                }
                ++i;
            }
            this.markDirty();
            findStack.setAmount(maxAmount - remaining);
            return this.onExtract(findStack);
        }
        return FluidStack.EMPTY;
    }

    default public FluidStack extractAny(class_2350 side) {
        return this.extractAny();
    }

    default public FluidStack extractAny() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            FluidStack target = this.getStack(i);
            if (target.isEmpty()) continue;
            this.setStack(i, FluidStack.EMPTY);
            this.markDirty();
            return this.onExtract(target);
        }
        return FluidStack.EMPTY;
    }

    default public FluidStack extractAny(int maxAmount, class_2350 side) {
        return this.extractAny(maxAmount);
    }

    default public FluidStack extractAny(int maxAmount) {
        if (maxAmount == 0) {
            return FluidStack.EMPTY;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            FluidStack findStack = this.getStack(i);
            if (findStack.isEmpty()) continue;
            int amount = findStack.getAmount();
            if (amount > maxAmount) {
                findStack.setAmount(amount - maxAmount);
                this.markDirty();
                return this.onExtract(findStack.directCopy(maxAmount));
            }
            this.setStack(i, FluidStack.EMPTY);
            if (amount == maxAmount) {
                this.markDirty();
                return this.onExtract(findStack);
            }
            int remaining = maxAmount - amount;
            ++i;
            while (i < size) {
                FluidStack stack = this.getStack(i);
                if (!stack.isEmpty() && this.matches(stack, findStack)) {
                    amount = stack.getAmount();
                    if (amount < remaining) {
                        this.setStack(i, FluidStack.EMPTY);
                        remaining -= amount;
                    } else {
                        if (amount == remaining) {
                            this.setStack(i, FluidStack.EMPTY);
                        } else {
                            stack.setAmount(amount - remaining);
                        }
                        this.markDirty();
                        findStack.setAmount(maxAmount);
                        return this.onExtract(findStack);
                    }
                }
                ++i;
            }
            this.markDirty();
            findStack.setAmount(maxAmount - remaining);
            return this.onExtract(findStack);
        }
        return FluidStack.EMPTY;
    }

    default public int forceInsert(FluidStack stack) {
        return this.insert(stack);
    }

    default public int forceInsert(FluidStack stack, int maxAmount) {
        return this.insert(stack, maxAmount);
    }

    default public boolean forcePreciseInsert(FluidStack stack) {
        return this.preciseInsert(stack);
    }

    default public boolean forcePreciseInsert(FluidStack stack, int maxAmount) {
        return this.preciseInsert(stack, maxAmount);
    }

    default public int getMaxAmount(FluidStack stack) {
        return Math.min(this.getMaxAmountPerStack(), stack.getMaxAmount());
    }

    default public int getMaxAmountPerStack() {
        return Integer.MAX_VALUE;
    }

    public FluidStack getStack(int var1);

    default public int insert(FluidStack stack, class_2350 side) {
        return this.insert(stack);
    }

    default public int insert(FluidStack stack) {
        int maxAmount = stack.getAmount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.insert(stack, maxAmount);
    }

    default public int insert(FluidStack stack, int maxAmount, class_2350 side) {
        return this.insert(stack, maxAmount);
    }

    default public int insert(FluidStack stack, int maxAmount) {
        int remaining = maxAmount;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!this.isValid(i, stack)) continue;
            FluidStack target = this.getStack(i);
            if (target.isEmpty()) {
                int insert = Math.min(remaining, this.getMaxAmount(stack));
                this.setStack(i, stack.directCopy(insert));
                if (remaining == insert) {
                    this.markDirty();
                    return maxAmount;
                }
                remaining -= insert;
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.getMaxAmount();
            int amount = target.getAmount();
            if (amount == maxCount) continue;
            int insert = Math.min(remaining, maxCount - amount);
            target.setAmount(amount + insert);
            if (remaining == insert) {
                this.markDirty();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.markDirty();
        return maxAmount - remaining;
    }

    default public List<FluidStack> insert(List<FluidStack> stacks, class_2350 side) {
        return this.insert(stacks);
    }

    default public List<FluidStack> insert(List<FluidStack> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            int insert;
            FluidStack stack = stacks.getFirst();
            int amount = stack.getAmount();
            if (amount == (insert = this.insert(stack))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(stack.directCopy(amount - insert));
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(FLUID_STACK_HASH_STRATEGY);
        for (FluidStack stack : stacks) {
            map.merge((Object)stack, stack.getAmount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int insert;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            FluidStack stack = (FluidStack)entry.getKey();
            int amount = entry.getIntValue();
            if (amount == (insert = this.insert(stack, amount))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(stack.directCopy(amount - insert));
        }
        boolean dirty = false;
        int size = this.size();
        block1: for (int i = 0; i < size; ++i) {
            FluidStack target = this.getStack(i);
            boolean empty = target.isEmpty();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry entry;
                FluidStack stack;
                if (!this.isValid(i, stack = (FluidStack)(entry = (Object2IntMap.Entry)iterator.next()).getKey())) continue;
                if (empty) {
                    int remaining = entry.getIntValue();
                    int insert = Math.min(remaining, this.getMaxAmount(stack));
                    this.setStack(i, stack.directCopy(insert));
                    if (remaining == insert) {
                        iterator.remove();
                        if (entries.isEmpty()) {
                            this.markDirty();
                            return List.of();
                        }
                    } else {
                        entry.setValue(remaining - insert);
                    }
                    dirty = true;
                    continue block1;
                }
                if (!this.matches(target, stack)) continue;
                int maxAmount = target.getMaxAmount();
                int amount = target.getAmount();
                if (amount == maxAmount) continue block1;
                int remaining = entry.getIntValue();
                int insert = Math.min(remaining, maxAmount - amount);
                target.setAmount(amount + insert);
                if (remaining == insert) {
                    iterator.remove();
                    if (entries.isEmpty()) {
                        this.markDirty();
                        return List.of();
                    }
                } else {
                    entry.setValue(remaining - insert);
                }
                dirty = true;
                continue block1;
            } while (iterator.hasNext());
        }
        if (dirty) {
            ArrayList<FluidStack> result = new ArrayList<FluidStack>(entries.size());
            for (Object2IntMap.Entry entry : entries) {
                FluidStack stack = (FluidStack)entry.getKey();
                int amount = entry.getIntValue();
                if (stack.getAmount() == amount) {
                    result.add(stack);
                    continue;
                }
                result.add(stack.directCopy(amount));
            }
            this.markDirty();
            return result;
        }
        return stacks;
    }

    default public int insertExist(FluidStack stack, class_2350 side) {
        return this.insertExist(stack);
    }

    default public int insertExist(FluidStack stack) {
        int maxAmount;
        if (stack.isEmpty()) {
            return 0;
        }
        int remaining = maxAmount = stack.getAmount();
        ArrayList<Integer> emptys = new ArrayList<Integer>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!this.isValid(i, stack)) continue;
            FluidStack target = this.getStack(i);
            if (target.isEmpty()) {
                emptys.add(i);
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.getMaxAmount();
            int amount = target.getAmount();
            if (amount == maxCount) continue;
            int insert = Math.min(remaining, maxCount - amount);
            target.setAmount(amount + insert);
            if (remaining == insert) {
                this.markDirty();
                return maxAmount;
            }
            remaining -= insert;
        }
        java.util.Iterator iterator = emptys.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            int insert = Math.min(remaining, this.getMaxAmount(stack));
            this.setStack(i, stack.directCopy(insert));
            if (remaining == insert) {
                this.markDirty();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.markDirty();
        return maxAmount - remaining;
    }

    default public boolean isEmpty() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (this.getStack(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public boolean isValid(int slot, FluidStack stack) {
        return true;
    }

    @NotNull
    default public java.util.Iterator<FluidStack> iterator(class_2350 side) {
        return this.iterator();
    }

    @Override
    @NotNull
    default public java.util.Iterator<FluidStack> iterator() {
        return new Iterator(this);
    }

    default public void markDirty() {
    }

    default public boolean matches(FluidStack stack, FluidStack otherStack) {
        return FluidStack.areFluidsAndComponentsEqualIgnoreCapacity(stack, otherStack);
    }

    default public FluidStack onExtract(FluidStack stack) {
        return stack;
    }

    default public boolean preciseExtract(FluidStack stack, class_2350 side) {
        return this.preciseExtract(stack);
    }

    default public boolean preciseExtract(FluidStack stack) {
        if (stack.isEmpty()) {
            return true;
        }
        int remaining = stack.getAmount();
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            FluidStack target = this.getStack(i);
            if (target.isEmpty() || !this.matches(target, stack)) continue;
            int amount = target.getAmount();
            if (amount > remaining) {
                changes.forEach(Runnable::run);
                target.setAmount(amount - remaining);
                this.markDirty();
                return true;
            }
            if (amount == remaining) {
                changes.forEach(Runnable::run);
                this.setStack(i, FluidStack.EMPTY);
                this.markDirty();
                return true;
            }
            int slot = i;
            changes.add(() -> this.setStack(slot, FluidStack.EMPTY));
            remaining -= amount;
        }
        return false;
    }

    default public FluidStack preciseExtract(Predicate<FluidStack> predicate, int maxAmount, class_2350 side) {
        return this.preciseExtract(predicate, maxAmount);
    }

    default public FluidStack preciseExtract(Predicate<FluidStack> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return FluidStack.EMPTY;
        }
        int size = this.size();
        ArrayList<Integer> buffer = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            FluidStack findStack = this.getStack(i);
            if (findStack.isEmpty() || !predicate.test(findStack)) continue;
            int amount = findStack.getAmount();
            if (amount > maxAmount) {
                findStack.setAmount(amount - maxAmount);
                this.markDirty();
                return this.onExtract(findStack.directCopy(maxAmount));
            }
            if (amount == maxAmount) {
                this.setStack(i, FluidStack.EMPTY);
                this.markDirty();
                return this.onExtract(findStack);
            }
            buffer.add(i);
            int remaining = maxAmount - amount;
            ++i;
            while (i < size) {
                FluidStack stack = this.getStack(i);
                if (!stack.isEmpty() && this.matches(stack, findStack)) {
                    amount = stack.getAmount();
                    if (amount < remaining) {
                        buffer.add(i);
                        remaining -= amount;
                    } else {
                        buffer.forEach(slot -> this.setStack((int)slot, FluidStack.EMPTY));
                        if (amount == remaining) {
                            this.setStack(i, FluidStack.EMPTY);
                        } else {
                            stack.setAmount(amount - remaining);
                        }
                        this.markDirty();
                        findStack.setAmount(maxAmount);
                        return this.onExtract(findStack);
                    }
                }
                ++i;
            }
        }
        return FluidStack.EMPTY;
    }

    default public boolean preciseInsert(FluidStack stack, class_2350 side) {
        return this.preciseInsert(stack);
    }

    default public boolean preciseInsert(FluidStack stack) {
        int maxAmount = stack.getAmount();
        if (maxAmount == 0) {
            return true;
        }
        return this.preciseInsert(stack, maxAmount);
    }

    default public boolean preciseInsert(FluidStack stack, int maxAmount, class_2350 side) {
        return this.preciseInsert(stack, maxAmount);
    }

    default public boolean preciseInsert(FluidStack stack, int maxAmount) {
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!this.isValid(i, stack)) continue;
            FluidStack target = this.getStack(i);
            if (target.isEmpty()) {
                int insert = Math.min(maxAmount, this.getMaxAmount(stack));
                if (maxAmount == insert) {
                    changes.forEach(Runnable::run);
                    this.setStack(i, stack.directCopy(insert));
                    this.markDirty();
                    return true;
                }
                int slot = i;
                changes.add(() -> this.setStack(slot, stack.directCopy(insert)));
                maxAmount -= insert;
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.getMaxAmount();
            int amount = target.getAmount();
            if (amount == maxCount) continue;
            int insert = Math.min(maxAmount, maxCount - amount);
            if (maxAmount == insert) {
                changes.forEach(Runnable::run);
                target.setAmount(amount + insert);
                this.markDirty();
                return true;
            }
            changes.add(() -> target.setAmount(amount + insert));
            maxAmount -= insert;
        }
        return false;
    }

    default public boolean preciseInsert(List<FluidStack> stacks, class_2350 side) {
        return this.preciseInsert(stacks);
    }

    default public boolean preciseInsert(List<FluidStack> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            return this.preciseInsert(stacks.getFirst());
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(FLUID_STACK_HASH_STRATEGY);
        for (FluidStack stack : stacks) {
            map.merge((Object)stack, stack.getAmount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            return this.preciseInsert((FluidStack)entry.getKey(), entry.getIntValue());
        }
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            FluidStack target = this.getStack(i);
            boolean empty = target.isEmpty();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int insert;
                Object2IntMap.Entry entry;
                FluidStack stack;
                if (!this.isValid(i, stack = (FluidStack)(entry = (Object2IntMap.Entry)iterator.next()).getKey())) continue;
                if (empty) {
                    int insert2;
                    int remaining = entry.getIntValue();
                    if (remaining == (insert2 = Math.min(remaining, this.getMaxAmount(stack)))) {
                        iterator.remove();
                        if (!entries.isEmpty()) continue;
                        changes.forEach(Runnable::run);
                        this.setStack(i, stack.directCopy(insert2));
                        this.markDirty();
                        return true;
                    }
                    int slot = i;
                    changes.add(() -> this.setStack(slot, stack.directCopy(insert2)));
                    entry.setValue(remaining - insert2);
                    continue;
                }
                if (!this.matches(target, stack)) continue;
                int maxAmount = target.getMaxAmount();
                int amount = target.getAmount();
                if (amount == maxAmount) continue;
                int remaining = entry.getIntValue();
                if (remaining == (insert = Math.min(remaining, maxAmount - amount))) {
                    iterator.remove();
                    if (!entries.isEmpty()) continue;
                    changes.forEach(Runnable::run);
                    target.setAmount(amount + insert);
                    this.markDirty();
                    return true;
                }
                changes.add(() -> target.setAmount(amount + insert));
                entry.setValue(remaining - insert);
            } while (iterator.hasNext());
        }
        return false;
    }

    default public FluidStack removeMaxSize(FluidStack stack, Optional<Integer> max) {
        class_9335 components = stack.directComponents();
        components.method_57942();
        components.field_49655.remove(AllDataComponents.FLUID_MAX_CAPACITY, max);
        return stack;
    }

    default public FluidStack removeStack(int slot, int amount) {
        if (slot >= this.size() || amount <= 0) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = this.getStack(slot);
        int count = stack.getAmount();
        if (count == 0) {
            return stack;
        }
        if (amount >= count) {
            this.setStack(slot, FluidStack.EMPTY);
            return this.onExtract(stack);
        }
        stack.setAmount(count - amount);
        return this.onExtract(stack.directCopy(amount));
    }

    default public FluidStack removeStack(int slot) {
        if (slot >= this.size()) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = this.getStack(slot);
        if (stack.isEmpty()) {
            return stack;
        }
        this.setStack(slot, FluidStack.EMPTY);
        return this.onExtract(stack);
    }

    default public void setMaxSize(FluidStack stack, Optional<Integer> max) {
        class_9335 components = stack.directComponents();
        components.method_57942();
        components.field_49655.put(AllDataComponents.FLUID_MAX_CAPACITY, max);
    }

    public void setStack(int var1, FluidStack var2);

    public int size();

    default public Stream<FluidStack> stream(class_2350 side) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(side), 16), false);
    }

    default public Stream<FluidStack> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false);
    }

    public static class Iterator
    implements java.util.Iterator<FluidStack> {
        private final FluidInventory inventory;
        private final int size;
        private int index;

        public Iterator(FluidInventory inventory) {
            this.inventory = inventory;
            this.size = inventory.size();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public FluidStack next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.inventory.getStack(this.index++);
        }
    }
}

