/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config;

import com.google.common.collect.ImmutableMap;
import com.tristankechlo.livingthings.config.entity.CrabConfig;
import com.tristankechlo.livingthings.config.entity.ElephantConfig;
import com.tristankechlo.livingthings.config.entity.FlamingoConfig;
import com.tristankechlo.livingthings.config.entity.GiraffeConfig;
import com.tristankechlo.livingthings.config.entity.KoalaConfig;
import com.tristankechlo.livingthings.config.entity.LionConfig;
import com.tristankechlo.livingthings.config.entity.MantarayConfig;
import com.tristankechlo.livingthings.config.entity.MonkeyConfig;
import com.tristankechlo.livingthings.config.entity.OstrichConfig;
import com.tristankechlo.livingthings.config.entity.OwlConfig;
import com.tristankechlo.livingthings.config.entity.PeacockConfig;
import com.tristankechlo.livingthings.config.entity.PenguinConfig;
import com.tristankechlo.livingthings.config.entity.RaccoonConfig;
import com.tristankechlo.livingthings.config.entity.SeahorseConfig;
import com.tristankechlo.livingthings.config.entity.SharkConfig;
import com.tristankechlo.livingthings.config.entity.ShroomieConfig;
import com.tristankechlo.livingthings.config.entity.SnailConfig;
import com.tristankechlo.livingthings.config.util.EntityConfig;
import com.tristankechlo.livingthings.config.util.SpawnData;
import com.tristankechlo.livingthings.config.values.BooleanValue;
import com.tristankechlo.livingthings.config.values.NumberValue;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_5483;
import net.minecraft.class_6010;

public final class GeneralConfig
extends EntityConfig {
    private static final GeneralConfig INSTANCE = new GeneralConfig();
    public final BooleanValue ambientMode = new BooleanValue("ambientMode", false);
    public final BooleanValue doBananaDrops = new BooleanValue("doBananaDrops", true);
    public final NumberValue.DoubleValue bananaDropChance = new NumberValue.DoubleValue("bananaDropChance", 45.0, 0.0, 100.0);

    private GeneralConfig() {
        super("livingthings");
        this.registerConfigValues(this.ambientMode, this.doBananaDrops, this.bananaDropChance);
    }

    public static GeneralConfig get() {
        return INSTANCE;
    }

    public static Map<class_2960, List<class_6010<class_5483.class_1964>>> getSpawnData() {
        HashMap<class_2960, List<class_6010<class_5483.class_1964>>> hashMap = new HashMap<class_2960, List<class_6010<class_5483.class_1964>>>();
        GeneralConfig.getDefaults().forEach((entityType, spawnDataSupplier) -> ((List)spawnDataSupplier.get()).forEach(spawnData -> spawnData.getBiomes().forEach(biome -> {
            List spawnDataList = hashMap.getOrDefault(biome, new ArrayList());
            spawnDataList.add(spawnData.asSpawnerData((class_1299<?>)entityType));
            hashMap.put((class_2960)biome, spawnDataList);
        })));
        return hashMap;
    }

    private static Map<class_1299<?>, Supplier<List<SpawnData>>> getDefaults() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ModEntityTypes.CRAB.get(), CrabConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.ELEPHANT.get(), ElephantConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.FLAMINGO.get(), FlamingoConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.GIRAFFE.get(), GiraffeConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.KOALA.get(), KoalaConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.LION.get(), LionConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.MANTARAY.get(), MantarayConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.MONKEY.get(), MonkeyConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.OSTRICH.get(), OstrichConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.OWL.get(), OwlConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.PENGUIN.get(), PenguinConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.RACCOON.get(), RaccoonConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.SEAHORSE.get(), SeahorseConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.SHARK.get(), SharkConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.SHROOMIE.get(), ShroomieConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.SNAIL.get(), SnailConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.PEACOCK.get(), PeacockConfig.get().spawnBiomes::get);
        return builder.build();
    }
}

