/*
 * Decompiled with CFR 0.152.
 */
package fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.component;

import com.google.common.collect.ImmutableMap;
import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.component.TooltipComponent;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_3902;
import net.minecraft.class_6538;
import net.minecraft.class_8053;
import net.minecraft.class_9288;
import net.minecraft.class_9299;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9336;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public final class ComponentsTooltipComponent
implements TooltipComponent {
    private static final class_2561 UNBREAKABLE_TOOLTIP = class_2561.method_43471((String)"item.unbreakable").method_27692(class_124.field_1078);
    private static final TooltipProviderExtractor<class_9288> CONTAINER = itemContainerContents -> (tooltipContext, consumer, tooltipFlag, dataComponentGetter) -> {
        for (class_1799 item : itemContainerContents.method_59714()) {
            consumer.accept(class_2561.method_43469((String)"item.container.item_count", (Object[])new Object[]{item.method_7964(), item.method_7947()}).method_27692(class_124.field_1080));
        }
    };
    private static final TooltipProviderExtractor<class_8053> TRIM = armorTrim -> (tooltipContext, consumer, tooltipFlag, dataComponentGetter) -> {
        ArrayList tooltipLines = new ArrayList();
        armorTrim.method_57409(tooltipContext, tooltipLines::add, tooltipFlag, dataComponentGetter);
        if (tooltipLines.size() == 3) {
            consumer.accept((class_2561)tooltipLines.get(1));
        } else {
            tooltipLines.forEach(consumer);
        }
    };
    private static final TooltipProviderExtractor<class_3902> UNBREAKABLE = unit -> (tooltipContext, consumer, tooltipFlag, dataComponentGetter) -> consumer.accept(UNBREAKABLE_TOOLTIP);
    private static final TooltipProviderExtractor<class_6538> CAN_BREAK = adventureModePredicate -> (tooltipContext, consumer, tooltipFlag, dataComponentGetter) -> {
        consumer.accept(class_6538.field_49247);
        adventureModePredicate.method_57330(consumer);
    };
    private static final TooltipProviderExtractor<class_6538> CAN_PLACE = adventureModePredicate -> (tooltipContext, consumer, tooltipFlag, dataComponentGetter) -> {
        consumer.accept(class_6538.field_49248);
        adventureModePredicate.method_57330(consumer);
    };
    private static final Map<class_9331<?>, TooltipProviderExtractor<?>> TOOLTIP_PROVIDER_EXTRACTORS;

    @Override
    public void addToTooltip(class_1799 itemStack, class_1792.class_9635 tooltipContext, Consumer<class_2561> componentConsumer, class_1836 tooltipFlag) {
        class_10712 tooltipDisplay = (class_10712)itemStack.method_58695(class_9334.field_56400, (Object)class_10712.field_56318);
        for (class_9336 component : itemStack.method_57353()) {
            class_9299 tooltipProvider;
            if (!tooltipDisplay.method_67214(component.comp_2443()) || (tooltipProvider = TOOLTIP_PROVIDER_EXTRACTORS.getOrDefault(component.comp_2443(), TooltipProviderExtractor.DEFAULT).applyAsType(component.comp_2444())) == null) continue;
            tooltipProvider.method_57409(tooltipContext, componentConsumer, tooltipFlag, (class_9473)itemStack.method_57353());
        }
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)class_9334.field_49622, CONTAINER);
        builder.put((Object)class_9334.field_49607, TRIM);
        builder.put((Object)class_9334.field_49630, UNBREAKABLE);
        builder.put((Object)class_9334.field_49635, CAN_BREAK);
        builder.put((Object)class_9334.field_49634, CAN_PLACE);
        TOOLTIP_PROVIDER_EXTRACTORS = builder.build();
    }

    @FunctionalInterface
    private static interface TooltipProviderExtractor<T>
    extends Function<T, class_9299> {
        public static final TooltipProviderExtractor<?> DEFAULT = o -> {
            class_9299 tooltipProvider;
            return o instanceof class_9299 ? (tooltipProvider = (class_9299)o) : null;
        };

        @Nullable
        default public class_9299 applyAsType(Object o) {
            return (class_9299)this.apply(o);
        }
    }
}

