/*
 * Decompiled with CFR 0.152.
 */
package fuzs.helditemtooltips.client.handler;

import fuzs.helditemtooltips.HeldItemTooltips;
import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.HoverTextManager;
import fuzs.helditemtooltips.config.ClientConfig;
import fuzs.helditemtooltips.mixin.client.accessor.GuiAccessor;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10209;
import net.minecraft.class_10712;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_9334;
import net.minecraft.class_9779;

public class SelectedItemHandler {
    public static final SelectedItemHandler INSTANCE = new SelectedItemHandler();
    private int remainingHighlightTicks;
    private class_1799 highlightingItemStack = class_1799.field_8037;
    private int highlightingHotbarSlot = -1;
    private int maxLines;

    public void onEndClientTick(class_310 minecraft) {
        if (minecraft.field_1724 == null || minecraft.method_1493()) {
            return;
        }
        class_1799 itemStack = minecraft.field_1724.method_31548().method_7391();
        int selectedSlot = minecraft.field_1724.method_31548().method_67532();
        if (!this.highlightingItemStack.method_7960() && class_1799.method_7984((class_1799)itemStack, (class_1799)this.highlightingItemStack) && itemStack.method_7964().equals((Object)this.highlightingItemStack.method_7964()) && selectedSlot == this.highlightingHotbarSlot) {
            if (this.highlightingItemStack != itemStack) {
                this.highlightingItemStack = itemStack;
                HoverTextManager.reset();
            }
            if (this.remainingHighlightTicks > 0) {
                --this.remainingHighlightTicks;
            }
        } else {
            this.highlightingItemStack = itemStack;
            this.highlightingHotbarSlot = selectedSlot;
            if (this.highlightingItemStack.method_7960()) {
                this.remainingHighlightTicks = 0;
            } else {
                this.remainingHighlightTicks = ((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).displayTime;
                HoverTextManager.reset();
            }
        }
    }

    public void renderSelectedItemName(class_332 guiGraphics, class_9779 deltaTracker) {
        int alpha;
        if (this.highlightingItemStack.method_7960()) {
            return;
        }
        class_10209.method_64146().method_15396("selectedItemName");
        int n = alpha = ((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).displayTime == 0 ? 255 : (int)Math.min(255.0f, (float)this.remainingHighlightTicks * 255.0f / 10.0f);
        if (alpha <= 0) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        List<class_2561> tooltipLines = this.getTooltipLines(minecraft);
        float currentScale = (float)((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).displayScale / 6.0f;
        int posX = this.getPosX(currentScale, guiGraphics.method_51421());
        int posY = this.getPosY(currentScale, guiGraphics.method_51443(), tooltipLines.size(), minecraft);
        class_327 font = minecraft.field_1772;
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().scale(currentScale, currentScale);
        this.drawBackground(guiGraphics, posX, posY, alpha, tooltipLines, minecraft);
        for (int i = 0; i < tooltipLines.size(); ++i) {
            int n2;
            class_2561 component = tooltipLines.get(i);
            guiGraphics.method_27534(font, component, posX, posY, 0xFFFFFF + (alpha << 24));
            if (i == 0) {
                Objects.requireNonNull(font);
                n2 = 9 + 3;
            } else {
                Objects.requireNonNull(font);
                n2 = 9 + 1;
            }
            posY += n2;
        }
        guiGraphics.method_51448().scale(1.0f / currentScale, 1.0f / currentScale);
        guiGraphics.method_51448().popMatrix();
        class_10209.method_64146().method_15407();
    }

    private int getPosX(float currentScale, int screenWidth) {
        int posX = (int)((float)screenWidth / (2.0f * currentScale));
        return posX += ((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).offsetX;
    }

    private int getPosY(float currentScale, int screenHeight, int allLines, class_310 minecraft) {
        int posY = (int)((float)screenHeight / currentScale);
        posY = (int)((float)posY - (float)((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).offsetY / currentScale);
        if (!minecraft.field_1761.method_2908()) {
            posY += 14;
        }
        return posY -= allLines > 1 ? (allLines - 1) * 10 + 2 : (allLines - 1) * 10;
    }

    private List<class_2561> getTooltipLines(class_310 minecraft) {
        int maxLines;
        ClientConfig clientConfig = (ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class);
        if (clientConfig.itemBlacklist.contains((Object)this.highlightingItemStack.method_7909()) || clientConfig.respectTooltipDisplayComponent && ((class_10712)this.highlightingItemStack.method_58695(class_9334.field_56400, (Object)class_10712.field_56318)).comp_3600()) {
            maxLines = 1;
        } else {
            int overlayMessageTime = ((GuiAccessor)minecraft.field_1705).helditemtooltips$getOverlayMessageTime();
            int n = overlayMessageTime > 0 ? (minecraft.field_1761.method_2908() ? 1 : 2) : (maxLines = clientConfig.maxLines);
        }
        if ((clientConfig.displayTime - this.remainingHighlightTicks) % clientConfig.updateInterval == 0 || this.maxLines != maxLines) {
            HoverTextManager.reset();
        }
        this.maxLines = maxLines;
        return HoverTextManager.getTooltipLines(this.highlightingItemStack, (class_1937)minecraft.field_1687, this.maxLines);
    }

    private void drawBackground(class_332 guiGraphics, int posX, int posY, int alpha, List<class_2561> lines, class_310 minecraft) {
        ClientConfig.HoverTextBackground background = ((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).background;
        class_327 font = minecraft.field_1772;
        alpha = (int)((double)alpha * (Double)minecraft.field_1690.method_42550().method_41753());
        if (background == ClientConfig.HoverTextBackground.RECTANGLE) {
            int maximumWidth = lines.stream().mapToInt(arg_0 -> ((class_327)font).method_27525(arg_0)).max().orElse(0) / 2;
            int size = lines.size();
            Objects.requireNonNull(font);
            guiGraphics.method_25294(posX - maximumWidth - 2, posY - 2, posX + maximumWidth + 2, posY + size * (9 + 1) + (size > 1 ? 1 : -1) + 2, alpha << 24);
        } else if (background == ClientConfig.HoverTextBackground.ADAPTIVE) {
            for (int i = 0; i < lines.size(); ++i) {
                int n;
                int top;
                int previousWidth = SelectedItemHandler.textWidth(font, lines, i - 1) / 2;
                int currentWidth = SelectedItemHandler.textWidth(font, lines, i) / 2;
                int nextWidth = SelectedItemHandler.textWidth(font, lines, i + 1) / 2;
                int n2 = currentWidth < previousWidth ? (i == 1 ? 1 : -1) : (top = 2);
                int bottom = currentWidth <= nextWidth ? (i == 0 ? 1 : -1) : 2;
                Objects.requireNonNull(font);
                guiGraphics.method_25294(posX - currentWidth - 2, posY - top, posX + currentWidth + 2, posY + 9 + bottom, alpha << 24);
                if (i == 0) {
                    Objects.requireNonNull(font);
                    n = 9 + 3;
                } else {
                    Objects.requireNonNull(font);
                    n = 9 + 1;
                }
                posY += n;
            }
        }
    }

    private static int textWidth(class_327 font, List<class_2561> lines, int index) {
        int clampedIndex = class_3532.method_15340((int)index, (int)0, (int)(lines.size() - 1));
        return clampedIndex == index ? font.method_27525((class_5348)lines.get(index)) : 0;
    }
}

