/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.tooltip;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.CommonFluid;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_5632;

public class BackpackTooltipComponent
implements class_5632 {
    protected List<class_1799> storage = new ArrayList<class_1799>();
    protected List<class_1799> upgrades = new ArrayList<class_1799>();
    protected List<class_1799> tools = new ArrayList<class_1799>();
    protected FluidVariantWrapper leftFluidStack = CommonFluid.empty();
    protected FluidVariantWrapper rightFluidStack = CommonFluid.empty();

    public BackpackTooltipComponent(class_1799 stack) {
        this.loadComponentData(stack);
    }

    public void loadComponentData(class_1799 stack) {
        this.loadFluidStacks(stack);
        this.storage = this.loadStorage(stack);
        this.upgrades = this.loadUpgrades(stack);
        this.storage = this.mergeStacks(this.storage);
        this.tools = this.loadTools(stack);
    }

    public void loadFluidStacks(class_1799 stack) {
        if (stack.method_57826(ModDataComponents.RENDER_INFO)) {
            RenderInfo info = (RenderInfo)stack.method_58694(ModDataComponents.RENDER_INFO);
            this.leftFluidStack = info.getLeftFluidStack();
            this.rightFluidStack = info.getRightFluidStack();
        }
    }

    public List<class_1799> loadStorage(class_1799 stack) {
        if (stack.method_57826(ModDataComponents.BACKPACK_CONTAINER)) {
            return new ArrayList<class_1799>(((BackpackContainerContents)stack.method_58694(ModDataComponents.BACKPACK_CONTAINER)).getItems().stream().filter(itemStack -> !itemStack.method_7960()).toList());
        }
        return new ArrayList<class_1799>();
    }

    public List<class_1799> loadUpgrades(class_1799 stack) {
        if (stack.method_57826(ModDataComponents.UPGRADES)) {
            return new ArrayList<class_1799>(((BackpackContainerContents)stack.method_58694(ModDataComponents.UPGRADES)).getItems().stream().filter(itemStack -> !itemStack.method_7960()).toList());
        }
        return new ArrayList<class_1799>();
    }

    public List<class_1799> mergeStacks(List<class_1799> stacks) {
        if (!stacks.isEmpty()) {
            ArrayList<class_1799> uniqueList = new ArrayList<class_1799>();
            for (class_1799 stack : stacks) {
                if (uniqueList.isEmpty()) {
                    uniqueList.add(stack);
                    continue;
                }
                boolean flag = false;
                for (int i = 0; i < uniqueList.size(); ++i) {
                    if (!class_1799.method_31577((class_1799)stack, (class_1799)((class_1799)uniqueList.get(i)))) continue;
                    int count = stack.method_7947() + ((class_1799)uniqueList.get(i)).method_7947();
                    uniqueList.set(i, stack.method_46651(count));
                    flag = true;
                    break;
                }
                if (flag) continue;
                uniqueList.add(stack);
            }
            ArrayList<class_1799> splittedList = new ArrayList<class_1799>();
            for (class_1799 itemStack : uniqueList) {
                if (itemStack.method_7947() > 999) {
                    int count = itemStack.method_7947();
                    int c = count / 999;
                    int reminder = count % 999;
                    for (int j = 0; j < c; ++j) {
                        splittedList.add(itemStack.method_46651(999));
                    }
                    splittedList.add(itemStack.method_46651(reminder));
                    continue;
                }
                splittedList.add(itemStack);
            }
            return splittedList;
        }
        return new ArrayList<class_1799>();
    }

    public List<class_1799> loadTools(class_1799 stack) {
        if (stack.method_57826(ModDataComponents.TOOLS_CONTAINER)) {
            return new ArrayList<class_1799>(((BackpackContainerContents)stack.method_58694(ModDataComponents.TOOLS_CONTAINER)).getItems().stream().filter(itemStack -> !itemStack.method_7960()).toList());
        }
        return new ArrayList<class_1799>();
    }
}

