/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.collection;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import team.creative.creativecore.client.gui.control.collection.GuiClientComboBoxExtension;
import team.creative.creativecore.client.gui.control.simple.GuiClientLabel;
import team.creative.creativecore.client.gui.extension.GuiExtensionCreator;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.collection.GuiComboBoxExtension;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.list.TupleList;

public class GuiClientComboBox<T extends GuiComboBox<K>, K>
extends GuiClientLabel<T>
implements GuiComboBox.GuiComboBoxDist<K> {
    protected GuiExtensionCreator<GuiClientComboBox<T, K>, GuiComboBoxExtension> ex = new GuiExtensionCreator(this);
    protected TupleList<K, CompiledText> data;
    private int index;
    private K selected;
    private boolean searchbar;
    private GuiExtensionCreator.ExtensionDirection direction = GuiExtensionCreator.ExtensionDirection.BELOW_OR_ABOVE;

    public GuiClientComboBox(T control) {
        super(control);
    }

    @Override
    public boolean hasSearchbar() {
        return this.searchbar;
    }

    protected void updateDisplay() {
        this.text = this.index >= 0 && this.index < this.data.size() ? (CompiledText)((Tuple)this.data.get((int)this.index)).value : CompiledText.EMPTY;
    }

    @Override
    public void setSearchbar(boolean searchbar) {
        this.searchbar = searchbar;
    }

    @Override
    public void setDirection(GuiExtensionCreator.ExtensionDirection direction) {
        this.direction = direction;
    }

    @Override
    public void set(IComponentMap<K> builder, boolean notify) {
        this.data = builder.build();
        this.select(this.index, false);
        for (CompiledText text : this.data.values()) {
            text.setAlign(Align.CENTER);
        }
        this.updateDisplay();
        if (notify) {
            this.raiseEvent(new GuiControlChangedEvent<GuiControl>(this.control));
        }
    }

    @Override
    @Nullable
    public K selected() {
        return this.selected;
    }

    @Override
    public K selected(K defaultValue) {
        K s = this.selected();
        if (s != null) {
            return s;
        }
        return defaultValue;
    }

    @Override
    public void select(int index, boolean notify) {
        this.index = class_3532.method_15340((int)index, (int)0, (int)(this.data.size() - 1));
        this.selected = !this.data.isEmpty() ? ((Tuple)this.data.get((int)this.index)).key : null;
        this.updateDisplay();
        if (notify) {
            this.raiseEvent(new GuiControlChangedEvent<GuiControl>(this.control));
        }
    }

    @Override
    public void select(K key, boolean notify) {
        this.select(this.indexOf(key), notify);
    }

    @Override
    public int indexOf(K key) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (!Objects.equals(((Tuple)this.data.get((int)i)).key, key)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void next() {
        int index = this.index + 1;
        if (index >= this.data.size()) {
            index = 0;
        }
        this.select(index, true);
    }

    @Override
    public void previous() {
        int index = this.index - 1;
        if (index < 0) {
            index = this.data.size() - 1;
        }
        this.select(index, true);
    }

    @Override
    public int selectedIndex() {
        return this.index;
    }

    @Override
    public void flowX(int width, int preferred) {
        for (CompiledText text : this.data.values()) {
            text.setDimension(width, Integer.MAX_VALUE);
        }
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        for (CompiledText text : this.data.values()) {
            text.setMaxHeight(height);
        }
    }

    @Override
    public int preferredWidth(int availableWidth) {
        int width = 0;
        for (CompiledText text : this.data.values()) {
            width = Math.max(width, text.getTotalWidth() + 3);
        }
        return width;
    }

    @Override
    public int preferredHeight(int width, int availableHeight) {
        int height = 0;
        for (CompiledText text : this.data.values()) {
            height = Math.max(height, text.getTotalHeight());
        }
        return height;
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        this.ex.toggle(this::createBox, this.direction);
        this.playSound((class_6880.class_6883<class_3414>)class_3417.field_15015);
        return true;
    }

    @Override
    protected ControlFormatting defaultFormatting() {
        return ControlFormatting.CLICKABLE;
    }

    protected GuiComboBoxExtension createBox(GuiExtensionCreator<GuiClientComboBox<T, K>, GuiComboBoxExtension> creator) {
        GuiComboBoxExtension extension = new GuiComboBoxExtension(((GuiComboBox)this.control).getParent(), ((GuiComboBox)this.control).name + "extension");
        ((GuiClientComboBoxExtension)extension.dist()).init(creator);
        return extension;
    }

    @Override
    public void looseFocus() {
        if (this.ex.checkShouldClose()) {
            this.ex.close();
        }
    }

    public Iterable<CompiledText> lines() {
        return this.data.values();
    }
}

