/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.collection;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import team.creative.creativecore.client.gui.control.menu.GuiClientMenuRoot;
import team.creative.creativecore.client.gui.control.simple.GuiClientLabel;
import team.creative.creativecore.client.gui.extension.GuiExtensionCreator;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.control.collection.GuiComboBoxTree;
import team.creative.creativecore.common.gui.control.menu.GuiMenuRoot;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.type.tree.NamedTree;

public class GuiClientComboBoxTree<T extends GuiComboBoxTree<K>, K>
extends GuiClientLabel<T>
implements GuiComboBoxTree.GuiComboBoxTreeDist<K> {
    protected GuiExtensionCreator<GuiClientComboBoxTree<T, K>, GuiMenuRoot<K>> ex = new GuiExtensionCreator(this);
    protected Function<String, class_2561> title;
    protected NamedTree<K> data;
    private String selectedPath;
    private K selected;
    private boolean searchbar;
    private GuiExtensionCreator.ExtensionDirection direction = GuiExtensionCreator.ExtensionDirection.BELOW_OR_ABOVE;

    public GuiClientComboBoxTree(T control) {
        super(control);
    }

    @Override
    public void init(Function<String, class_2561> title) {
        this.title = title;
    }

    @Override
    public boolean hasSearchbar() {
        return this.searchbar;
    }

    @Override
    public void setSearchbar(boolean searchbar) {
        this.searchbar = searchbar;
    }

    @Override
    public void setDirection(GuiExtensionCreator.ExtensionDirection direction) {
        this.direction = direction;
    }

    @Override
    public void set(NamedTree<K> data, boolean notify) {
        this.data = data;
        this.select(data.first(), notify);
        this.updateDisplay();
    }

    @Override
    @Nullable
    public K selected() {
        return this.selected;
    }

    @Override
    public K selected(K defaultValue) {
        K s = this.selected();
        if (s != null) {
            return s;
        }
        return defaultValue;
    }

    @Override
    public void select(String path, K key, boolean notify) {
        this.selectedPath = path;
        this.selected = key;
        this.updateDisplay();
        if (notify) {
            this.raiseEvent(new GuiControlChangedEvent<GuiControl>(this.control));
        }
    }

    @Override
    public void select(K key, boolean notify) {
        String path = this.data.findPath(key);
        if (path == null) {
            this.select(null, null, notify);
        } else {
            this.select(path, key, notify);
        }
    }

    protected void updateDisplay() {
        this.text = this.text.sameDimensions();
        if (this.selected != null) {
            this.text.setAlign(Align.CENTER);
            this.text.setText(this.title.apply(this.selectedPath));
        }
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        this.ex.toggle(this::createBox, this.direction);
        this.playSound((class_6880.class_6883<class_3414>)class_3417.field_15015);
        return true;
    }

    @Override
    protected ControlFormatting defaultFormatting() {
        return ControlFormatting.CLICKABLE;
    }

    protected GuiMenuRoot<K> createBox(GuiExtensionCreator<GuiClientComboBoxTree<T, K>, GuiMenuRoot<K>> creator) {
        GuiMenuRoot<Object> root = new GuiMenuRoot<Object>(((GuiComboBoxTree)this.control).getParent(), this.data, this.title, (x, y) -> this.select((String)x, (K)y, true));
        ((GuiClientMenuRoot)root.dist()).parent = creator;
        return root;
    }

    @Override
    public void looseFocus() {
        if (this.ex.checkShouldClose()) {
            this.ex.close();
        }
    }
}

