/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.timeline;

import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.client.gui.GuiClientParent;
import team.creative.creativecore.client.gui.GuiControlRect;
import team.creative.creativecore.client.gui.control.parent.GuiClientScrollY;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.control.timeline.GuiTimeline;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineChannel;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineKey;
import team.creative.creativecore.common.gui.style.display.DisplayColor;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.math.vec.SmoothValue;

public class GuiClientTimeline<T extends GuiTimeline>
extends GuiClientParent<T>
implements GuiTimeline.GuiTimelineDist {
    protected static final double MAXIMUM_ZOOM = 10.0;
    public static final StyleDisplay CURSOR_HIGHLIGHT = new DisplayColor(0.78f, 0.78f, 0.0f, 0.59f);
    protected double basePixelWidth;
    protected SmoothValue zoom = new SmoothValue(100L);
    protected SmoothValue scrollX = new SmoothValue(100L);
    private int cachedTimelineWidth;
    private double lastZoom = 0.0;
    protected double maxScrollX;
    protected int timelineOffset = 8;

    public GuiClientTimeline(T control) {
        super(control);
    }

    public double scrolledX() {
        return this.scrollX.current();
    }

    @Override
    public void afterDurationSet() {
        if (this.cachedTimelineWidth != 0) {
            this.updateTickWidth();
        }
        this.adjustKeysPositionX();
        this.scrollX.setStart(0.0);
        this.zoom.setStart(0.0);
    }

    public void resized(int width) {
        this.cachedTimelineWidth = width;
        this.updateTickWidth();
    }

    private void updateTickWidth() {
        this.basePixelWidth = (double)(this.cachedTimelineWidth - this.timelineOffset * 2) / (double)((GuiTimeline)this.control).getDuration();
    }

    public void setLastZoom(double zoom) {
        this.lastZoom = zoom;
    }

    public double getLastZoom() {
        return this.lastZoom;
    }

    @Override
    public void adjustKeyPositionX(GuiTimelineKey key) {
        GuiControlRect rect = ((GuiClientControl)((Object)key.dist())).rect;
        rect.setX(this.timelineOffset + (int)((double)key.tick * this.getTickWidth()) - rect.getWidth() / 2);
    }

    @Override
    public void adjustKeysPositionX() {
        double tickWidth = this.getTickWidth();
        for (GuiTimelineChannel channel : ((GuiTimeline)this.control).channels()) {
            for (GuiControl key : channel) {
                GuiControlRect rect = ((GuiClientControl)key.dist()).rect;
                rect.setX(this.timelineOffset + (int)((double)((GuiTimelineKey)key).tick * tickWidth) - rect.getWidth() / 2);
            }
        }
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        boolean result = super.mouseClicked(x, y, button);
        if (!result && button == 0) {
            ((GuiTimeline)this.control).deselect();
            return false;
        }
        return result;
    }

    @Override
    public void render(class_332 graphics, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        this.zoom.tick();
        this.scrollX.tick();
        super.render(graphics, controlRect, realRect, scale, mouseX, mouseY);
    }

    @Override
    public boolean mouseScrolled(double x, double y, double delta) {
        if (class_437.method_25442()) {
            this.scrollX.set(class_3532.method_15350((double)(this.scrollX.aimed() - delta * 10.0), (double)0.0, (double)this.maxScrollX));
            return true;
        }
        if (class_437.method_25441()) {
            ((GuiClientScrollY)((GuiTimeline)this.control).getChannelParent().dist()).scroll(delta);
            return true;
        }
        return super.mouseScrolled(x, y, delta);
    }

    public void scrolled(int width, double x, double delta) {
        int focusedTick = Math.max(0, this.getTimeAtAimed(x += (double)this.timelineOffset));
        this.zoom.set(class_3532.method_15350((double)(this.zoom.aimed() + delta * this.basePixelWidth * 2.0 * Math.max(this.basePixelWidth * 2.0, this.zoom.aimed()) / 10.0), (double)0.0, (double)10.0));
        int currentTick = Math.max(0, this.getTimeAtAimed(x));
        double aimedTickWidth = this.getTickWidthAimed();
        double sizeX = (double)(this.timelineOffset * 2) + aimedTickWidth * (double)((GuiTimeline)this.control).getDuration();
        this.maxScrollX = Math.max(0.0, sizeX - (double)width);
        this.scrollX.set(class_3532.method_15350((double)(this.scrollX.aimed() + (double)(focusedTick - currentTick) * aimedTickWidth), (double)0.0, (double)this.maxScrollX));
    }

    protected double getTickWidth() {
        return this.basePixelWidth + this.zoom.current();
    }

    protected double getTickWidthAimed() {
        return this.basePixelWidth + this.zoom.aimed();
    }

    public int getTimeAt(double x) {
        double tickWidth = this.getTickWidth();
        return class_3532.method_15340((int)((int)((x - (double)this.timelineOffset + tickWidth / 2.0 + this.scrollX.current()) / tickWidth)), (int)0, (int)((GuiTimeline)this.control).getDuration());
    }

    public int getTimeAtAimed(double x) {
        double tickWidth = this.getTickWidthAimed();
        return class_3532.method_15340((int)((int)((x - (double)this.timelineOffset + tickWidth / 2.0 + this.scrollX.aimed()) / tickWidth)), (int)0, (int)((GuiTimeline)this.control).getDuration());
    }
}

