/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.holder;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;
import net.minecraft.class_7225;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.core.ConfigEqualChecker;
import team.creative.creativecore.common.config.core.ICreativeRegistry;
import team.creative.creativecore.common.config.holder.ConfigHolderDynamic;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;

public class CreativeConfigRegistry
extends ConfigHolderDynamic
implements ICreativeRegistry {
    public static final CreativeConfigRegistry ROOT = new CreativeConfigRegistry();
    public static final Predicate<Field> FIELD_PREDICATE = x -> Modifier.isPublic(x.getModifiers()) && !Modifier.isStatic(x.getModifiers()) && x.isAnnotationPresent(CreativeConfig.class);
    public static final ConfigEqualChecker EQUAL_CHECKER = new ConfigEqualChecker();

    @Override
    public ConfigHolderDynamic registerValue(String key, Object defaultValue) {
        return this.registerValue(key, defaultValue, ConfigSynchronization.UNIVERSAL, false);
    }

    @Override
    public ConfigHolderDynamic registerValue(String key, Object defaultValue, ConfigSynchronization synchronization, boolean requiresRestart) {
        return super.registerValue(key, defaultValue, synchronization, requiresRestart);
    }

    public ICreativeConfigHolder followPath(String ... path) {
        ICreativeConfigHolder current = this;
        for (int i = 0; i < path.length; ++i) {
            ConfigKey field = current.getField(path[i]);
            if (field == null || !field.isFolder()) {
                return null;
            }
            current = field.holder();
        }
        return current;
    }

    public ConfigKey findKey(String[] path) {
        ICreativeConfigHolder current = this;
        for (int i = 0; i < path.length; ++i) {
            if (i + 1 == path.length) {
                return current.getField(path[i]);
            }
            ConfigKey field = current.getField(path[i]);
            if (field == null || !field.isFolder()) {
                return null;
            }
            current = field.holder();
        }
        return null;
    }

    public boolean removeField(String modid) {
        return this.fields.removeKey(modid);
    }

    public static void load(class_7225.class_7874 provider, String modid, Side side) {
        CreativeCore.CONFIG_HANDLER.load(provider, modid, side);
    }

    @Override
    public ConfigEqualChecker getEqualChecker() {
        return EQUAL_CHECKER;
    }

    @Override
    public boolean is(Field field) {
        return FIELD_PREDICATE.test(field);
    }

    @Override
    public ICreativeRegistry getRegistry() {
        return this;
    }
}

